@echo off
cls

rem --- check first parameter
if %1x==/?x goto HELP
if %1x==?x goto HELP

goto START

CONFIG VARIABLES:
These environment variables have to be set up for MVRFAX to work. To avoid
destrying of already existing variables they all begin with the prefix MV_.

MV_PORT .................... comm port (0=COM1, 1=COM2, ...)
MV_ZFXDRV .................. drive where ZFAX/RCVFAX are located
MV_ZFXDIR .................. directory where ZFAX/RCVFAX are located 
                             and faxes are stored                            
MV_DRV ..................... drive where MVRFAX is located
MV_DIR ..................... directory where MVRFAX is located
MV_FSTART .................. command to load/start FOSSIL driver
MV_FSTOP ................... command to remove/stop FOSSIL driver
MV_DIALOUT ................. dial prefix (blanked by _MVRFAX.BAT for local
                             calls)
MV_BEEPLEN ................. length of beep (in .1 secs)
MV_FAXRING ................. number of rings, if NO new fax available
MV_PWD ..................... password (max. 10 digits, separated by spaces)
MV_PWRON ................... .BAT command to turn power on (e.g. hard disk)
MV_PWROFF .................. .BAT command to turn power off (e.g. hard disk)

:START

rem --- Set up configuration
set MV_PORT=0
set MV_ZFXDRV=C:
set MV_ZFXDIR=\ZYXEL\ZFAX
set MV_DRV=C:
set MV_DIR=\MVRFAX
set MV_FSTART=BNU /T:16384 /R:16384 /L%PORT%:19200 /M-
set MV_FSTOP=BNU /U
set MV_DIALOUT=
set MV_BEEPLEN=5
set MV_FAXRING=1
set MV_PWD=1 2 3
set MV_PWRON=
set MV_PWROFF=

rem --- Work variables
set MV_NEWNR=Y
set MV_TELNR=_____________________
set MV_FAXEXST=____
set MV_PWDOK=Y

rem --- Fossil Init
%MV_FSTART%

rem --- Do It
rem     Parameter 1 = /L means last callback number (the one that TELPLAY.BAT stores)
rem     Parameter 2 = /L means local call
rem     Both parameters must be written in UPPERCASE
%COMSPEC% /C _MVRFAX %MV_FAXRING% %1 %2

rem --- Hangup
ZUTIL H /P%MV_PORT% 

rem --- Fossil De-Init
%MV_FSTOP%

rem --- Clean up environment
set MV_TELNR=
set MV_FAXEXST=
set MV_FAXRING=
set MV_PWDOK=
set MV_PORT=
set MV_ZFXDRV=
set MV_ZFXDIR=
set MV_DRV=
set MV_DIR=
set MV_FSTART=
set MV_FSTOP=
set MV_DIALOUT=
set MV_BEEPLEN=
set MV_NEWNR=
set MV_PWD=
set MV_PWRON=
set MV_PWROFF=
goto BYE


:HELP
echo MVRFAX [/L] [/L]
echo        MVRFAX allows control and retrieval of faxes from remote.
echo        Parameter 1 = /L means use last callback number
echo        Parameter 2 = /L means local call (no password needed)
echo        Commands:
echo        0 ... check for faxes
echo        1 ... get callback number
echo        2 ... set callback number
echo        3 ... call back (deliver faxes)
echo        4 ... delete old faxes
echo        5 ... call external program EXTERN.BAT
if not exist TELPLAY.BAT goto BYE
call TELPLAY X
echo        The last callback number is "%MV_TELNR%".
set MV_TELNR=


:BYE

