/* btoa.h */

#define MAXPERLINE      78
#define BUFSIZE         100
#define TRUE            1
#define FALSE           0
#define USE_MACROS      TRUE

#define BYTE            char
#define WORD            short
#define LONG            long

#define ENCODE(ch)      ( (int) ((ch) + '!') )
#define DECODE(ch)      ( (int) ((ch) - '!') )

struct Diagnosis
{
  LONG startpos, endpos;  /* Line before and after erroneous area */
  struct Diagnosis *next, *last;
};


/*
Following functions have been converted to macros:
  calcchecksum()
*/


#if LATTICE  /* Prototypes for Lattice C */

void asciiout(int), exit(int),
     intodiagnosislist(struct Diagnosis *, LONG, LONG),
     outdiagnosislist(struct Diagnosis *, LONG *, LONG *), printhelp(void),
     producediagnosis(struct Diagnosis *, FILE *), wordout(LONG);

BYTE atob(FILE *), btoa(FILE *, BYTE *), copyfile(FILE *, FILE *, BYTE *),
     decode_line(BYTE *, int), new_decodefile(FILE *, LONG *, LONG, int),
     old_decodefile(FILE *, LONG *), performrepair(FILE *),
     producerepair(FILE *), readbuffer(BYTE *, BYTE *, FILE *),
     *truncname(BYTE *);

int  nextbyte(FILE *);

FILE *fopen_read(BYTE *), *fopen_write(BYTE *);

#if USE_MACROS
void calcchecksum(int);
#else
#include "chksum.h"
#endif USE_MACROS

#else !LATTICE  /* For compilers which don't know about prototypes. */

void asciiout(), exit(), intodiagnosislist(), outdiagnosislist(),
     printhelp(), producediagnosis(), wordout();

BYTE atob(), btoa(), copyfile(), decode_line(), new_decodefile(),
     old_decodefile(), performrepair(), producerepair(), readbuffer(),
     *truncname();

int  nextbyte();

FILE *fopen_read(), *fopen_write();

#if USE_MACROS
void calcchecksum();
#else
#include "chksum.h"
#endif USE_MACROS

#endif LATTICE
