/*****************************************************************************
** ADVERT.PRG
**
** ProVision:Windows v1.20 tutorial and demo "advertisment" window
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


STATIC   nTimer                        // id of the countdown timer

STATIC   oAdWnd                        // the window for the "advertisment"



/*****************************************************************************
** Advertisment() --> oAdWnd
**
** This function creates a window in which an "advertisment" for
** ProVision:Windows is periodically displayed.
**
*****************************************************************************/
FUNCTION Advertisment()

   LOCAL GetList  := {}

   LOCAL i


   // If the window has not yet been created, do so.
   IF oAdWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create a window for the message.
      CREATE WINDOW oAdWnd ;
         AT 00, 00 ;
         SIZE 13, 58 ;
         STYLE PWSTYLE_DIALOG - PWSTYLEINFO_SYSTEMMENU ;
         TITLE "ProVision:Windows" ;
         WINDOW HANDLER { | idMsg | AdWndHandler(idMsg) }

      // Display the message.  Better text will be added later.
      @ 01, 01 SAY "                              "
      @ 02, 01 SAY "                          "
      @ 03, 01 SAY "                          "
      @ 04, 01 SAY "                          "
      @ 05, 01 SAY "                        "
      @ 06, 01 SAY "                          "

      // Create a pushbutton to get rid of the window.
      @ 08, 19 GET AS PUSHBUTTON ;
         PROMPT "Let's see more!" ;
         ACTION { || oAdWnd:close() }

      // Attach the controls to the window.
      ATTACH CONTROLS TO oAdWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oAdWnd == NIL

   // Move the window off the left edge of the screen.
   oAdWnd:move((pwMaxRow() - 13) / 2, -58)

   // Open the window modally.
   OPEN WINDOW oAdWnd MODAL

   // Slide the window onto the screen.
   FOR i := -56 TO ((pwMaxCol() / 2) - 27) STEP 2
      oAdWnd:move((pwMaxRow() - 13) / 2, i)
   NEXT i 

   // Install a countdown timer to close the window after 30 seconds if
   // it's not closed by the user first.
   nTimer   := pw():addTimer(PWTIMER_COUNTDOWN, 30, ;
      { || nTimer := NIL, oAdWnd:close() })

   // Return a reference to the new window.
   RETURN(oAdWnd)
   // END Advertisment()



/*****************************************************************************
** STATIC AdWndHandler( idMsg ) --> lHandled
**
** This function is a custom window message handler for oAdWnd.  It
** slides the window off the screen before closing it.
**
*****************************************************************************/
STATIC FUNCTION AdWndHandler( idMsg )

   LOCAL lHandled := .T.

   LOCAL i


   IF idMsg == PWMSG_CLOSE

      // Delete the countdown timer.
      IF nTimer != NIL
         pw():delTimer(nTimer)
      END IF // nTimer != NIL

      // Slide the window off the screen before closing it.
      FOR i := ((pwMaxCol() / 2) - 29) TO (pwMaxCol() + 2) STEP 2
         oAdWnd:move((pwMaxRow() - 13) / 2, i)
      NEXT i 

   END IF // idMsg == PWMSG_CLOSE

   RETURN(lHandled)
   // END AdWndHandler( idMsg )

