/*****************************************************************************
** CALC.PRG
**
** ProVision:Windows v1.20 simple four-function calculator
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "inkey.ch"
#include "pw.ch"
#include "set.ch"


STATIC   cDisplay       := "0", ;      // the contents of the display
         cOperator      := " "         // the current operator being processed

STATIC   nAccumulator   := 0.0         // current value of calculation

STATIC   oEquals, ;                    // the equals button
         oCalcWnd                      // the calculator window



/*****************************************************************************
** Calculator( oItemCalc ) --> oCalcWnd
*****************************************************************************/
FUNCTION Calculator( oItemCalc )

   LOCAL GetList  := {}

   LOCAL cFillColor, ;
         cOldColor


   IF oCalcWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create a window.
      CREATE WINDOW oCalcWnd ;
         AT pwMaxRow() - 21, pwMaxCol() - 25 ;
         SIZE 20, 22 ;
         STYLE PWSTYLE_DIALOG + PWSTYLEINFO_MINIMIZE ;
         TITLE "Calculator" ;
         COLOR IIF(ISCOLOR() .AND. pw():isTMR(PWTMR_BORDERS), ;
            "N/W, W/*N, +W/N, W/*N, W/*N", ) ;
         WINDOW HANDLER { | idMsg | CalcWndHandler(idMsg, oItemCalc) }

      // Draw a fancy "inset" box.
      pwFancyBox(00, 01, 02, 18, IIF(ISCOLOR(), ;
         IIF(pw():isTMR(PWTMR_BORDERS), "W, W, +N, +N, +W, +W", ;
         "B, B, W, W, +W, +W"), "N, N, W, W, +W, +W"))

      // Display the initial value.
      IF VAL(cDisplay) == 0
         @ 01, 02 SAY PADL("0", 16)
      ELSE
         @ 01, 02 SAY PADL(cDisplay, 16)
      END IF // VAL(cDisplay) == 0

      // Temporarily change the color scheme for pushbuttons.
      cFillColor  := IIF(ISCOLOR(), IIF(pw():isTMR(PWTMR_BORDERS), ;
         "W", "B"), "N")
      cOldColor   := pw():getColorscheme():pushbuttonColor
      pw():getColorscheme():pushbuttonColor  := ;
         pvParseList(cOldColor, 1) + "," + ;
         pvParseList(cOldColor, 2) + "," + ;
         pvParseList(cOldColor, 3) + "," + ;
         LEFT(pvParseList(cOldColor, 4), AT("/", ;
            pvParseList(cOldColor, 4))) + cFillColor + "," + ;
         LEFT(pvParseList(cOldColor, 5), AT("/", ;
            pvParseList(cOldColor, 5))) + cFillColor + "," + ;
         pvParseList(cOldColor, 6) + "," + ;
         pvParseList(cOldColor, 7)

      // Create the pushbuttons for the window.
      @ 03, 01 GET AS PUSHBUTTON ;
         PROMPT "C" ;
         ACTION { || ButtonPress("C") } ;
         SHORTCUT ASC("c"), ASC("C"), K_SPACE ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 03, 06 GET AS PUSHBUTTON ;
         PROMPT "/" ;
         ACTION { || ButtonPress("/") } ;
         SHORTCUT ASC("/") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 03, 11 GET AS PUSHBUTTON ;
         PROMPT "*" ;
         ACTION { || ButtonPress("*") } ;
         SHORTCUT ASC("*") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 03, 16 GET AS PUSHBUTTON ;
         PROMPT "-" ;
         ACTION { || ButtonPress("-") } ;
         SHORTCUT ASC("-") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 06, 01 GET AS PUSHBUTTON ;
         PROMPT "7" ;
         ACTION { || ButtonPress("7") } ;
         SHORTCUT ASC("7") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 06, 06 GET AS PUSHBUTTON ;
         PROMPT "8" ;
         ACTION { || ButtonPress("8") } ;
         SHORTCUT ASC("8") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 06, 11 GET AS PUSHBUTTON ;
         PROMPT "9" ;
         ACTION { || ButtonPress("9") } ;
         SHORTCUT ASC("9") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 06, 16 GET AS PUSHBUTTON ;
         PROMPT "+" ;
         SIZE 06, 03 ;
         ACTION { || ButtonPress("+") } ;
         SHORTCUT ASC("+") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 09, 01 GET AS PUSHBUTTON ;
         PROMPT "4" ;
         ACTION { || ButtonPress("4") } ;
         SHORTCUT ASC("4") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 09, 06 GET AS PUSHBUTTON ;
         PROMPT "5" ;
         ACTION { || ButtonPress("5") } ;
         SHORTCUT ASC("5") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 09, 11 GET AS PUSHBUTTON ;
         PROMPT "6" ;
         ACTION { || ButtonPress("6") } ;
         SHORTCUT ASC("6") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 12, 01 GET AS PUSHBUTTON ;
         PROMPT "1" ;
         ACTION { || ButtonPress("1") } ;
         SHORTCUT ASC("1") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 12, 06 GET AS PUSHBUTTON ;
         PROMPT "2" ;
         ACTION { || ButtonPress("2") } ;
         SHORTCUT ASC("2") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 12, 11 GET AS PUSHBUTTON ;
         PROMPT "3" ;
         ACTION { || ButtonPress("3") } ;
         SHORTCUT ASC("3") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 12, 16 GET AS PUSHBUTTON oEquals ;
         PROMPT "=" ;
         SIZE 06, 03 ;
         ACTION { || ButtonPress("=") } ;
         SHORTCUT ASC("=")

      @ 15, 01 GET AS PUSHBUTTON ;
         PROMPT "0" ;
         SIZE 03, 08 ;
         ACTION { || ButtonPress("0") } ;
         SHORTCUT ASC("0") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      @ 15, 11 GET AS PUSHBUTTON ;
         PROMPT "." ;
         ACTION { || ButtonPress(".") } ;
         SHORTCUT ASC(".") ;
         FILTER { | idMsg, nKey | IsEnter(@idMsg, @nKey) }

      // Restore the color scheme for pushbuttons.
      pw():getColorscheme():pushbuttonColor  := cOldColor

      // Attach the controls to the window.
      ATTACH CONTROLS TO oCalcWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oCalcWnd == NIL

   // Open the window.
   OPEN WINDOW oCalcWnd

   // Return a reference to the window.
   RETURN(oCalcWnd)
   // END Calculator( oItemCalc )



/*****************************************************************************
** STATIC CalcWndHandler( idMsg, oItemCalc ) --> lHandled
*****************************************************************************/
STATIC FUNCTION CalcWndHandler( idMsg, oItemCalc )

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      oItemCalc:enable()

   CASE idMsg == PWMSG_OPEN
      oItemCalc:disable()

   END CASE

   RETURN(lHandled)
   // END CalcWndHandler( idMsg, oItemCalc )



/*****************************************************************************
** STATIC IsEnter( @idMsg, @nKey ) --> NIL
*****************************************************************************/
STATIC FUNCTION IsEnter( idMsg, nKey )


   IF idMsg == PWMSG_KEYPRESS
      IF nKey == K_ENTER
         oEquals:event(PWMSG_KEYPRESS, K_ENTER)
         idMsg := PWMSG_NONE
      END IF // nKey == K_ENTER
   END IF // idMsg == PWMSG_KEYPRESS

   RETURN(NIL)
   // END IsEnter( idMsg, nKey )



/*****************************************************************************
** STATIC ButtonPress( cKey ) --> NIL
*****************************************************************************/
STATIC FUNCTION ButtonPress( cKey )

   LOCAL cTemp

   LOCAL xDecimals   := SET(_SET_DECIMALS, 16), ;
         xFixed      := SET(_SET_FIXED, .T.)


   IF cDisplay == "DIV BY 0 ERROR"
      cOperator      := " "
      nAccumulator   := 0.0
      cDisplay       := "0"
   END IF // cDisplay == "DIV BY 0 ERROR"

   DO CASE
   CASE (cKey >= "0") .AND. (cKey <= "9")
      IF cOperator == "="
         cOperator      := " "
         nAccumulator   := 0.0
         cDisplay       := "0"
      END IF // cOperator == "="
      IF  LEN(cDisplay) < 19
         IF "." $ cDisplay
            cDisplay += cKey
         ELSE
            IF LEN(cDisplay) < 9
               IF cDisplay == "0"
                  cDisplay := cKey
               ELSE
                  cDisplay += cKey
               END IF // cDisplay == "0"
            END IF // LEN(cDisplay) < 9
         END IF // "." $ cDisplay
      END IF //  LEN(cDisplay) < 19

   CASE cKey == "."
      IF cOperator == "="
         cOperator      := " "
         nAccumulator   := 0.0
         cDisplay       := "0"
      END IF // cOperator == "="
      IF LEN(cDisplay) < 18
         IF .NOT. ("." $ cDisplay)
            IF LEN(cDisplay) == 0
               cDisplay := "0."
            ELSE
               cDisplay += cKey
            END IF // LEN(cDisplay) == 0
         END IF // .NOT. ("." $ cDisplay)
      END IF // LEN(cDisplay) < 18

   CASE cKey $ "+-*/="
      IF EMPTY(cOperator)
         nAccumulator   := 0
         cOperator      := "+"
      END IF // EMPTY(cOperator)
      IF cOperator == "="
         cTemp := cDisplay
      ELSE
         cTemp := LTRIM(RTRIM(STR(nAccumulator))) + cOperator + cDisplay
      END IF // cOperator == "="
      IF RIGHT(cTemp, 1) == "."
         cTemp := cTemp + "0"
      END IF // RIGHT(cTemp, 1) == "."
      IF (cOperator == "/") .AND. (VAL(cDisplay) == 0.0)
         cOperator      := " "
         nAccumulator   := 0.0
         cDisplay       := "DIV BY 0 ERROR"
      ELSE
         nAccumulator   := &(cTemp)
         IF cKey == "="
            cDisplay := Trim0(LTRIM(RTRIM(STR(nAccumulator))))
         ELSE
            cDisplay := "0"
         END IF // nKey == "="
         cOperator   := cKey
      END IF // (cOperator == "/") .AND. (VAL(cDisplay) == 0.0)

   CASE cKey == "C"
      cOperator      := " "
      nAccumulator   := 0.0
      cDisplay       := "0"

   END CASE

   @ 01, 02 SAY PADL(cDisplay, 16)

   SET(_SET_DECIMALS, xDecimals)
   SET(_SET_FIXED, xFixed)

   RETURN(NIL)
   // END ButtonPress( cKey )



/*****************************************************************************
** STATIC Trim0( cString ) --> cString
*****************************************************************************/
STATIC FUNCTION Trim0( cString )


   IF "." $ cString
      WHILE (RIGHT(cString, 1) $ "0.") .AND. ("." $ cString)
         cString  := LEFT(cString, LEN(cString) - 1)
      END WHILE // (RIGHT(cString, 1) $ "0.") .AND. ("." $ cString)
   END IF // "." $ cString

   RETURN(cString)
   // END Trim0( cString )

