/*****************************************************************************
** CLOCK.PRG
**
** ProVision:Windows v1.20 digital clock
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


STATIC   l12Hour  := .T.               // .T. if 12-hour format is selected

STATIC   oClockWnd                     // the clock window



/*****************************************************************************
** Clock( oItemClock ) --> oClockWnd
*****************************************************************************/
FUNCTION Clock( oItemClock )

   LOCAL o12Hour, ;
         o24Hour, ;
         oMenu


   IF oClockWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create a window.
      CREATE WINDOW oClockWnd ;
         AT 01, pwMaxCol() - 20 ;
         SIZE 05, 19 ;
         STYLE PWSTYLE_DIALOG + PWSTYLEINFO_MENU ;
         BORDERS PWBORDER_T ;
         TITLE "Clock" ;
         COLOR IIF(ISCOLOR() .AND. pw():isTMR(PWTMR_BORDERS), ;
            "N/W, W/*N, +W/N, W/*N, W/*N", ) ;
         WINDOW HANDLER { | idMsg | ClockWndHandler(idMsg, oItemClock) }

      // Draw a fancy "inset" box.
      pwFancyBox(00, 02, 02, 16, IIF(ISCOLOR(), ;
         IIF(pw():isTMR(PWTMR_BORDERS), "W, W, +N, +N, +W, +W", ;
         "B, B, W, W, +W, +W"), "N, N, W, W, +W, +W"))

      // Create a menu for the window.
      MENU oMenu ;
            COLOR IIF(ISCOLOR() .AND. pw():isTMR(PWTMR_BORDERS), ;
               "W/*N, +W/N, +W/*N, +N/W, +N/N", )

         POPUP PROMPT "~Options"
            MENUITEM o12Hour PROMPT " ~12-hour" ;
               CHECKED ;
               ACTION { || l12Hour := .T., ;
                  o12Hour:setValue(.T.), ;
                  o24Hour:setValue(.F.) }
            MENUITEM o24Hour PROMPT " ~24-hour" ;
               UNCHECKED ;
               ACTION { || l12Hour := .F., ;
                  o12Hour:setValue(.F.), ;
                  o24Hour:setValue(.T.) }
         END POPUP // Options

      END MENU // oMenu

      // Attach the menu to the window.
      ATTACH MENU oMenu TO oClockWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oClockWnd == NIL

   // Open the window.
   OPEN WINDOW oClockWnd

   // Return a reference to the window.
   RETURN(oClockWnd)
   // END Clock( oItemClock )



/*****************************************************************************
** STATIC ClockWndHandler( idMsg, oItemClock ) --> lHandled
*****************************************************************************/
STATIC FUNCTION ClockWndHandler( idMsg, oItemClock )

   STATIC   nTimerID

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      oItemClock:enable()

      // Remove the timer for the clock.
      pw():delTimer(nTimerID)

   CASE idMsg == PWMSG_OPEN
      oItemClock:disable()

      // Add a timer for the clock.
      nTimerID := pw():addTimer(PWTIMER_PERIODIC, 1, { || ClockDisplay() })

   END CASE

   RETURN(lHandled)
   // END ClockWndHandler( idMsg, oItemClock )



/*****************************************************************************
** STATIC ClockDisplay() --> NIL
*****************************************************************************/
STATIC FUNCTION ClockDisplay()

   LOCAL cTime := TIME()

   LOCAL oOutput


   // Create a string containing the current time in the appropriate format.
   IF l12Hour

      // 12-hour format
      IF cTime > "12:59:59"
         cTime := STR(VAL(SUBSTR(cTime, 1, 2)) - 12, 2, 0) + ;
            SUBSTR(cTime, 3) + " p.m."
      ELSEIF cTime < "01:00:00"
         cTime := "12" + SUBSTR(cTime, 3) + " a.m."
      ELSEIF cTime < "12:00:00"
         cTime := cTime + " a.m."
      ELSE
         cTime := "12" + SUBSTR(cTime, 3) + " p.m."
      END IF // cTime > "12:59:59"

   END IF // l12Hour

   // Save the current output window without affecting the current cursor
   // and/or color settings.
   oOutput  := pw():setOutput(oClockWnd, .F.)

   // Display the time.
   pwWriteStr(PWRW_TEXT, 01, 03, PADC(cTime, 13))

   // Restore the previous output window without affecting the current
   // cursor and/or color settings.
   pw():setOutput(oOutput, .F.)

   RETURN(NIL)
   // END ClockDisplay()

