/*****************************************************************************
** CONTROLS.PRG
**
** ProVision:Windows v1.20 demo of using controls
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)


STATIC   oCtrlWnd                      // the sample window



/*****************************************************************************
** CtrlFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the Using controls topic.
**
*****************************************************************************/
FUNCTION CtrlFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := CtrlList()

   LOCAL lContinue   := .T.


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame < 1
      // If the sample window is still open, close it.
      IF (oCtrlWnd != NIL) .AND. ;
            pvGetBit(oCtrlWnd:getState(), PWSTATE_OPEN)
         oCtrlWnd:close()
      END IF // (oCtrlWnd != NIL) .AND. ...

   CASE nFrame == 1
      // Open the sample window, but reselect the topics window.
      DISPBEGIN()
      CtrlWindow()
      pw():select(oTopicWnd)
      DISPEND()

      // Display the message for this frame.
      MsgBox("This topic covers creating and using input controls." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("ProVision:Windows goes beyond the GET system of standard " + ;
         "Clipper and provides several mechanisms for user input.  These " + ;
         "are known as 'input controls' and use a command syntax similar " + ;
         "to the standard GET syntax." + CRLF + ;
         CRLF + ;
         "Input controls are represented by objects.  When creating an " + ;
         "input control you may supply a memory variable to store a " + ;
         "reference to the input control object.")

   CASE nFrame == 3
      // Display the message for this frame.
      MsgBox("Just like in standard Clipper, you should declare a " + ;
         "LOCAL GetList := {} at the beginning of a function that " + ;
         "will create a window with input controls." + CRLF + ;
         CRLF + ;
         "Seven classes of input controls are included with " + ;
         "ProVision:Windows v1.20:  browseboxes, checkboxes, listboxes, " + ;
         "menus, pushbuttons, radiobuttons, and textfields.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   LOCAL GetList := {}'))

   CASE nFrame == 4
      // Display the message for this frame.
      MsgBox("When you create a browsebox, you must supply a reference " + ;
         "to a previously created TBROWSE object.  ProVision:Windows " + ;
         "will take this TBROWSE and place it inside the browsebox where " + ;
         "it can be manipulated by the user using either the keyboard or " + ;
         "the mouse.  You no longer need to code the standard polling/" + ;
         "stabilize loop for the TBROWSE; you only have to handle the " + ;
         "exception keys (such as Del to delete the current line).  " + ;
         "Browseboxes have no explicit value.")

   CASE nFrame == 5
      // Display the message for this frame.
      MsgBox("Checkboxes are used to get logical input.  If the box is " + ;
         "checked (with an 'X'), the value of the checkbox is .T., " + ;
         "otherwise it is .F.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 04, 01 GET lPaid AS CHECKBOX oPaid ;'))

   CASE nFrame == 6
      // Display the message for this frame.
      MsgBox("Listboxes are a sort of 'special case' of browseboxes; " + ;
         "they are a browse on a single-dimensional array.  When you " + ;
         "create a listbox, you must supply a reference to an array.  " + ;
         "ProVision:Windows will take this array and place it inside " + ;
         "the listbox where the user can select one of the elements.  " + ;
         "The value of a listbox is the number of the selected element, " + ;
         "or 0 if the array is empty.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 01, 22 GET nFruit AS LISTBOX oFruit ;'))

   CASE nFrame == 7
      // Display the message for this frame.
      MsgBox("ProVision:Windows has a very easy syntax for the creation " + ;
         "of CUA-style menus.  Any window that has a menu as part of its " + ;
         "style can have a menu object attached to it.  The menu itself " + ;
         "is defined with the MENU.../END MENU construct.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      MENU oMenu'))

   CASE nFrame == 8
      // Display the message for this frame.
      MsgBox("Within the menu declaration, popups are defined similarly " + ;
         "with the POPUP.../END POPUP construct.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '         POPUP PROMPT "~File"'))

   CASE nFrame == 9
      // Display the message for this frame.
      MsgBox("Popups contain one or more menuitems.  Lines separating " + ;
         "menuitems are easy to insert.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '            MENUITEM PROMPT "~New..."'))

   CASE nFrame == 10
      // Display the message for this frame.
      MsgBox("Pushbuttons are used to initiate an action.  Most windows " + ;
         "you create will probably have 'OK' and 'Cancel' pushbuttons.  " + ;
         "The value of a pushbutton is .T. if it has _ever_ been pushed " + ;
         "and .F. otherwise.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 05, 06 GET AS PUSHBUTTON oOK ;'))

   CASE nFrame == 11
      // Display the message for this frame.
      MsgBox("Radiobuttons are used to get numeric input when the " + ;
         "number of possible selections is small.  When you create a " + ;
         "set of radiobuttons only one member of the set can be " + ;
         "'pushed' at a time.  This is how the station selection " + ;
         "buttons on most car radios work, and that is how " + ;
         "radiobuttons got their name.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 02, 01 GET nWorkHome AS RADIOBUTTONS oWorkHome ;'))

   CASE nFrame == 12
      // Display the message for this frame.
      MsgBox("Textfields are the closest ProVision:Windows equivalent " + ;
         "to standard GETs since they are implemented using standard " + ;
         "GET objects, but textfields provide additional features such " + ;
         "as automatic prompts, shortcut keys, and mouse support.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 01, 01 GET cPhone AS TEXTFIELD oPhone ;'))

   CASE nFrame == 13
      // Display the message for this frame.
      MsgBox("Input controls are first created then attached to a " + ;
         "window.  This is similar to the way standard GETs are " + ;
         "created and then activated with READ.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      ATTACH CONTROLS TO oCtrlWnd'))

   CASE nFrame == 14
      // Display the message for this frame.
      MsgBox("In ProVision:Windows, however, once the input controls " + ;
         "are attached to a window, execution doesn't pause as it " + ;
         "does with the READ command.  Code that would have been placed " + ;
         "after the READ command must now be placed so that it is " + ;
         "controlled by the events that occur in the window.  One " + ;
         "natural place for this is the action of an 'OK' pushbutton.")

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END CtrlFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC CtrlList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Using controls."
**
*****************************************************************************/
STATIC FUNCTION CtrlList()

   STATIC   aListing[121]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** CONTROLS.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of using controls'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := '#include "pw.ch"'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := 'STATIC oCtrlWnd'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** CtrlWindow() --> oCtrlWnd'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function demonstrates several of the input controls in'
      aListing[i++]  := '** ProVision:Windows v1.20.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'FUNCTION CtrlWindow()'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL GetList := {}'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL cPhone'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL lPaid'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL nFruit, ;'
      aListing[i++]  := '         nWorkHome'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL oFruit, ;'
      aListing[i++]  := '         oMenu, ;'
      aListing[i++]  := '         oOK, ;'
      aListing[i++]  := '         oPaid, ;'
      aListing[i++]  := '         oPhone, ;'
      aListing[i++]  := '         oWorkHome'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // If the window has not been created, do so.'
      aListing[i++]  := '   IF oCtrlWnd == NIL'
      aListing[i++]  := ''
      aListing[i++]  := '      // Turn the mouse cursor into an hourglass.'
      aListing[i++]  := '      pw():mouseCursor(PMCURSOR_HOUR)'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create the window.'
      aListing[i++]  := '      CREATE WINDOW oCtrlWnd ;'
      aListing[i++]  := '         AT 01, pwMaxCol() / 2 ;'
      aListing[i++]  := '         SIZE 11, 39 ;'
      aListing[i++]  := '         STYLE PWSTYLE_DIALOG + PWSTYLEINFO_MENU ;'
      aListing[i++]  := '         TITLE "Input controls"'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create a menu.'
      aListing[i++]  := '      MENU oMenu'
      aListing[i++]  := ''
      aListing[i++]  := '         POPUP PROMPT "~File"'
      aListing[i++]  := '            MENUITEM PROMPT "~New..."'
      aListing[i++]  := '            MENUITEM PROMPT "~Open..."'
      aListing[i++]  := '            MENUITEM PROMPT "~Close" ;'
      aListing[i++]  := '               DISABLED'
      aListing[i++]  := '            SEPARATOR'
      aListing[i++]  := '            MENUITEM PROMPT "~Print..." ;'
      aListing[i++]  := '               DISABLED'
      aListing[i++]  := '            SEPARATOR'
      aListing[i++]  := '            MENUITEM PROMPT "E~xit\tAlt+F4"'
      aListing[i++]  := '         END POPUP // File'
      aListing[i++]  := ''
      aListing[i++]  := '         pwEditMenu()'
      aListing[i++]  := ''
      aListing[i++]  := '      END MENU // oMenu'
      aListing[i++]  := ''
      aListing[i++]  := '      // Attach the menu to the window.'
      aListing[i++]  := '      ATTACH MENU oMenu TO oCtrlWnd'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create a textfield.'
      aListing[i++]  := '      @ 01, 01 GET cPhone AS TEXTFIELD oPhone ;'
      aListing[i++]  := '         PROMPT "Pho~ne: " ;'
      aListing[i++]  := '         PICTURE "###/###-####" ;'
      aListing[i++]  := '         INITIAL "   /   -    "'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create some radiobuttons.'
      aListing[i++]  := '      @ 02, 01 GET nWorkHome AS RADIOBUTTONS oWorkHome ;'
      aListing[i++]  := '         PROMPT { "~Work", "~Home" }'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create a checkbox.'
      aListing[i++]  := '      @ 04, 01 GET lPaid AS CHECKBOX oPaid ;'
      aListing[i++]  := '         PROMPT "~Paid in full"'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create a pushbutton.'
      aListing[i++]  := '      @ 05, 06 GET AS PUSHBUTTON oOK ;'
      aListing[i++]  := '         PROMPT "  OK  " '
      aListing[i++]  := ''
      aListing[i++]  := '      // Create a listbox.'
      aListing[i++]  := '      @ 01, 22 GET nFruit AS LISTBOX oFruit ;'
      aListing[i++]  := '         SIZE 07, 14 ;'
      aListing[i++]  := '         PROMPT "F~ruit:" ;'
      aListing[i++]  := '         USING { "Apples", "Bananas", "Grapes", "Lemons", "Mangos", ;'
      aListing[i++]  := '            "Peaches", "Pears", "Raspberries", "Tangerines" }'
      aListing[i++]  := ''
      aListing[i++]  := '      // Attach the controls to the window.'
      aListing[i++]  := '      ATTACH CONTROLS TO oCtrlWnd'
      aListing[i++]  := ''
      aListing[i++]  := '      // Turn the mouse cursor back into an arrow.'
      aListing[i++]  := '      pw():mouseCursor(PMCURSOR_ARROW)'
      aListing[i++]  := ''
      aListing[i++]  := '   END IF // oCtrlWnd == NIL'
      aListing[i++]  := ''
      aListing[i++]  := '   // Open the window.'
      aListing[i++]  := '   OPEN WINDOW oCtrlWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Return a reference to the window.'
      aListing[i++]  := '   RETURN(oCtrlWnd)'
      aListing[i++]  := '   // END CtrlWindow()'
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END CtrlList()



/*****************************************************************************
** STATIC CtrlWindow() --> oCtrlWnd
**
** This function creates and opens the sample window for this topic.
**
*****************************************************************************/
STATIC FUNCTION CtrlWindow()

   LOCAL GetList  := {}

   LOCAL lPaid

   LOCAL cPhone

   LOCAL nFruit, ;
         nWorkHome

   LOCAL oFruit, ;
         oMenu, ;
         oOK, ;
         oPaid, ;
         oPhone, ;
         oWorkHome


   // If the window has not been created, do so.
   IF oCtrlWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create the window.
      CREATE WINDOW oCtrlWnd ;
         AT 01, pwMaxCol() / 2 ;
         SIZE 11, 39 ;
         STYLE PWSTYLE_DIALOG + PWSTYLEINFO_MENU ;
         TITLE "Input controls"

      // Create a menu.
      MENU oMenu

         POPUP PROMPT "~File"
            MENUITEM PROMPT "~New..."
            MENUITEM PROMPT "~Open..."
            MENUITEM PROMPT "~Close" ;
               DISABLED
            SEPARATOR
            MENUITEM PROMPT "~Print..." ;
               DISABLED
            SEPARATOR
            MENUITEM PROMPT "E~xit\tAlt+F4"
         END POPUP // File

         pwEditMenu()

      END MENU // oMenu

      // Attach the menu to the window.
      ATTACH MENU oMenu TO oCtrlWnd

      // Create a textfield.
      @ 01, 01 GET cPhone AS TEXTFIELD oPhone ;
         PROMPT "Pho~ne: " ;
         PICTURE "###/###-####" ;
         INITIAL "   /   -    "

      // Create some radiobuttons.
      @ 02, 01 GET nWorkHome AS RADIOBUTTONS oWorkHome ;
         PROMPT { "~Work", "~Home" }

      // Create a checkbox.
      @ 04, 01 GET lPaid AS CHECKBOX oPaid ;
         PROMPT "~Paid in full"

      // Create a pushbutton.
      @ 05, 06 GET AS PUSHBUTTON oOK ;
         PROMPT "  OK  " 

      // Create a listbox.
      @ 01, 22 GET nFruit AS LISTBOX oFruit ;
         SIZE 07, 14 ;
         PROMPT "F~ruit:" ;
         USING { "Apples", "Bananas", "Grapes", "Lemons", "Mangos", ;
            "Peaches", "Pears", "Raspberries", "Tangerines" }

      // Attach the controls to the window.
      ATTACH CONTROLS TO oCtrlWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oCtrlWnd == NIL

   // Open the window.
   OPEN WINDOW oCtrlWnd

   // Return a reference to the window.
   RETURN(oCtrlWnd)
   // END CtrlWindow()

