/*****************************************************************************
** CUSTEDIT.PRG
**
** ProVision:Windows v1.20 customer edit sample
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "inkey.ch"
#include "pw.ch"
#include "tutor.ch"



/*****************************************************************************
** EditWindow( lAppend, oBrowseWnd ) --> NIL
**
** This opens a window in which you may edit the current record.
**
*****************************************************************************/
FUNCTION EditWindow( lAppend, oBrowseWnd )

   LOCAL GetList  := {}

   LOCAL nRecNo

   LOCAL oMenu, ;
         oOK


   // Save this for later.
   oBrowseWnd:cargo[BROWSE_APPEND]  := lAppend

   // If appending, we'll save the current record number, then use the
   // phantom record for blanks.  (This technique is strictly single-user!)
   IF lAppend

      nRecNo   := Customer->(RECNO())
      Customer->(DBGOBOTTOM())
      Customer->(DBSKIP(+01))

   ELSE

      // Make sure this record isn't being edited by another process.
      IF .NOT. AddEditList(Customer->(RECNO()))
         OKBox("This record is currently being updated by another process.")
         RETURN(NIL)
      END IF // .NOT. AddEditList(RECNO())

   END IF // lAppend


   // Turn the mouse cursor into an hourglass (or display a wait message).
   WaitMsg(.T.)

   // Create one instance of the edit window for the browse window.
   IF oBrowseWnd:cargo[BROWSE_EDITWND] == NIL

      // Create the window if it doesn't exist.
      CREATE WINDOW oBrowseWnd:cargo[BROWSE_EDITWND] ;
         CENTERED ;
         SIZE 22, 64 ;
         TITLE "Customer Edit" ;
         STYLE PWSTYLE_SECONDARY + PWSTYLEINFO_HELPLINE ;
         WINDOW HANDLER { | idMsg, _1, _2, _3, _4, oWnd | ;
            EditWndHandler(idMsg, oWnd) }

      // Store the browse window in the edit window's cargo.
      oBrowseWnd:cargo[BROWSE_EDITWND]:cargo := oBrowseWnd

      // Turn on autoscrolling for this window.
      oBrowseWnd:cargo[BROWSE_EDITWND]:autoScroll(.T.)

      // Create a menu for the window.
      MENU oMenu

         POPUP PROMPT "~Record"
            MENUITEM PROMPT "~Save\tEnter" ;
               ACTION { || SaveRecord(oBrowseWnd), ;
                  oBrowseWnd:cargo[BROWSE_EDITWND]:close() }
            MENUITEM PROMPT "~Cancel\tEsc" ;
               ACTION { || oBrowseWnd:cargo[BROWSE_EDITWND]:close() }
         END POPUP // File

         pwEditMenu()

      END MENU // oMenu

      // Attach the menu to the window.
      ATTACH MENU oMenu TO oBrowseWnd:cargo[BROWSE_EDITWND]

      // Now let's create the input controls for the window.
      @ 01, 01 GET AS TEXTFIELD ;
         PROMPT "Customer #: " ;
         PICTURE "#####" ;
         INITIAL Customer->CustNmbr ;
         HELPLINE "Customer # as displayed on invoice"

      @ 01, 50 GET AS CHECKBOX ;
         PROMPT "Active" ;
         INITIAL Customer->Active ;
         HELPLINE "Checked if customer ordered within 90 days"

      @ 02, 01 GET AS TEXTFIELD ;
         PROMPT ABOVE "Company:" ;
         INITIAL Customer->Company ;
         HELPLINE "Company name"

      @ 02, 38 GET AS TEXTFIELD ;
         PROMPT ABOVE "Division:" ;
         INITIAL Customer->Division ;
         HELPLINE "Company division"

      @ 04, 01 GET AS TEXTFIELD ;
         PROMPT ABOVE "Contact:" ;
         INITIAL Customer->Contact ;
         HELPLINE "Purchasing agent or other contact"

      @ 05, 38 GET AS RADIOBUTTONS ;
         PROMPT { "Mr.", "Ms.", "Dr." } ;
         HORIZONTAL ;
         INITIAL MAX(Customer->Salute, 1) ;
         HELPLINE "Salutation prefix for correspondence"

      @ 06, 01 GET AS TEXTFIELD ;
         PROMPT ABOVE "Address:" ;
         INITIAL Customer->Addr1 ;
         HELPLINE "First line of billing address"

      @ 08, 01 GET AS TEXTFIELD ;
         INITIAL Customer->Addr2 ;
         HELPLINE "Second line of billing address"

      @ 09, 01 GET AS TEXTFIELD ;
         INITIAL Customer->City ;
         HELPLINE "City of billing address"

      @ 09, 26 GET AS TEXTFIELD ;
         PROMPT ", " ;
         INITIAL Customer->State ;
         HELPLINE "State of billing address"

      @ 07, 37 GET AS TEXTFIELD ;
         PROMPT ABOVE "Country:" ;
         INITIAL Customer->Country ;
         HELPLINE "Country of billing address"

      @ 09, 49 GET AS TEXTFIELD ;
         INITIAL Customer->Zip ;
         HELPLINE "Zip code of billing address"

      // Here's just a normal SAY!
      @ 10, 01 SAY "Phones:"

      @ 11, 01 GET AS TEXTFIELD ;
         PROMPT "Home: " ;
         PICTURE "###/###-####" ;
         INITIAL Customer->HomePhone ;
         HELPLINE "Contact's home voice phone"

      @ 12, 01 GET AS TEXTFIELD ;
         PROMPT "Work: " ;
         PICTURE "###/###-####" ;
         INITIAL Customer->WorkPhone ;
         HELPLINE "Contact's work voice phone"

      @ 13, 02 GET AS TEXTFIELD ;
         PROMPT "Car: " ;
         PICTURE "###/###-####" ;
         INITIAL Customer->CarPhone ;
         HELPLINE "Contact's mobile phone"

      @ 14, 02 GET AS TEXTFIELD ;
         PROMPT "FAX: " ;
         PICTURE "###/###-####" ;
         INITIAL Customer->FAXPhone ;
         HELPLINE "Contact's facsimile machine phone"

      @ 15, 04 GET AS SPINNER ;
         USING { 10, 30, 90 } ;
         PROMPT "Terms: " ;
         PICTURE "##" ;
         INITIAL Customer->Terms ;
         HELPLINE "Billing terms"

      @ 16, 01 GET AS TEXTFIELD ;
         PROMPT "Discount: " ;
         PICTURE "##" ;
         INITIAL Customer->Discount ;
         HELPLINE "Discount percentage, if any"

      @ 10, 21 GET AS TEXTEDIT ;
         SIZE 07, 28 ;
         PROMPT "Notes:" ;
         HELPLINE "Notes for this customer"
      ATAIL(GetList):store(0, Customer->Notes)
      ATAIL(GetList):display()

      @ 11, 51 GET AS PUSHBUTTON oOK ;
         PROMPT "  OK  " ;
         ACTION { || SaveRecord(oBrowseWnd), ;
            oBrowseWnd:cargo[BROWSE_EDITWND]:close() } ;
         HELPLINE "Save all changes!"

      @ 14, 51 GET AS PUSHBUTTON ;
         PROMPT "Cancel" ;
         ACTION { || oBrowseWnd:cargo[BROWSE_EDITWND]:close() } ;
         SHORTCUT K_ESC ;
         HELPLINE "Cancel all changes!"

      // Now we attach the controls to the window.  The "OK" pushbutton will
      // be our default action.  Note that this step also sets the GetList
      // variable to an empty array ({}).
      ATTACH CONTROLS TO oBrowseWnd:cargo[BROWSE_EDITWND] ;
         DEFAULT ACTION oOK

   ELSE

      // Refresh the values of the input controls and redisplay them.
      GetList  := oBrowseWnd:cargo[BROWSE_EDITWND]:getGetList()
      GetList[01]:setValue(Customer->CustNmbr)
      GetList[02]:setValue(Customer->Active)
      GetList[03]:setValue(Customer->Company)
      GetList[04]:setValue(Customer->Division)
      GetList[05]:setValue(Customer->Contact)
      GetList[06]:setValue(MAX(Customer->Salute, 1))
      GetList[07]:setValue(Customer->Addr1)
      GetList[08]:setValue(Customer->Addr2)
      GetList[09]:setValue(Customer->City)
      GetList[10]:setValue(Customer->State)
      GetList[11]:setValue(Customer->Country)
      GetList[12]:setValue(Customer->Zip)
      GetList[13]:setValue(Customer->HomePhone)
      GetList[14]:setValue(Customer->WorkPhone)
      GetList[15]:setValue(Customer->CarPhone)
      GetList[16]:setValue(Customer->FAXPhone)
      GetList[17]:setValue(Customer->Terms)
      GetList[18]:setValue(Customer->Discount)
      GetList[19]:store(0, Customer->Notes)
      GetList[19]:display()

      // Now give input focus to the first input control.
      oBrowseWnd:cargo[BROWSE_EDITWND]:select(GetList[1])

   END IF // oBrowseWnd:cargo[BROWSE_EDITWND] == NIL

   // Restore the previous record number if appending.
   IF lAppend
      Customer->(DBGOTO(nRecNo))
   END IF // lAppend

   // Open the window.  Everything to this point has been invisible to the
   // user.
   OPEN WINDOW oBrowseWnd:cargo[BROWSE_EDITWND]

   // By disabling the browse window (and the search window if it is
   // open) we have the effect of the edit window being modal to the
   // browse window but not modal to the system.
   IF (oBrowseWnd:cargo[BROWSE_SEARCHWND] != NIL) .AND. ;
         pvGetBit(oBrowseWnd:cargo[BROWSE_SEARCHWND]:getState(), PWSTATE_OPEN)
      DISABLE WINDOW oBrowseWnd:cargo[BROWSE_SEARCHWND]
   END IF // (oBrowseWnd:cargo[BROWSE_SEARCHWND] != NIL) .AND. ...
   DISABLE WINDOW oBrowseWnd

   // Restore the mouse cursor (or remove the wait message).
   WaitMsg(.F.)

   RETURN(NIL)
   // END EditWindow( lAppend, oBrowseWnd )



/*****************************************************************************
** STATIC EditWndHandler( idMsg, oEditWnd ) --> lHandled
**
** This implements the window handler for the edit window and is responsible
** for giving the appearance of the edit window being modal to the browse
** window.  The proper workarea and record number must also be restored when
** the edit window receives focus.  If the window receives a PWMSG_TIMEOUT
** message it closes.
**
*****************************************************************************/
STATIC FUNCTION EditWndHandler( idMsg, oEditWnd )

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      // Since we have disabled the browse window (and the search window if
      // it is open) while the edit was open, we must reenable the windows
      // upon closing the edit window.
      IF (oEditWnd:cargo:cargo[BROWSE_SEARCHWND] != NIL) .AND. ;
            pvGetBit(oEditWnd:cargo:cargo[BROWSE_SEARCHWND]:getState(), ;
            PWSTATE_OPEN)
         ENABLE WINDOW oEditWnd:cargo:cargo[BROWSE_SEARCHWND]
      END IF // (oEditWnd:cargo:cargo[BROWSE_SEARCHWND] != NIL) .A...
      ENABLE WINDOW oEditWnd:cargo

      IF .NOT. oEditWnd:cargo:cargo[BROWSE_APPEND]
         // Remove this record from the list of records being edited.
         DelEditList(Customer->(RECNO()))
      END IF // .NOT. oEditWnd:cargo:cargo[BROWSE_APPEND]

   CASE idMsg == PWMSG_SETFOCUS
      // Restore the proper workarea and record number.
      SELECT Customer
      GO oEditWnd:cargo:cargo[BROWSE_RECNO]

   CASE idMsg == PWMSG_TIMEOUT
      // Close the window.
      oEditWnd:close()

   END CASE

   RETURN(lHandled)
   // END EditWndHandler( idMsg, oEditWnd )



/*****************************************************************************
** STATIC SaveRecord( oBrowseWnd ) --> NIL
**
** This writes the values of the controls to the current record.  If
** lAppend is .T., this appends a new record first.  It then stabilizes the
** TBROWSE and refreshes the scrollbars in the browse window.
**
*****************************************************************************/
STATIC FUNCTION SaveRecord( oBrowseWnd )

   LOCAL GetList  := oBrowseWnd:cargo[BROWSE_EDITWND]:getGetList()


   // Turn the mouse cursor into an hourglass (or display a wait message).
   WaitMsg(.T.)

   // If appending0 4d: 1 5e:o5d6  Save this new record number as the
   // browse window's current record.
   IF oBrowseWnd:cargo[BROWSE_APPEND]
      APPEND BLANK
      oBrowseWnd:cargo[BROWSE_RECNO]   := Customer->(RECNO())
   END IF // oBrowseWnd:cargo[BROWSE_APPEND]

   // Save the values of the input controls to the proper fields.
   REPLACE Customer->CustNmbr    WITH GetList[01]:getValue()
   REPLACE Customer->Active      WITH GetList[02]:getValue()
   REPLACE Customer->Company     WITH GetList[03]:getValue()
   REPLACE Customer->Division    WITH GetList[04]:getValue()
   REPLACE Customer->Contact     WITH GetList[05]:getValue()
   REPLACE Customer->Salute      WITH GetList[06]:getValue()
   REPLACE Customer->Addr1       WITH GetList[07]:getValue()
   REPLACE Customer->Addr2       WITH GetList[08]:getValue()
   REPLACE Customer->City        WITH GetList[09]:getValue()
   REPLACE Customer->State       WITH GetList[10]:getValue()
   REPLACE Customer->Country     WITH GetList[11]:getValue()
   REPLACE Customer->Zip         WITH GetList[12]:getValue()
   REPLACE Customer->HomePhone   WITH GetList[13]:getValue()
   REPLACE Customer->WorkPhone   WITH GetList[14]:getValue()
   REPLACE Customer->CarPhone    WITH GetList[15]:getValue()
   REPLACE Customer->FAXPhone    WITH GetList[16]:getValue()
   REPLACE Customer->Terms       WITH GetList[17]:getValue()
   REPLACE Customer->Discount    WITH GetList[18]:getValue()
   REPLACE Customer->Notes       WITH GetList[19]:retrieve(0)
   COMMIT

   // Now refresh the browse window.
   Customer->(RefreshTBROWSE(oBrowseWnd))

   // Restore the mouse cursor (or remove the wait message).
   WaitMsg(.F.)

   RETURN(NIL)
   // END SaveRecord( oBrowseWnd )

