/*****************************************************************************
** EVENTS.PRG
**
** ProVision:Windows v1.20 demo of events and messages
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)



/*****************************************************************************
** EventsFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the Events and messages topic.
**
*****************************************************************************/
FUNCTION EventsFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := EventsList()

   LOCAL lContinue   := .T.


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame == 1
      // Display the message for this frame.
      MsgBox("This topic covers window message handlers, window event " + ;
         "handlers, and message filters." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("When a window is manipulated, either programatically or by " + ;
         "the user, messages are sent to the window object.  There are " + ;
         "two different types of messages:  window messages and event " + ;
         "messages.  Normally, all messages are handled internally by " + ;
         "ProVision:Windows.  However, it is possible for the messages " + ;
         "to be intercepted by a program via message handlers and " + ;
         "filters.")

   CASE nFrame == 3
      // Display the message for this frame.
      MsgBox("Window message handlers, window event handlers, and " + ;
         "filters are specified as code blocks which will receive five " + ;
         "parameters from ProVision:Windows:  a message ID and up to " + ;
         "four message parameters.  The possible message IDs begin " + ;
         "with 'PWMSG_' and are defined in PW.CH.  The handlers are " + ;
         "for notification only, while filters may actually intercept " + ;
         "messages before they are processed by ProVision:Windows.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '#include "pw.ch"'))

   CASE nFrame == 4
      // Display the message for this frame.
      MsgBox("Each window can have a window message handler, specified " + ;
         "when the window is created.  The window message handler " + ;
         "receives notification when the window is moved, sized, or " + ;
         "otherwise manipulated.  A window message handler is also " + ;
         "responsible for saving any environmental information needed " + ;
         "by the window, such as the current workarea, when focus is " + ;
         "taken from the window and for restoring the information when " + ;
         "focus is given to the window.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      WINDOW HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'))

   CASE nFrame == 5
      // Display the message for this frame.
      MsgBox("Each window can have a window event handler, also " + ;
         "specified when the window is created.  'Events' are messages " + ;
         "dealing with keyboard and mouse activity by the user.  Using " + ;
         "an event handler a program could, for example, determine if a " + ;
         "mouse button press was outside of the current window and " + ;
         "issue a beep.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      EVENT HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'))

   CASE nFrame == 6
      // Display the message for this frame.
      MsgBox("There are three levels of message filters in " + ;
         "ProVision:Windows:  system filters, window filters, and " + ;
         "control filters.  Filters can be placed on all messages, " + ;
         "or they can be restricted to certain types of messages.")

   CASE nFrame == 7
      // Display the message for this frame.
      MsgBox("The message ID and parameters are passed to filters by " + ;
         "reference, thus filters can destroy (intercept) any message by " + ;
         "setting the message ID to PWMSG_NONE.  Also, filters can " + ;
         "transform one event message, such as a right mouse button " + ;
         "press, into another event message, such as an Esc keypress.")

   CASE nFrame == 8
      // Display the message for this frame.
      MsgBox("System filters are applied with the pw():addFilter() " + ;
         "system message.  Any number of system filters may be used, " + ;
         "but since all event and system messages are routed through " + ;
         "the system filters, the number should probably be kept to " + ;
         "a minimum.  System filters may be removed with the " + ;
         "pw():delFilter() system message.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   nSysFilter := pw():addFilter({ | idMsg, xParam1, xParam2, xParam3, ;'))

   CASE nFrame == 9
      // Display the message for this frame.
      MsgBox("Window filters are applied with the addFilter() window " + ;
         "message.  Any number of window filters may be added to each " + ;
         "window, but since all event and window messages for a " + ;
         "window are routed through its window filters, the number " + ;
         "should probably be kept to a minimum.  Window filters may be " + ;
         "removed with the delFilter() window message.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   nWndFilter := oCustWnd:addFilter({ | idMsg, xParam1, xParam2, xParam3, ;'))

   CASE nFrame == 10
      // Display the message for this frame.
      MsgBox("Control filters are added when input controls are " + ;
         "created.  Each input control has a FILTER clause with which " + ;
         "the filter code block is specified.  All messages for the " + ;
         "input control are routed through its filter.  Only one " + ;
         "filter may be specified for each input control.  Control " + ;
         "filters cannot be removed.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   @ 01, 02 GET AS TEXTFIELD ;'))

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END EventsFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC EventsList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Events and messages."
**
*****************************************************************************/
STATIC FUNCTION EventsList()

   STATIC   aListing[146]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** EVENTS.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of events and messages'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := '#include "pw.ch"'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := 'STATIC oCustWnd'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** CustWnd() --> oCustWnd'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function creates and opens the customer window.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'FUNCTION CustWnd()'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL GetList := {}'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL nSysFilter, ;'
      aListing[i++]  := '         nWndFilter'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Create a window.'
      aListing[i++]  := '   CREATE WINDOW oCustWnd ;'
      aListing[i++]  := '      CENTERED ;'
      aListing[i++]  := '      SIZE 16, 64 ;'
      aListing[i++]  := '      STYLE PWSTYLE_PRIMARY ;'
      aListing[i++]  := '      TITLE "Customers" ;'
      aListing[i++]  := '      WINDOW HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'
      aListing[i++]  := '         CustWndHandler(idMsg, xParam1, xParam2, xParam3, xParam4, ;'
      aListing[i++]  := '         nSysFilter, nWndFilter) } ;'
      aListing[i++]  := '      EVENT HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'
      aListing[i++]  := '         CustEventHandler(idMsg, xParam1, xParam2, xParam3, xParam4) }'
      aListing[i++]  := ''
      aListing[i++]  := '   // Add a system filter.'
      aListing[i++]  := '   nSysFilter := pw():addFilter({ | idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '      xParam4 | SysFilter(@idMsg, @xParam1, @xParam2, @xParam3, @xParam4) }, ;'
      aListing[i++]  := '      PWMSG_KEYPRESS)'
      aListing[i++]  := ''
      aListing[i++]  := '   // Add a window filter.'
      aListing[i++]  := '   nWndFilter := oCustWnd:addFilter({ | idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '      xParam4 | CustWndFilter(@idMsg, @xParam1, @xParam2, @xParam3, ;'
      aListing[i++]  := '      @xParam4) }, PWMSG_MOUSEPRESS)'
      aListing[i++]  := ''
      aListing[i++]  := '   // Create a textfield with a control filter.'
      aListing[i++]  := '   @ 01, 02 GET AS TEXTFIELD ;'
      aListing[i++]  := '      PROMPT "Customer name: " ;'
      aListing[i++]  := '      INITIAL SPACE(30) ;'
      aListing[i++]  := '      FILTER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'
      aListing[i++]  := '         CtrlFilter(@idMsg, @xParam1, @xParam2, @xParam3, @xParam4) }'
      aListing[i++]  := ''
      aListing[i++]  := '   // Attach the controls to the window.'
      aListing[i++]  := '   ATTACH CONTROLS TO oCustWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Open the window modally.'
      aListing[i++]  := '   OPEN WINDOW oCustWnd MODAL'
      aListing[i++]  := ''
      aListing[i++]  := '   // If the window was successfully opened, begin a local event loop.'
      aListing[i++]  := '   IF pw():curFocus() == oCustWnd'
      aListing[i++]  := '      pw():beginModal()'
      aListing[i++]  := '   END IF // pw():curFocus() == oCustWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Destroy the window.'
      aListing[i++]  := '   DESTROY WINDOW oCustWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(NIL)'
      aListing[i++]  := '   // END CustWnd()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** STATIC CustWndHandler( idMsg, xParam1, xParam2, xParam3, xParam4, ;'
      aListing[i++]  := '**                        nSysFilter, nWndFilter ) --> lHandled'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function is a custom window message handler for oCustWnd.  It'
      aListing[i++]  := '** exits the local event loop when the window is closed.  It also deletes'
      aListing[i++]  := '** the system and window filters that were added when the window was'
      aListing[i++]  := '** created.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'STATIC FUNCTION CustWndHandler( idMsg, xParam1, xParam2, xParam3, xParam4, ;'
      aListing[i++]  := '                                nSysFilter, nWndFilter )'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL lHandled := .T.'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   IF idMsg == PWMSG_CLOSE'
      aListing[i++]  := ''
      aListing[i++]  := '      // Exit the local event loop.'
      aListing[i++]  := '      pw():endModal()'
      aListing[i++]  := ''
      aListing[i++]  := '      // Delete the system and window filters.'
      aListing[i++]  := '      pw():delFilter(nSysFilter)'
      aListing[i++]  := '      oCustWnd:delFilter(nWndFilter)'
      aListing[i++]  := ''
      aListing[i++]  := '   END IF // idMsg == PWMSG_CLOSE'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(lHandled)'
      aListing[i++]  := '   // END CustWndHandler( idMsg, xParam1, xParam2, xParam3, xParam4, ;'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** STATIC CustEventHandler( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '**                          xParam4 ) --> lHandled'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function is a custom window event handler for oCustWnd.  It beeps'
      aListing[i++]  := '** if a mouse button is pressed outside of the window.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'STATIC FUNCTION CustEventHandler( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '                                  xParam4 )'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL lHandled := .T.'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL nCol, ;'
      aListing[i++]  := '         nRow'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   IF idMsg == PWMSG_MOUSEPRESS'
      aListing[i++]  := ''
      aListing[i++]  := '      // Convert screen coordinates to window coordinates.'
      aListing[i++]  := '      oCustWnd:screenToWnd(xParam2, xParam3, @nRow, @nCol)'
      aListing[i++]  := ''
      aListing[i++]  := '      // If the press was not on the window then beep.'
      aListing[i++]  := '      IF .NOT. oCustWnd:isPosVisible(nRow, nCol)'
      aListing[i++]  := '         TONE(2048, 1)'
      aListing[i++]  := '      END IF // .NOT. oCustWnd:isPosVisible(nRow, nCol)'
      aListing[i++]  := ''
      aListing[i++]  := '   END IF // idMsg == PWMSG_MOUSEPRESS'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(lHandled)'
      aListing[i++]  := '   // END CustEventHandler( idMsg, xParam1, xParam2, xParam3, ;'
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END EventsList()

