/*****************************************************************************
** INIT.PRG
**
** ProVision:Windows v1.20 demo of initializing ProVision:Windows
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)


STATIC   oInitWnd                      // the sample window



/*****************************************************************************
** InitFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the initializing windows topic.
**
*****************************************************************************/
FUNCTION InitFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := InitList()

   LOCAL lContinue   := .T.


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame < 1
      // If the sample window is still open, close it.
      IF (oInitWnd != NIL) .AND. ;
            pvGetBit(oInitWnd:getState(), PWSTATE_OPEN)
         oInitWnd:close()
      END IF // (oInitWnd != NIL) .AND. ...

   CASE nFrame == 1
      // Display the message for this frame.
      MsgBox("This topic covers the commands used to initialize and " + ;
         "configure ProVision:Windows.  The INIT WINDOWS... and " + ;
         "ACTIVATE WINDOWS... commands are the only ones that are " + ;
         "required." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("Before using any other ProVision:Windows command or " + ;
         "function (except pwSupplyChars(), discussed later), you should " + ;
         "use the INIT WINDOWS... command.  This allocates memory needed " + ;
         "by ProVision:Windows, redefines some characters, if necessary, " + ;
         "and generally gets things set up for other functions." + CRLF + ;
         CRLF + ;
         "Note some of the optional clauses used with INIT WINDOWS...")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   INIT WINDOWS ;'))

   CASE nFrame == 3
      // Display the message for this frame.
      MsgBox("The BORDERS, CONTROLS, and MOUSE clauses specify whether " + ;
         "you want to use Text Mode Redefinition (TMR) for that item.  " + ;
         "To use TMR for the borders, for example, you would specify " + ;
         "'GRAPHIC BORDERS' as one clause.  To force the use of standard " + ;
         "mode, you would specify 'STANDARD BORDERS' instead." + CRLF + ;
         CRLF + ;
         "If you specify neither TMR nor standard mode, " + ;
         "ProVision:Windows will be initialized to TMR mode if your " + ;
         "video hardware supports it.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      GRAPHIC  BORDERS ;'))

   CASE nFrame == 4
      // Display the message for this frame.
      MsgBox("INIT WINDOWS... has a 'companion' command, DEINIT WINDOWS, " + ;
         "which frees the memory used by ProVision:Windows and restores " + ;
         "the character set if TMR mode is used." + CRLF + ;
         CRLF + ;
         "If you see strange characters when running other programs " + ;
         "after your ProVision:Windows application, you have probably " + ;
         "forgotten to use DEINIT WINDOWS.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   DEINIT WINDOWS'))

   CASE nFrame == 5
      // Display the message for this frame.
      MsgBox("The ACTIVATE WINDOWS... command turns control over to the " + ;
         "ProVision:Windows event system.  Most of the time, the " + ;
         "application will be idling inside this command.  After it is " + ;
         "issued, program flow is determined entirely by the events that " + ;
         "occur in open windows." + CRLF + ;
         CRLF + ;
         "You can specify the window you want to initially have focus " + ;
         "with the INITIAL clause.  If not specified, the first window " + ;
         "opened will have focus.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   ACTIVATE WINDOWS'))

   CASE nFrame == 6
      // Display the message for this frame.
      MsgBox("There are several global settings that affect the " + ;
         "behavior of ProVision:Windows.  These allow you to change " + ;
         "such things as the keys used to switch between windows and " + ;
         "the 'wallpaper' displayed in the background, behind all " + ;
         "windows.")

   CASE nFrame == 7
      // Display the message for this frame.
      MsgBox("The SET KEY FOR...TO... commands allow you to change " + ;
         "the keys used to perform 'system-related' functions in " + ;
         "ProVision:Windows.  For example, these commands can be " + ;
         "used to provide great user-flexibility and maximum Clipper " + ;
         "compatibility.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   SET KEYS FOR NEXTFIELD     TO K_TAB, K_DOWN, K_ENTER'))

   CASE nFrame == 8
      // Display the message for this frame.
      MsgBox("ProVision:Windows allows any window to optionally have a " + ;
         "shadow.  The type of shadow windows will have is a global " + ;
         "setting made with the SET SHADOW TO... command.  Shadows can " + ;
         "be directed to any of the four diagonal compass points and " + ;
         "can be any size up to three rows and three columns." + CRLF + ;
         CRLF + ;
         "Three types of shadows are supported:  CLEAR, SOLID, and " + ;
         "CHECKERBOARD.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   SET SHADOW TO CHECKERBOARD ;'))

   CASE nFrame == 9
      // Open the sample window, but reselect the topics window.
      IF pw():isTMR(PWTMR_BORDERS)
         DISPBEGIN()
         InitWindow()
         pw():select(oTopicWnd)
         DISPEND()
      END IF // pw():isTMR(PWTMR_BORDERS)

      // Display the message for this frame.
      MsgBox("'Wallpaper' refers to what is displayed in the " + ;
         "background, behind all windows.  The SET WALLPAPER TO... " + ;
         "command allows you to draw anything you wish in the " + ;
         "background.  PW.CH supplies several standard constants " + ;
         "to use for wallpaper." + IIF(pw():isTMR(PWTMR_BORDERS), ;
         CRLF + CRLF + ;
         "Try some of the different types of wallpaper listed " + ;
         "in the sample window.", ""))

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   SET WALLPAPER TO PWWP_RINGS ;'))

   CASE nFrame == 10
      // Display the message for this frame.
      MsgBox("pwSupplyChars() is used to change the character codes " + ;
         "that ProVision:Windows redefines in TMR mode.  If the system " + ;
         "is using characters that you need for your application, use " + ;
         "this function to specify which characters may be redefined by " + ;
         "ProVision:Windows." + CRLF + ;
         CRLF + ;
         "pwSupplyChars() is the only function that should ever be " + ;
         "called before ProVision:Windows is initialized.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   pwSupplyChars({ 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, ;'))

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END InitFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC InitList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Initializing windows."
**
*****************************************************************************/
STATIC FUNCTION InitList()

   STATIC   aListing[80]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** INIT.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of initializing ProVision:Windows'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := '#include "inkey.ch"'
      aListing[i++]  := '#include "pw.ch"'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := 'STATIC oInitWnd'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** Main() --> NIL'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function demonstrates initializing ProVision:Windows.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'FUNCTION Main()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Provide new lists of character codes for ProVision:Windows to'
      aListing[i++]  := '   // redefine.  (This should almost never be necessary.)'
      aListing[i++]  := '   pwSupplyChars({ 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, ;'
      aListing[i++]  := '                   139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, ;'
      aListing[i++]  := '                   150, 151, 152, 153, 154, 155, 156, 157, 158, 159 }, ;'
      aListing[i++]  := '                 { 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, ;'
      aListing[i++]  := '                   203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, ;'
      aListing[i++]  := '                   214, 215, 216, 217, 218, 219, 220, 221, 222, 223 })'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Initialize ProVision:Windows.'
      aListing[i++]  := '   INIT WINDOWS ;'
      aListing[i++]  := '      GRAPHIC  BORDERS ;'
      aListing[i++]  := '      GRAPHIC  CONTROLS ;'
      aListing[i++]  := '      STANDARD MOUSE'
      aListing[i++]  := ''
      aListing[i++]  := '   // Load new wallpaper'
      aListing[i++]  := '   SET WALLPAPER TO PWWP_RINGS ;'
      aListing[i++]  := '      COLOR +W/N*    // Watch this, and do not use +W/*N.'
      aListing[i++]  := '                     // This marks a comment. -------^^'
      aListing[i++]  := ''
      aListing[i++]  := '   // Set up Clipper-like keys.'
      aListing[i++]  := '   SET KEYS FOR NEXTFIELD     TO K_TAB, K_DOWN, K_ENTER'
      aListing[i++]  := '   SET KEYS FOR PREVIOUSFIELD TO K_SH_TAB, K_UP'
      aListing[i++]  := '   SET KEY  FOR DEFAULTACTION TO K_CTRL_RET'
      aListing[i++]  := ''
      aListing[i++]  := '   // Select a new shadow type.'
      aListing[i++]  := '   SET SHADOW TO CHECKERBOARD ;'
      aListing[i++]  := '      DIRECTION SW ;'
      aListing[i++]  := '      SIZE 01, 01'
      aListing[i++]  := ''
      aListing[i++]  := '   // Create the window.'
      aListing[i++]  := '   CREATE WINDOW oInitWnd ;'
      aListing[i++]  := '      AT 01, 02 ;'
      aListing[i++]  := '      SIZE 10, 39 ;'
      aListing[i++]  := '      SHADOW'
      aListing[i++]  := ''
      aListing[i++]  := '   // Open the window.'
      aListing[i++]  := '   OPEN WINDOW oInitWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Activate ProVision:Windows.'
      aListing[i++]  := '   ACTIVATE WINDOWS'
      aListing[i++]  := ''
      aListing[i++]  := '   // Deinitialize ProVision:Windows.'
      aListing[i++]  := '   DEINIT WINDOWS'
      aListing[i++]  := ''
      aListing[i++]  := '   // Return NIL.'
      aListing[i++]  := '   RETURN(NIL)'
      aListing[i++]  := '   // END Main()'
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END InitList()



/*****************************************************************************
** STATIC InitWindow() --> oInitWnd
**
** This function creates and opens the sample window for this topic.
**
*****************************************************************************/
STATIC FUNCTION InitWindow()

   STATIC   aColors     := {  NIL, ;
                              "N/G", ;
                              "+W/*N", ;
                              "W/*N", ;
                              "BG/B", ;
                              "+W/R", ;
                              "N/BG" }, ;
            aWallpaper  := {  PWWP_BRICKS, ;
                              PWWP_DIAMOND, ;
                              PWWP_GRID, ;
                              PWWP_RINGS, ;
                              PWWP_SQUARE, ;
                              PWWP_STRIPES, ;
                              PWWP_WEAVE }

   LOCAL GetList  := {}

   LOCAL oWallpaper


   // If the window has not been created, do so.
   IF oInitWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create the window.
      CREATE WINDOW oInitWnd ;
         AT 01, pwMaxCol() / 2 ;
         SIZE 10, 39 ;
         STYLE PWSTYLE_DIALOG ;
         TITLE "Wallpaper samples"

      // Create radiobuttons for different types of wallpaper.
      @ 01, 05 GET AS RADIOBUTTONS oWallpaper ;
         PROMPT { "~Bricks", ;
                  "D~iamond", ;
                  "~Grid", ;
                  "~Rings", ;
                  "~Square", ;
                  "S~tripes", ;
                  "~Weave" }

      // Create a View pushbutton to view the current selection.
      @ 03, 23 GET AS PUSHBUTTON ;
         PROMPT " ~View " ;
         ACTION { || pw():wallpaper(aWallpaper[oWallpaper:getValue()], ;
            aColors[oWallpaper:getValue()]) }

      // Attach the pushbutton to the window.
      ATTACH CONTROLS TO oInitWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oInitWnd == NIL

   // Open the window.
   OPEN WINDOW oInitWnd

   // Return a reference to the window.
   RETURN(oInitWnd)
   // END InitWindow()

