/*****************************************************************************
** MANIP.PRG
**
** ProVision:Windows v1.20 demo of manipulating windows
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)


STATIC   oManipWnd                     // the sample window



/*****************************************************************************
** ManipFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the Manipulating windows topic.
**
*****************************************************************************/
FUNCTION ManipFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := ManipList()

   LOCAL lContinue   := .T.

   LOCAL i, ;
         j, ;
         nCol, ;
         nRow


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame < 1
      // If the sample window is still open, close it.
      IF (oManipWnd != NIL) .AND. ;
            pvGetBit(oManipWnd:getState(), PWSTATE_OPEN)
         DISPBEGIN()
         oManipWnd:restore()
         oManipWnd:close()
         DISPEND()
      END IF // (oManipWnd != NIL) .AND. ...

   CASE nFrame == 1
      // Open the sample window, but reselect the topics window.
      DISPBEGIN()
      ManipWindow()
      pw():select(oTopicWnd)
      DISPEND()

      // Display the message for this frame.
      MsgBox("This topic covers the commands used to move, size, " + ;
         "scroll, minimize, and maximize windows." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("Windows can be manipulated programatically via messages " + ;
         "sent to window objects.  These messages are of the form:" + CRLF + ;
         CRLF + ;
         "<oWindow>:<message>( [ <xParameter> [, ...] ] )")

   CASE nFrame == 3
      // Move the window.
      FOR i := 1 TO 1
         FOR j := 1 TO 5
            oManipWnd:getPos(@nRow, @nCol)
            oManipWnd:move(nRow, nCol - 2)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 5
            oManipWnd:getPos(@nRow, @nCol)
            oManipWnd:move(nRow + 1, nCol)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 5
            oManipWnd:getPos(@nRow, @nCol)
            oManipWnd:move(nRow, nCol + 2)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 5
            oManipWnd:getPos(@nRow, @nCol)
            oManipWnd:move(nRow - 1, nCol)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
      NEXT i 

      // Display the message for this frame.
      MsgBox("The move() message is used to move a window to a new " + ;
         "location.  As long as a window's style includes the 'movable' " + ;
         "attribute, the user can also move the window at will using " + ;
         "either the keyboard or a mouse." + CRLF + ;
         CRLF + ;
         "If the window has a parent, the location is relative to the " + ;
         "parent window's viewport.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '         oManipWnd:move(nRow, nCol - 2)'))

   CASE nFrame == 4
      // Size the window.
      FOR i := 1 TO 2
         FOR j := 1 TO 5
            oManipWnd:getSize(@nRow, @nCol)
            oManipWnd:size(nRow - 1, nCol - 2)
         NEXT j 
         FOR j := 1 TO 5
            oManipWnd:getSize(@nRow, @nCol)
            oManipWnd:size(nRow + 1, nCol + 2)
         NEXT j 
      NEXT i 

      // Display the message for this frame.
      MsgBox("The size() message is used to change the size of a " + ;
         "window.  If the window's style includes the 'sizing' " + ;
         "attribute, the user can also size the window at will using " + ;
         "either the keyboard or a mouse." + CRLF + ;
         CRLF + ;
         "The size of the window includes the borders, if any.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '         oManipWnd:size(nRow - 1, nCol - 2)'))

   CASE nFrame == 5
      // Size the window smaller than its maximum size, scroll it, then
      // size it back to its original size.
      oManipWnd:getSize(@nRow, @nCol)
      oManipWnd:size(06, 19)
      FOR i := 1 TO 1
         FOR j := 1 TO 10
            oManipWnd:scroll(PWSCROLL_HORIZONTAL, PWMSG_SCROLLRIGHT)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 4
            oManipWnd:scroll(PWSCROLL_VERTICAL, PWMSG_SCROLLDOWN)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 10
            oManipWnd:scroll(PWSCROLL_HORIZONTAL, PWMSG_SCROLLLEFT)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
         FOR j := 1 TO 4
            oManipWnd:scroll(PWSCROLL_VERTICAL, PWMSG_SCROLLUP)
            TONE(0, 1) // Wait one timertick.
         NEXT j 
      NEXT i 
      oManipWnd:size(nRow, nCol)

      // Display the message for this frame.
      MsgBox("The scroll() message is used to scroll the contents of " + ;
         "the window when the window is smaller than its maximum size.  " + ;
         "If the window includes scrollbars, the user can also scroll " + ;
         "the window at will using either the keyboard or a mouse." + CRLF + ;
         CRLF + ;
         "Scrolling windows with virtual sizes larger than the screen " + ;
         "size are an ideal solution to input forms that normally would " + ;
         "not fit on a single page.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '         oManipWnd:scroll(PWSCROLL_HORIZONTAL, PWMSG_SCROLLRIGHT)'))

   CASE nFrame == 6
      // Minimize the window and move it to where it can be seen, but
      // reselect the topics window.
      DISPBEGIN()
      oManipWnd:minimize()
      oManipWnd:move(09, pwMaxCol() - 8)
      pw():select(oTopicWnd)
      DISPEND()

      // Display the message for this frame.
      MsgBox("The minimize() message is used to reduce the window to an " + ;
         "icon.  If the window's style includes the 'minimize' " + ;
         "attribute, the user can also minimize the window at will using " + ;
         "either the keyboard or a mouse." + CRLF + ;
         CRLF + ;
         "When many windows are open, it is convient to minimize " + ;
         "some of them to prevent the display from becoming too " + ;
         "cluttered.  The window can be returned to its original size " + ;
         "and position with the restore() message.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   oManipWnd:minimize()'))

   CASE nFrame == 7
      // Restore then maximize the window.
      DISPBEGIN()
      oManipWnd:restore()
      oManipWnd:maximize()
      DISPEND()

      // Display the message for this frame.
      MsgBox("The maximize() message moves the window to 00, 00 and " + ;
         "sizes it to the smaller of its maximum size or the size of " + ;
         "the screen.  If the window's style includes the 'maximize' " + ;
         "attribute, the user can also mazimize the window at will " + ;
         "using either the keyboard or a mouse." + CRLF + ;
         CRLF + ;
         "Maximizing a window allows the user to focus on the " + ;
         "information in that window.  The window can be returned to " + ;
         "its original size and position with the restore() message.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   oManipWnd:maximize()'))

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END ManipFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC ManipList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Manipulating windows."
**
*****************************************************************************/
STATIC FUNCTION ManipList()

   STATIC   aListing[94]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** MANIP.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of manipulating windows'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Move the window.'
      aListing[i++]  := '   FOR i := 1 TO 1'
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getPos(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:move(nRow, nCol - 2)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getPos(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:move(nRow + 1, nCol)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getPos(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:move(nRow, nCol + 2)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getPos(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:move(nRow - 1, nCol)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '   NEXT i '
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Size the window.'
      aListing[i++]  := '   FOR i := 1 TO 2'
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getSize(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:size(nRow - 1, nCol - 2)'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 5'
      aListing[i++]  := '         oManipWnd:getSize(@nRow, @nCol)'
      aListing[i++]  := '         oManipWnd:size(nRow + 1, nCol + 2)'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '   NEXT i '
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Size the window smaller than its maximum size, scroll it, then'
      aListing[i++]  := '   // size it back to its original size.'
      aListing[i++]  := '   oManipWnd:getSize(@nRow, @nCol)'
      aListing[i++]  := '   oManipWnd:size(06, 19)'
      aListing[i++]  := '   FOR i := 1 TO 1'
      aListing[i++]  := '      FOR j := 1 TO 10'
      aListing[i++]  := '         oManipWnd:scroll(PWSCROLL_HORIZONTAL, PWMSG_SCROLLRIGHT)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 4'
      aListing[i++]  := '         oManipWnd:scroll(PWSCROLL_VERTICAL, PWMSG_SCROLLDOWN)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 10'
      aListing[i++]  := '         oManipWnd:scroll(PWSCROLL_HORIZONTAL, PWMSG_SCROLLLEFT)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '      FOR j := 1 TO 4'
      aListing[i++]  := '         oManipWnd:scroll(PWSCROLL_VERTICAL, PWMSG_SCROLLUP)'
      aListing[i++]  := '         TONE(0, 1) // Wait one timertick.'
      aListing[i++]  := '      NEXT j '
      aListing[i++]  := '   NEXT i '
      aListing[i++]  := '   oManipWnd:size(nRow, nCol)'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Minimize the window, then move it to where it can be seen.'
      aListing[i++]  := '   oManipWnd:minimize()'
      aListing[i++]  := '   oManipWnd:move(09, pwMaxCol() - 8)'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Restore then maximize the window.'
      aListing[i++]  := '   oManipWnd:restore()'
      aListing[i++]  := '   oManipWnd:maximize()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END ManipList()



/*****************************************************************************
** STATIC ManipWindow() --> oManipWnd
**
** This function creates and opens the sample window for this topic.
**
*****************************************************************************/
STATIC FUNCTION ManipWindow()

   LOCAL i, ;
         j


   // If the window has not been created, do so.
   IF oManipWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create the window.
      CREATE WINDOW oManipWnd ;
         AT 01, pwMaxCol() / 2 ;
         SIZE 10, 39 ;
         STYLE PWSTYLE_PRIMARY - PWSTYLEINFO_MENU ;
         TITLE "Numbers"

      // Write some stuff in the window.
      FOR i := 0 TO 2
         FOR j := 0 TO 7
           @ j, (i * 10) + 4 SAY STR((i + 1) / (j + 1), 8, 6)
         NEXT j 
      NEXT i 

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oManipWnd == NIL

   // Open the window.
   OPEN WINDOW oManipWnd

   // Return a reference to the window.
   RETURN(oManipWnd)
   // END ManipWindow()

