/*****************************************************************************
** MDI.PRG
**
** ProVision:Windows v1.20 sample MDI windows
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


STATIC   aSecondaries   := {}          // an array of the MDI secondary windows

STATIC   oDoc1Wnd, ;                   // the window for Document 1
         oDoc2Wnd, ;                   // the window for Document 2
         oDoc3Wnd, ;                   // the window for Document 3
         oItemClose, ;                 // the Window/Close menuitem
         oItemSave, ;                  // the Window/Save menuitem
         oItemSaveAs, ;                // the Window/Save as menuitem
         oItemPrint, ;                 // the Window/Print menuitem
         oMDIWnd, ;                    // the MDI primary window
         oPopWindow                    // the Window popup



/*****************************************************************************
** MDIWindow( oItemMDI ) --> oMDIWnd
*****************************************************************************/
FUNCTION MDIWindow( oItemMDI )

   LOCAL oMenu


   IF oMDIWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // open an MDI primary window
      CREATE WINDOW oMDIWnd ;
         AT 05, 11 ;
         SIZE 18, 63 ;
         VIRTUAL SIZE pwMaxRow() + 1, pwMaxCol() + 1 ;
         STYLE PWSTYLE_MDIPRIMARY ;
         TITLE "MDI primary window - Famous words" ;
         ICON TITLE "Famous words" ;
         SHADOW ;
         WINDOW HANDLER { | idMsg | MDIWndHandler(idMsg, oItemMDI) }

      // create a menu for the window
      MENU oMenu

         POPUP PROMPT "~File"
            MENUITEM PROMPT "~New..." ;
               ACTION { || MsgBox("Not implemented by this application.") }
            MENUITEM PROMPT "~Open..." ;
               ACTION { || MsgBox("Not implemented by this application.") }
            MENUITEM oItemClose PROMPT "~Close  Ctrl+F4" ;
               ACTION { || IIF(oMDIWnd:curFocus() != NIL, ;
                  oMDIWnd:curFocus():close(), ) }
            MENUITEM oItemSave PROMPT "~Save" ;
               ACTION { || MsgBox("Not implemented by this application.") }
            MENUITEM oItemSaveAs PROMPT "Save ~as..." ;
               ACTION { || MsgBox("Not implemented by this application.") }
            SEPARATOR
            MENUITEM oItemPrint PROMPT "~Print..." ;
               ACTION { || MsgBox("Not implemented by this application.") }
            SEPARATOR
            MENUITEM PROMPT "E~xit\tAlt+F4" ;
               ACTION { || oMDIWnd:close() }
         END POPUP // File

         POPUP oPopWindow PROMPT "~Window"
            MENUITEM PROMPT "~Tile" ;
               ACTION { || Tile() }
            MENUITEM PROMPT "~Cascade" ;
               ACTION { || Cascade() }
            MENUITEM PROMPT "~Arrange icons" ;
               ACTION { || ArrangeIcons() }
         END POPUP // Window

      END MENU // oMenu

      // attach the menu to the window
      ATTACH MENU oMenu TO oMDIWnd

      // Open the first document.
      CREATE WINDOW oDoc1Wnd ;
         AT 02, 04 ;
         SIZE 10, 40 ;
         VIRTUAL SIZE pwMaxRow() + 1, pwMaxCol() + 1 ;
         STYLE PWSTYLE_MDISECONDARY ;
         PARENT oMDIWnd ;
         TITLE "Document 1-[A test]" ;
         ICON TITLE "Doc 1-[A test]" ;
         WINDOW HANDLER { | idMsg | SecWndHandler(oDoc1Wnd, idMsg, ;
            02, 04) }

      ? "This is a test of the emergency"
      ? "broadcast system.  The broadcasters"
      ? "of your area, in voluntary"
      ? "cooperation with federal, state,"
      ? "and local authorities, have"
      ? "developed this system to keep you"
      ? "informed in the event of an"
      ? "emergency."

      // Open the second document.
      CREATE WINDOW oDoc2Wnd ;
         AT 04, 08 ;
         SIZE 10, 40 ;
         VIRTUAL SIZE pwMaxRow() + 1, pwMaxCol() + 1 ;
         STYLE PWSTYLE_MDISECONDARY ;
         PARENT oMDIWnd ;
         TITLE "Document 2-[Lincoln]" ;
         ICON TITLE "Doc 2-[Lincoln]" ;
         WINDOW HANDLER { | idMsg | SecWndHandler(oDoc2Wnd, idMsg, ;
            04, 08) }

      ? "Four score and seven years ago,"
      ? "our forefathers brought forth on"
      ? "this continent a new nation,"
      ? "conceived in liberty, and dedicated"
      ? "to the proposition that all men"
      ? "are created equal."
      ? "Now we are engaged in a great war,"
      ? "testing whether that nation, or any"

      // Open the third document.
      CREATE WINDOW oDoc3Wnd ;
         AT 06, 12 ;
         SIZE 10, 40 ;
         VIRTUAL SIZE pwMaxRow() + 1, pwMaxCol() + 1 ;
         STYLE PWSTYLE_MDISECONDARY ;
         PARENT oMDIWnd ;
         TITLE "Document 3-[Untitled]" ;
         ICON TITLE "Doc 3-[Untitled]" ;
         WINDOW HANDLER { | idMsg | SecWndHandler(oDoc3Wnd, idMsg, ;
            06, 12) }

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oMDIWnd == NIL

   // Open the windows.
   OPEN WINDOW oMDIWnd

   OpenSecondary(oDoc1Wnd)
   OpenSecondary(oDoc2Wnd)
   OpenSecondary(oDoc3Wnd)

   // Reenable some of the File options and the Window popup, in case
   // they were disabled earlier.
   oItemClose:enable()
   oItemSave:enable()
   oItemSaveAs:enable()
   oItemPrint:enable()
   oPopWindow:enable()

   // Return a reference to the MDI window.
   RETURN(oMDIWnd)
   // END MDIWindow( oItemMDI )



/*****************************************************************************
** STATIC MDIWndHandler( idMsg, oItemMDI ) --> lHandled
*****************************************************************************/
STATIC FUNCTION MDIWndHandler( idMsg, oItemMDI )

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      oItemMDI:enable()

   CASE idMsg == PWMSG_OPEN
      oItemMDI:disable()

   END CASE

   RETURN(lHandled)
   // END MDIWndHandler( idMsg, oItemMDI )



/*****************************************************************************
** STATIC OpenSecondary( oWnd ) --> NIL
*****************************************************************************/
STATIC FUNCTION OpenSecondary( oWnd )


   OPEN WINDOW oWnd
   AADD(aSecondaries, oWnd)

   RETURN(NIL)
   // END OpenSecondary( oWnd )



/*****************************************************************************
** STATIC ResetSecondary( oWnd, nRow, nCol ) --> NIL
*****************************************************************************/
STATIC FUNCTION ResetSecondary( oWnd, nRow, nCol )


   DISPBEGIN()

   IF pvGetBit(oWnd:getState(), PWSTATE_MINIMIZED)
      oWnd:restore()
   END IF // pvGetBit(oWnd:getState(), PWSTATE_MINIMIZED)
   IF pvGetBit(oWnd:getState(), PWSTATE_MAXIMIZED)
      oWnd:restore()
   END IF // pvGetBit(oWnd:getState(), PWSTATE_MAXIMIZED)

   oWnd:move(nRow, nCol)
   oWnd:size(10, 40)

   DISPEND()

   RETURN(NIL)
   // END ResetSecondary( oWnd, nRow, nCol )



/*****************************************************************************
** STATIC SecWndHandler( oWnd, idMsg, nRow, nCol ) --> lHandled
*****************************************************************************/
STATIC FUNCTION SecWndHandler( oWnd, idMsg, nRow, nCol )

   LOCAL lHandled := .T.

   LOCAL nWndAt


   IF idMsg == PWMSG_CLOSE

      ResetSecondary(oWnd, nRow, nCol)

      nWndAt   := ASCAN(aSecondaries, { | oThisWnd | oThisWnd == oWnd })
      ADEL(aSecondaries, nWndAt)
      ASIZE(aSecondaries, LEN(aSecondaries) - 1)

      // If all MDI secondaries have been closed, disable some of the
      // File options and the Window popup.
      IF LEN(aSecondaries) == 0
         oItemClose:disable()
         oItemSave:disable()
         oItemSaveAs:disable()
         oItemPrint:disable()
         oPopWindow:disable()
      END IF // LEN(aSecondaries) == 0

   END IF // idMsg == PWMSG_CLOSE

   RETURN(lHandled)
   // END SecWndHandler( oWnd, idMsg, nRow, nCol )



/*****************************************************************************
** STATIC Tile() --> NIL
*****************************************************************************/
STATIC FUNCTION Tile()

   LOCAL i, ;
         nHeight, ;
         nOpen := 0, ;
         nRow, ;
         nWidth


   FOR i := 1 TO LEN(aSecondaries)
      IF .NOT. pvGetBit(aSecondaries[i]:getState(), PWSTATE_MINIMIZED)
         ++nOpen
      END IF // .NOT. pvGetBit(aSecondaries[i]:getState(), PWST...
   NEXT i

   IF nOpen != 0

      oMDIWnd:getViewSize(@nHeight, @nWidth)

      // Windows can only be tiled if there is enough room.
      IF nHeight >= (nOpen * 5)

         nHeight  := INT(nHeight / nOpen)
         nRow     := 00

         FOR i := 1 TO LEN(aSecondaries)
            IF .NOT. pvGetBit(aSecondaries[i]:getState(), PWSTATE_MINIMIZED)
               DISPBEGIN()
               IF pvGetBit(aSecondaries[i]:getState(), PWSTATE_MAXIMIZED)
                  aSecondaries[i]:restore()
               END IF // pvGetBit(aSecondaries[i]:getState(), PWST...
               aSecondaries[i]:move(nRow, 00)
               aSecondaries[i]:size(nHeight, nWidth)
               DISPEND()
               nRow  += nHeight
            END IF // .NOT. pvGetBit(aSecondaries[i]:getState(), P...
         NEXT i 

         pw():select(aSecondaries[1])

      END IF // nHeight >= (nOpen * 5)

   END IF // nOpen != 0

   RETURN(NIL)
   // END Tile()



/*****************************************************************************
** STATIC Cascade() --> NIL
*****************************************************************************/
STATIC FUNCTION Cascade()

   LOCAL i, ;
         nCol  := 00, ;
         nHeight, ;
         nIndHeight, ;
         nRow  := 00, ;
         nWidth


   oMDIWnd:getViewSize(@nHeight, @nWidth)

   // Windows can only be cascaded if there's enough room.
   IF (nHeight >= 10) .AND. (nWidth >= 14)

      nWidth   := INT(nWidth / 2)
      nHeight  := INT(nHeight / 2)

      FOR i := 1 TO LEN(aSecondaries)
         IF .NOT. pvGetBit(aSecondaries[i]:getState(), PWSTATE_MINIMIZED)
            DISPBEGIN()
            IF pvGetBit(aSecondaries[i]:getState(), PWSTATE_MAXIMIZED)
               aSecondaries[i]:restore()
            END IF // pvGetBit(aSecondaries[i]:getState(), PWSTATE...
            aSecondaries[i]:move(nRow, nCol)
            aSecondaries[i]:size(nHeight, nWidth)
            DISPEND()
            pw():select(aSecondaries[i])
            ++nRow
            nCol  += 2
         END IF // .NOT. pvGetBit(aSecondaries[i]:getState(), PWST...
      NEXT i 

   END IF // (nHeight >= 10) .AND. (nWidth >= 14)

   RETURN(NIL)
   // END Cascade()



/*****************************************************************************
** STATIC ArrangeIcons() --> NIL
*****************************************************************************/
STATIC FUNCTION ArrangeIcons()

   LOCAL i


   FOR i := 1 TO LEN(aSecondaries)
      IF pvGetBit(aSecondaries[i]:getState(), PWSTATE_MINIMIZED)
         DISPBEGIN()
         aSecondaries[i]:restore()
         aSecondaries[i]:minimize()
         DISPEND()
      END IF // pvGetBit(aSecondaries[i]:getState(), PWSTATE_MINIM...
   NEXT i 

   RETURN(NIL)
   // END ArrangeIcons()

