/*****************************************************************************
** MEMSTAT.PRG
**
** ProVision:Windows v1.20 memory status
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


STATIC   oMemoryWnd                    // the memory status window



/*****************************************************************************
** MemoryWindow( oItemMemory ) --> oMemoryWnd
*****************************************************************************/
FUNCTION MemoryWindow( oItemMemory )


   IF oMemoryWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create a window.
      CREATE WINDOW oMemoryWnd ;
         AT pwMaxRow() -  09, 02 ;
         SIZE 09, 39 ;
         TITLE "Memory status" ;
         WINDOW HANDLER { | idMsg | MemoryWndHandler(idMsg, oItemMemory) }

      // Display the fixed text.
      @ 00, 02 SAY "                  current  change"
      @ 01, 02 SAY "Free pool       = "
      @ 02, 02 SAY "Largest block   = "
      @ 03, 02 SAY "Buffer space    = "
      @ 04, 02 SAY "SVOS estimate   = "
      @ 05, 02 SAY "EMS available   = "
      @ 06, 02 SAY "Fixed heap size = "

      // Call the memory display function to initialize the display.
      DispMemory()

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oMemoryWnd == NIL

   // Open the window.
   OPEN WINDOW oMemoryWnd

   // Return a reference to the window.
   RETURN(oMemoryWnd)
   // END MemoryWindow( oItemMemory )



/*****************************************************************************
** STATIC MemoryWndHandler( idMsg, oItemMemory ) --> lHandled
*****************************************************************************/
STATIC FUNCTION MemoryWndHandler( idMsg, oItemMemory )

   STATIC   nTimerID

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      oItemMemory:enable()

      // Remove the timer for the window.
      pw():delTimer(nTimerID)

   CASE idMsg == PWMSG_OPEN
      oItemMemory:disable()

      // Add a timer for the window to display the memory status every
      // five seconds.
      nTimerID := pw():addTimer(PWTIMER_PERIODIC, 5, { || DispMemory() })

   END CASE

   RETURN(lHandled)
   // END MemoryWndHandler( idMsg, oItemMemory )



/*****************************************************************************
** STATIC DispMemory() --> NIL
*****************************************************************************/
STATIC FUNCTION DispMemory()

   STATIC   aMem[6], ;
            aParams  := { 0, 1, 2, 3, 4, 101 }

   STATIC   nRow     := 00

   LOCAL i, ;
         nNewMem

   LOCAL oOutput


   // Initialize the memory elements.
   IF aMem[1] == NIL
      aMem  := {  MEMORY(0), ;
                  MEMORY(1), ;
                  MEMORY(2), ;
                  MEMORY(3), ;
                  MEMORY(4), ;
                  MEMORY(101) }
   END IF // aMem[1] == NIL

   // Save the current output window without affecting the current cursor
   // and/or color settings.
   oOutput  := pw():setOutput(oMemoryWnd, .F.)

   // Display an arrow to show activity.
   pwWriteChar(PWRW_TEXT, nRow, 00, 1, " ")
   IF nRow == 06
      nRow  := 01
   ELSE
      ++nRow
   END IF // nRow == 06
   pwWriteChar(PWRW_TEXT, nRow, 00, 1, "")

   // Display the new memory status.
   FOR i := 1 TO 6
      nNewMem  := MEMORY(aParams[i])
      pwWriteStr(PWRW_TEXT, i, 22, STR(nNewMem, 5, 0) + "   " + ;
         IIF((nNewMem - aMem[i]) < 0, "-", IIF((nNewMem - aMem[i]) > 0, ;
         "+", " ")) + STR(ABS(nNewMem - aMem[i]), 4, 0))
   NEXT i 

   // Restore the previous output window without affecting the current
   // cursor and/or color settings.
   pw():setOutput(oOutput, .F.)

   RETURN(NIL)
   // END DispMemory()

