/*****************************************************************************
** RANDOM.PRG
**
** ProVision:Windows v1.20 functions to return pseudorandom data
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/


#define RND_DIVISOR                    10000000
#define RND_FACTOR                     3236713



/*****************************************************************************
** NewAddress() --> cAddress
**
** Returns a pseudorandom address.
**
*****************************************************************************/
FUNCTION NewAddress()

   STATIC   aDirs    := { "", " N. ", " S. ", " E. ", " W. " }, ;
            aLabels  := { "St.", "Rd.", "Ln.", "Ave.", "Blvd.", "Dr." }, ;
            aStreets := { "First ", "Second ", "Third ", "Fourth ", ;
               "Fifth ", "Sixth ", "Seventh ", "Eighth ", "Ninth ", ;
               "Tenth ", "Oak ", "Elm ", "Maple ", "Pine ", "Aspen ", ;
               "Willow ", "Crabapple ", "Birch ", "Palm ", "Hickory ", ;
               "Mecury ", "Venus ", "Earth ", "Mars ", "Jupiter ", ;
               "Saturn ", "Uranus ", "Neptune ", "Pluto " }


   RETURN(LTRIM(STR(NewNumber(100, 20000))) + aDirs[NewNumber(1, 5)] + ;
      aStreets[NewNumber(1, 29)] + aLabels[NewNumber(1, 6)])
   // END NewAddress()



/*****************************************************************************
** NewCity() --> cCity
**
** Returns a pseudorandom city name.
**
*****************************************************************************/
FUNCTION NewCity()

   STATIC   aCities  := { "Walnut Creek", "Montgomery", "St. Ann", ;
               "Riverside", "Rose Hill", "West Lake", "Liverpool", ;
               "Hartford", "Norfolk", "Port Hope", "Ellenwood", ;
               "Overland", "Jefferson", "Rockville", "Sweet Springs", ;
               "New Villa", "Webster", "Uniontown", "Northwood", ;
               "Portland", "Lebanon", "Reading", "Cookeville", ;
               "Greenville", "Church Hill", "Alexandria", "Liberty", ;
               "Madison", "Richland", "Lynnwood", "Anderson", ;
               "Irvington" }


   RETURN(aCities[NewNumber(1, 32)])
   // END NewCity()



/*****************************************************************************
** NewCompany() --> cCompany
**
** Returns a pseudorandom company name.
**
*****************************************************************************/
FUNCTION NewCompany()

   STATIC   aPre     := { "Specialty ", "Custom ", "General ", "Master ", ;
               "Professional ", "Applied ", "Strategic ", "Resource ", ;
               "Cheap ", "Expensive ", "Amateur ", "Fast ", "Slow " }, ;
            aLabels  := { "", ", Inc.", ", Ltd.", " Int'l., Inc.", ;
               ", UnLtd.", " Corp.", " Int'l." }, ;
            aTypes   := { "Industries", "Programming", "Services", ;
               "Software", "Hardware", "Repair", "Cleaning", "Furniture", ;
               "Publishing", "Systems", "Communications", "Consulting", ;
               "Associates", "Instruments", "Management", "Design", ;
               "Technologies", "Group", "Development", "Enterprises", ;
               "Sciences", "Homemakers", "Childcare", "Landscaping", ;
               "Electronics" }


   RETURN(aPre[NewNumber(1, 13)] + aTypes[NewNumber(1, 25)] + ;
      aLabels[NewNumber(1, 7)])
   // END NewCompany()



/*****************************************************************************
** NewName() --> cContact
**
** Returns a pseudorandom personal name.
**
*****************************************************************************/
FUNCTION NewName()

   STATIC   aNames   := { "Appleby", "Barnes", "Christian", "Dolson", ;
               "Engles", "Fritch", "Garvey", "Holt", "Innervy", "Jenkins", ;
               "Kleese", "Lambert", "Masterson", "Nelms", "Oppenheimer", ;
               "Peterson", "Quesa", "Richards", "Smith", "Thompson", ;
               "Updike", "Varol", "Waters", "Xavier", "Young", ;
               "Zimmerman" }


   RETURN(CHR(NewNumber(65, 90)) + "." + CHR(NewNumber(65, 90)) + ". " + ;
      aNames[NewNumber(1, 26)])
   // END NewName()



/*****************************************************************************
** NewNumber( nLRange, nURange ) --> nNumber
**
** This function is a variation on a pseudorandom number generator found
** in the NanForum Toolkit.
**
*****************************************************************************/
FUNCTION NewNumber( nLRange, nURange )

   STATIC   nSeed


   // init seed
   IIF(nSeed == NIL, nSeed := SECONDS(), )

   RETURN(INT((nURange - nLRange + 1) * ((nSeed := MOD(nSeed * ;
      RND_FACTOR + 1, RND_DIVISOR)) / RND_DIVISOR)) + nLRange)
   // END NewNumber( nLRange, nURange )



/*****************************************************************************
** NewState() --> cState
**
** Returns a pseudorandom state name.
**
*****************************************************************************/
FUNCTION NewState()

   STATIC   aStates  := { "Alabama", "Alaska", "Arizona", "Arkansas", ;
               "California", "Colorado", "Connecticut", "Delaware", ;
               "Florida", "Georgia", "Hawaii", "Idaho", ;
               "Illinois", "Indiana", "Iowa", "Kansas", ;
               "Kentucky", "Louisiana", "Maine", "Maryland", ;
               "Massachusetts", "Michigan", "Minnesota", "Mississippi", ;
               "Missouri", "Montanna", "Nebraska", "Nevada", ;
               "New Hampshire", "New Jersey", "New Mexico", "New York", ;
               "North Carolina", "North Dakota", "Ohio", "Oklahoma", ;
               "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", ;
               "South Dakota", "Tennessee", "Texas", "Utah", ;
               "Vermont", "Virginia", "Washington", "West Virginia", ;
               "Wisconsin", "Wyoming" }


   RETURN(aStates[NewNumber(1, 50)])
   // END NewState()

