/*****************************************************************************
** TEXTEDIT.PRG
**
** ProVision:Windows v1.20 textedit window sample
**
** by J. David Reynolds
**
** Copyright 1991, 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


STATIC   nFilter                       // filter for changing the cursor shape

STATIC   oTextWnd                      // the window that holds the text



/*****************************************************************************
** TextWindow( oItemText ) --> oTextWnd
**
** This function creates a textedit window and returns a reference to it.
**
*****************************************************************************/
FUNCTION TextWindow( oItemText )

   LOCAL oMenu


   IF oTextWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create a window--it should probably have scrollbars.
      CREATE TEXTEDIT WINDOW oTextWnd ;
         AT 07, 15 ;
         SIZE 12, 50 ;
         VIRTUAL SIZE pwMaxRow() - 2, pwMaxCol() - 2 ;
         MAXLINES 1000 ;
         BUFFERSIZE 16 * 1024 ;
         STYLE PWSTYLE_PRIMARY + ;
            PWSTYLEINFO_KEEPVSCROLLBAR + PWSTYLEINFO_KEEPHSCROLLBAR ;
         TITLE "Textedit" ;
         WINDOW HANDLER { | idMsg | TextWndHandler(idMsg, oItemText) } ;

      // Set the initial string.
      oTextWnd:store(0, "")

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oTextWnd == NIL

   // Create a menu for the window.
   MENU oMenu

      POPUP PROMPT "~File"
         MENUITEM PROMPT "~New" ;
            ACTION { || oTextWnd:store(0, ""), oTextWnd:display() }
         MENUITEM PROMPT "~Open..." ;
            ACTION { || OpenFile(oTextWnd) }
         SEPARATOR
         MENUITEM PROMPT "E~xit\tAlt+F4" ;
            ACTION { || oTextWnd:close() }
      END POPUP // File

      pwEditMenu()

   END MENU // oMenu

   ATTACH MENU oMenu TO oTextWnd

   // Open the window.
   OPEN WINDOW oTextWnd

   // Add a window message filter to change the mouse cursor to an "I-beam"
   // when it is over the textedit window.
   nFilter  := oTextWnd:addFilter({ | idMsg, xParam1, xParam2, xParam3, ;
      xParam4 | TextFilter(idMsg, xParam1, xParam2, xParam3, xParam4) }, ;
      PWMSG_MOUSEMOVEMENT)

   // Return a reference to the window.
   RETURN(oTextWnd)
   // END TextWindow( oItemText )



/*****************************************************************************
** STATIC TextWndHandler( idMsg, oItemText ) --> lHandled
*****************************************************************************/
STATIC FUNCTION TextWndHandler( idMsg, oItemText )

   LOCAL lHandled := .T.


   DO CASE
   CASE idMsg == PWMSG_CLOSE
      oItemText:enable()

      // Delete the window filter that changes the mouse cursor.
      oTextWnd:delFilter(nFilter)

   CASE idMsg == PWMSG_OPEN
      oItemText:disable()

   END CASE

   RETURN(lHandled)
   // END TextWndHandler( idMsg, oItemText )



/*****************************************************************************
** STATIC TextFilter( idMsg, xParam1, xParam2, xParam3, xParam4 )
**
** This function implements a window message filter to change the mouse
** cursor to an "I-beam" when it is over the textedit window.
**
*****************************************************************************/
STATIC FUNCTION TextFilter( idMsg, xParam1, xParam2, xParam3, xParam4 )

   STATIC   lIsNormal   := .T.

   STATIC   xCursor

   LOCAL nWndCol, ;
         nWndRow


   // Convert screen position to window position.
   oTextWnd:screenToWnd(xParam2, xParam3, @nWndRow, @nWndCol)

   // Test for visibility of window position.
   IF oTextWnd:isPosVisible(nWndRow, nWndCol)
      IF lIsNormal
         lIsNormal   := .F.
         xCursor     := pw():mouseCursor()
         pw():mouseDefine( ;
            CHR(pvBin2Num("00010001")) + ;
            CHR(pvBin2Num("00000001")) + ;
            CHR(pvBin2Num("10000011")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("11000111")) + ;
            CHR(pvBin2Num("10000011")) + ;
            CHR(pvBin2Num("00000001")) + ;
            CHR(pvBin2Num("00010001")) + ;
            CHR(pvBin2Num("11111111")) + ;
            CHR(pvBin2Num("11111111")) + ;
            CHR(pvBin2Num("11111111")) + ;
            CHR(pvBin2Num("11111111")), ;
            CHR(pvBin2Num("00000000")) + ;
            CHR(pvBin2Num("01101100")) + ;
            CHR(pvBin2Num("00111000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00010000")) + ;
            CHR(pvBin2Num("00111000")) + ;
            CHR(pvBin2Num("01101100")) + ;
            CHR(pvBin2Num("00000000")) + ;
            CHR(pvBin2Num("00000000")) + ;
            CHR(pvBin2Num("00000000")) + ;
            CHR(pvBin2Num("00000000")) + ;
            CHR(pvBin2Num("00000000")), ;
            3, ;
            7)
      END IF // lIsNormal
   ELSE
      IF .NOT. lIsNormal
         lIsNormal   := .T.
         pw():mouseCursor(xCursor)
      END IF // .NOT. lIsNormal
   END IF // oTextWnd:isPosVisible(nWndRow, nWndCol)

   RETURN(NIL)
   // END TextFilter( idMsg, xParam1, xParam2, xParam3, xParam4 )



/*****************************************************************************
** STATIC OpenFile(oWnd)
**
** This function prompts the user for a filename and loads the contents of the
** file into the textedit window.  This demo is limited to loading only the
** first 16K and/or 1000 lines into the buffer.
**
*****************************************************************************/
STATIC FUNCTION OpenFile( oWnd )

   LOCAL cFilename


   cFilename   := FileBox()

   IF .NOT. EMPTY(cFilename)
      oWnd:store(PWTE_WRAP, MEMOREAD(cFilename))
      oWnd:display()
   ENDIF

   RETURN(NIL)
   // END OpenFile( oWnd )

