/*****************************************************************************
** USING.PRG
**
** ProVision:Windows v1.20 demo of using windows
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)


STATIC   oUsingWnd                     // the sample window



/*****************************************************************************
** UsingFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the Using windows topic.
**
*****************************************************************************/
FUNCTION UsingFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := UsingList()

   LOCAL lContinue   := .T.


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame < 1
      // If the sample window is still open, close it.
      IF (oUsingWnd != NIL) .AND. ;
            pvGetBit(oUsingWnd:getState(), PWSTATE_OPEN)
         oUsingWnd:close()
      END IF // (oUsingWnd != NIL) .AND. ...

   CASE nFrame == 1
      // Open the sample window, but reselect the topics window.
      DISPBEGIN()
      UsingWindow()
      pw():select(oTopicWnd)
      DISPEND()

      // Display the message for this frame.
      MsgBox("This topic covers the commands used to create, open, " + ;
         "close, and destroy windows." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("The CREATE WINDOW... command is used, logically enough, " + ;
         "to create new windows.  The location and size clauses are " + ;
         "required, and there are several optional clauses." + CRLF + ;
         CRLF + ;
         "ProVision:Windows windows are represented by objects.  When " + ;
         "creating a window you must supply a memory variable to " + ;
         "store a reference to the window object.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   CREATE WINDOW oUsingWnd ;'))

   CASE nFrame == 3
      // Display the message for this frame.
      MsgBox("The window's location may be specified either as " + ;
         "'AT <nRow>, <nCol>' or as 'CENTERED'.  If 'CENTERED' is " + ;
         "used, the window will be centered on the physical screen.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      AT 01, pwMaxCol() / 2 ;'))

   CASE nFrame == 4
      // Display the message for this frame.
      MsgBox("The window's size includes space for the borders and " + ;
         "menu, if any.  The right border is two characters wide.  " + ;
         "Each of the other borders is one character wide.  Be " + ;
         "sure to take these into account when specifying the " + ;
         "window's size.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      SIZE 10, 39 ;'))

   CASE nFrame == 5
      // Display the message for this frame.
      MsgBox("ProVision:Windows defines several standard 'styles' for " + ;
         "windows, and custom styles can also be specified.  The " + ;
         "style mainly determines what the window will look like " + ;
         "and in what ways it can be manipulated by the user.  " + ;
         "PWSTYLE_PRIMARY is a standard style with a titlebar, " + ;
         "scrollbars, etc.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      STYLE PWSTYLE_PRIMARY - PWSTYLEINFO_MENU ;'))

   CASE nFrame == 6
      // Display the message for this frame.
      MsgBox("Windows with titlebars can have titles.  The title is " + ;
         "displayed centered within the titlebar.  If no title is " + ;
         "specified, the default is 'Untitled.'")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      TITLE "My first window" ;'))

   CASE nFrame == 7
      // Display the message for this frame.
      MsgBox("This clause sets up a custom window message handler " + ;
         "for the window.  A window handler is not required, but " + ;
         "we are going to use this one a little later to " + ;
         "demonstrate destroying the window.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      WINDOW HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'))

   CASE nFrame == 8
      // Display the message for this frame.
      MsgBox("After a window has been created it can be opened.  " + ;
         "Opening the window makes it visible and also identifies it " + ;
         "to ProVision:Windows.  Once the window has been opened, " + ;
         "ProVision:Windows automatically handles interaction between " + ;
         "the user and the window, such as moving, sizing, scrolling, " + ;
         "etc." + CRLF + ;
         CRLF + ;
         "Try moving and sizing the sample window on the right.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   OPEN WINDOW oUsingWnd'))

   CASE nFrame == 9
      // Display the message for this frame.
      MsgBox("The 'Close' pushbutton in our sample window uses this " + ;
         "command.  The CLOSE WINDOW... command hides the window but " + ;
         "does not destroy it.  A window can also be closed by sending " + ;
         "the window object a close() message." + CRLF + ;
         CRLF + ;
         "Press the 'Close' pushbutton in the sample window now.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   CLOSE WINDOW oUsingWnd'))

   CASE nFrame == 10
      // Display the message for this frame.
      MsgBox("Destroying a window releases the VMM memory associated " + ;
         "with the window.  If the window is open, it will be closed " + ;
         "automatically before it is destroyed.  This sample window " + ;
         "uses a custom window message handler to automatically " + ;
         "destroy the window whenever it is closed.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '         DESTROY WINDOW oUsingWnd'))

   CASE nFrame == 11
      // Display the message for this frame.
      MsgBox("You will probably want to create a window once, store it " + ;
         "in a STATIC memory variable, and then open and close it as " + ;
         "needed.  This avoids repeatedly creating and destroying " + ;
         "windows, thus saving time and using memory more efficiently.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         'STATIC oUsingWnd'))

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END UsingFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC UsingList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Using windows."
**
*****************************************************************************/
STATIC FUNCTION UsingList()

   STATIC   aListing[116]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** USING.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of using windows'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := '#include "pw.ch"'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := 'STATIC oUsingWnd'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** UsingWindow() --> oUsingWnd'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function demonstrates creating, opening, closing, and destroying'
      aListing[i++]  := '** windows.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'FUNCTION UsingWindow()'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL GetList := {}'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // Create the window.'
      aListing[i++]  := '   CREATE WINDOW oUsingWnd ;'
      aListing[i++]  := '      AT 01, pwMaxCol() / 2 ;'
      aListing[i++]  := '      SIZE 10, 39 ;'
      aListing[i++]  := '      STYLE PWSTYLE_PRIMARY - PWSTYLEINFO_MENU ;'
      aListing[i++]  := '      TITLE "My first window" ;'
      aListing[i++]  := '      WINDOW HANDLER { | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'
      aListing[i++]  := '         UsingWndHandler( idMsg, xParam1, xParam2, xParam3, xParam4) }'
      aListing[i++]  := ''
      aListing[i++]  := '   // Create a Close pushbutton for the window.'
      aListing[i++]  := '   @ 03, 13 GET AS PUSHBUTTON ;'
      aListing[i++]  := '      PROMPT " Close " ;'
      aListing[i++]  := '      ACTION { || UsingClose() }'
      aListing[i++]  := ''
      aListing[i++]  := '   // Attach the pushbutton to the window.'
      aListing[i++]  := '   ATTACH CONTROLS TO oUsingWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Open the window.'
      aListing[i++]  := '   OPEN WINDOW oUsingWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Return a reference to the window.'
      aListing[i++]  := '   RETURN(oUsingWnd)'
      aListing[i++]  := '   // END UsingWindow()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** STATIC UsingWndHandler( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '**                         xParam4 ) --> lHandled'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function is the window message handler for oUsingWnd.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'STATIC FUNCTION UsingWndHandler( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '                                 xParam4 )'
      aListing[i++]  := ''
      aListing[i++]  := '   STATIC lDestroyed'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL lHandled := .T.'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   DO CASE'
      aListing[i++]  := '   CASE idMsg == PWMSG_CLOSE'
      aListing[i++]  := '      //'
      aListing[i++]  := '      // This shows how a window can be destroyed automatically when it is'
      aListing[i++]  := '      // closed.  By default, windows are _not_ destroyed when closed so'
      aListing[i++]  := '      // that a closed window can be reopened.'
      aListing[i++]  := '      //'
      aListing[i++]  := '      // The use of lDestroyed is necessary because DESTROY WINDOW... also'
      aListing[i++]  := '      // tries to close the window.  Without this precaution, an infinite'
      aListing[i++]  := '      // loop forms with the close logic trying to destroy the window and'
      aListing[i++]  := '      // the destroy logic trying to close it.'
      aListing[i++]  := '      //'
      aListing[i++]  := '      IF .NOT. lDestroyed'
      aListing[i++]  := '         lDestroyed := .T.'
      aListing[i++]  := '         DESTROY WINDOW oUsingWnd'
      aListing[i++]  := '      END IF // .NOT. lDestroyed'
      aListing[i++]  := ''
      aListing[i++]  := '   CASE idMsg == PWMSG_CREATE'
      aListing[i++]  := '      lDestroyed := .F.'
      aListing[i++]  := ''
      aListing[i++]  := '   END CASE'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(lHandled)'
      aListing[i++]  := '   // END UsingWndHandler( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** STATIC UsingClose() --> NIL'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function closes the window.  A window can also be closed simply by'
      aListing[i++]  := '** sending it a close() message.  This function is intended only to'
      aListing[i++]  := '** demonstrate the CLOSE WINDOW... command.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'STATIC FUNCTION UsingClose()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   CLOSE WINDOW oUsingWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(NIL)'
      aListing[i++]  := '   // END UsingClose()'
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END UsingList()



/*****************************************************************************
** STATIC UsingWindow() --> oUsingWnd
**
** This function creates and opens the sample window for this topic.
**
*****************************************************************************/
STATIC FUNCTION UsingWindow()

   LOCAL GetList  := {}


   // If the window has not been created, do so.
   IF oUsingWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create the window.
      CREATE WINDOW oUsingWnd ;
         AT 01, pwMaxCol() / 2 ;
         SIZE 10, 39 ;
         STYLE PWSTYLE_PRIMARY - PWSTYLEINFO_MENU ;
         TITLE "My first window"

      // Create a Close pushbutton for the window.
      @ 03, 13 GET AS PUSHBUTTON ;
         PROMPT " Close " ;
         ACTION { || oUsingWnd:close() }

      // Attach the pushbutton to the window.
      ATTACH CONTROLS TO oUsingWnd

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oUsingWnd == NIL

   // Open the window.
   OPEN WINDOW oUsingWnd

   // Return a reference to the window.
   RETURN(oUsingWnd)
   // END UsingWindow()

