/*****************************************************************************
** WRITING.PRG
**
** ProVision:Windows v1.20 demo of writing to windows
**
** by J. David Reynolds
**
** Copyright 1992 SofDesign International, Inc.
** All rights reserved
**
** tab spacing = 3
**
*****************************************************************************/

#include "pw.ch"


#define CRLF                           CHR(13) + CHR(10)


STATIC   oWritingWnd                   // the sample window



/*****************************************************************************
** WritingFrames( nFrame oTopicWnd, oListing ) --> NIL
**
** This function executes the next frame for the Writing to windows topic.
**
*****************************************************************************/
FUNCTION WritingFrames( nFrame, oTopicWnd, oListing )

   LOCAL aListing    := WritingList()

   LOCAL lContinue   := .T.


   // Set the code listing to the proper value.
   IF (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)
      oListing:setArray(aListing)
   END IF // (LEN(oListing:getArray()) == 0) .AND. (nFrame > 0)

   DO CASE
   CASE nFrame < 1
      // If the sample window is still open, close it.
      IF (oWritingWnd != NIL) .AND. ;
            pvGetBit(oWritingWnd:getState(), PWSTATE_OPEN)
         oWritingWnd:close()
      END IF // (oWritingWnd != NIL) .AND. ...

   CASE nFrame == 1
      // Open the sample window, but reselect the topics window.
      DISPBEGIN()
      WritingWindow()
      pw():select(oTopicWnd)
      DISPEND()

      // Display the message for this frame.
      MsgBox("This topic covers writing to windows." + CRLF + ;
         CRLF + ;
         "Feel free to browse through the code listing at any time.")

   CASE nFrame == 2
      // Display the message for this frame.
      MsgBox("With ProVision:Windows, writing to windows couldn't be " + ;
         "easier--just use Clipper's standard output commands and " + ;
         "functions!  ALL output from @...SAY, ?, ??, TEXT...ENDTEXT, " + ;
         "and even TBROWSE is directed to the current window.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      // Write using @...SAY...COLOR.'))

   CASE nFrame == 3
      // Display the message for this frame.
      MsgBox("Here's @...SAY...COLOR...")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 02, 02 SAY "Written with @...SAY...COLOR" COLOR "+R/BG"'))

   CASE nFrame == 4
      // Display the message for this frame.
      MsgBox("...and ?, ??, and SETPOS().")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      ? "  Written with ?"'))

   CASE nFrame == 5
      // Display the message for this frame.
      MsgBox("It's easy to change the color...")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      SETCOLOR("+GR/B")'))

   CASE nFrame == 6
      // Display the message for this frame.
      MsgBox("...or to draw lines and boxes.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      @ 01, 01 TO 06, 30'))

   CASE nFrame == 7
      // Display the message for this frame.
      MsgBox("You can even use SCROLL() to scroll or clear an area.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '      SCROLL(01, 32, 06, 36, 0)'))

   CASE nFrame == 8
      // Display the message for this frame.
      MsgBox("The window with input focus (a highlighted border) is by " + ;
         "default also the current output window.  ProVision:Windows " + ;
         "allows you to write to any window, however, even if it is not " + ;
         "currently open!" + CRLF + ;
         CRLF + ;
         "Press a mouse button a few times now to see output directed " + ;
         "to the sample window.")

   CASE nFrame == 9
      // Display the message for this frame.
      MsgBox("The pw():setOutput() system method is used to direct " + ;
         "output to a new window simply by passing a reference to the " + ;
         "window object.  It returns a reference to the current output " + ;
         "window object so that you can restore it when you have " + ;
         "finished writing.")

      // Position the code listing.
      oListing:setValue(ASCAN(aListing, ;
         '   LOCAL oOutput  := pw():setOutput(oWritingWnd, .F.)'))

   CASE nFrame == 10
      // Display the message for this frame.
      MsgBox("One enhancment that ProVision:Windows makes to Clipper's " + ;
         "standard output is that all coordinates are allowed to be " + ;
         "negative.  For example, if you use" + CRLF + ;
         CRLF + ;
         "   @ 00, -03 SAY 'window'" + CRLF + ;
         CRLF + ;
         "just 'dow' will appear in the window at position 00, 00.")

      // Inform the topics window that this is the last frame.
      lContinue   := .F.

   END CASE

   // Return continuation flag.
   RETURN(lContinue)
   // END WritingFrames( nFrame, oTopicWnd, oListing )



/*****************************************************************************
** STATIC WritingList() --> aListing
**
** This function returns an array containing the text of the code sample to
** be shown in "Writing to windows."
**
*****************************************************************************/
STATIC FUNCTION WritingList()

   STATIC   aListing[118]

   LOCAL i  := 1


   IF aListing[1] == NIL
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** WRITING.PRG'
      aListing[i++]  := '**'
      aListing[i++]  := '** ProVision:Windows v1.20 demo of writing to windows'
      aListing[i++]  := '**'
      aListing[i++]  := '** by J. David Reynolds'
      aListing[i++]  := '**'
      aListing[i++]  := '** Copyright 1992 SofDesign International, Inc.'
      aListing[i++]  := '** All rights reserved'
      aListing[i++]  := '**'
      aListing[i++]  := '** tab spacing = 3'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := ''
      aListing[i++]  := '#include "pw.ch"'
      aListing[i++]  := '#include "pwmouse.ch"'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := 'STATIC oWritingWnd'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** WritingWindow() --> oWritingWnd'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function demonstrates writing to windows.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'FUNCTION WritingWindow()'
      aListing[i++]  := ''
      aListing[i++]  := '   STATIC nFilter'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   // If the window has not been created, do so.'
      aListing[i++]  := '   IF oWritingWnd == NIL'
      aListing[i++]  := ''
      aListing[i++]  := '      // Turn the mouse cursor into an hourglass.'
      aListing[i++]  := '      pw():mouseCursor(PMCURSOR_HOUR)'
      aListing[i++]  := ''
      aListing[i++]  := '      // Create the window.'
      aListing[i++]  := '      CREATE WINDOW oWritingWnd ;'
      aListing[i++]  := '         AT 01, pwMaxCol() / 2 ;'
      aListing[i++]  := '         SIZE 10, 39 ;'
      aListing[i++]  := '         STYLE PWSTYLE_DIALOG ;'
      aListing[i++]  := '         TITLE "A little color"'
      aListing[i++]  := '         WINDOW HANDLER { | idMsg | IIF(idMsg == PWMSG_CLOSE, ;'
      aListing[i++]  := '            pw():delFilter(nFilter), ), .T. }'
      aListing[i++]  := ''
      aListing[i++]  := '      // Write using @...SAY...COLOR.'
      aListing[i++]  := '      @ 02, 02 SAY "Written with @...SAY...COLOR" COLOR "+R/BG"'
      aListing[i++]  := ''
      aListing[i++]  := '      // Write using ?.'
      aListing[i++]  := '      ? "  Written with ?"'
      aListing[i++]  := ''
      aListing[i++]  := '      // Write using SETPOS() and ??.'
      aListing[i++]  := '      SETCOLOR("+R/B")'
      aListing[i++]  := '      SETPOS(ROW() + 1, 02)'
      aListing[i++]  := '      ?? "Written with SETPOS() and ??"'
      aListing[i++]  := ''
      aListing[i++]  := '      // Draw a box around what we just wrote.'
      aListing[i++]  := '      SETCOLOR("+GR/B")'
      aListing[i++]  := '      @ 01, 01 TO 06, 30'
      aListing[i++]  := ''
      aListing[i++]  := '      // Use SCROLL() to clear an area.'
      aListing[i++]  := '      SETCOLOR("+W/G")'
      aListing[i++]  := '      SCROLL(01, 32, 06, 36, 0)'
      aListing[i++]  := ''
      aListing[i++]  := '      // Turn the mouse cursor back into an arrow.'
      aListing[i++]  := '      pw():mouseCursor(PMCURSOR_ARROW)'
      aListing[i++]  := ''
      aListing[i++]  := '   END IF // oWritingWnd == NIL'
      aListing[i++]  := ''
      aListing[i++]  := '   // Open the window.'
      aListing[i++]  := '   OPEN WINDOW oWritingWnd'
      aListing[i++]  := ''
      aListing[i++]  := '   // Install a system message filter.'
      aListing[i++]  := '   nFilter := pw():addFilter({ | idMsg, xParam1, xParam2, xParam3, xParam4 | ;'
      aListing[i++]  := '      WritingFilter( idMsg, xParam1, xParam2, xParam3, xParam4 ) }, ;'
      aListing[i++]  := '      PWMSG_MOUSEPRESS, PWMSG_MOUSERELEASE, PWMSG_MOUSEHELD)'
      aListing[i++]  := ''
      aListing[i++]  := '   // Return a reference to the window.'
      aListing[i++]  := '   RETURN(oWritingWnd)'
      aListing[i++]  := '   // END WritingWindow()'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '/*****************************************************************************'
      aListing[i++]  := '** STATIC WritingFilter( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '**                       xParam4 ) --> NIL'
      aListing[i++]  := '**'
      aListing[i++]  := '** This function serves as a system message filter for the sample window.'
      aListing[i++]  := '**'
      aListing[i++]  := '*****************************************************************************/'
      aListing[i++]  := 'STATIC FUNCTION WritingFilter( idMsg, xParam1, xParam2, xParam3, ;'
      aListing[i++]  := '                               xParam4 )'
      aListing[i++]  := ''
      aListing[i++]  := '   LOCAL oOutput  := pw():setOutput(oWritingWnd, .F.)'
      aListing[i++]  := ''
      aListing[i++]  := ''
      aListing[i++]  := '   DO CASE'
      aListing[i++]  := '   CASE idMsg == PWMSG_MOUSEPRESS'
      aListing[i++]  := '      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;'
      aListing[i++]  := '         "Right") + " mouse button pressed. ")'
      aListing[i++]  := ''
      aListing[i++]  := '   CASE idMsg == PWMSG_MOUSERELEASE'
      aListing[i++]  := '      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;'
      aListing[i++]  := '         "Right") + " mouse button released.")'
      aListing[i++]  := ''
      aListing[i++]  := '   CASE idMsg == PWMSG_MOUSEHELD'
      aListing[i++]  := '      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;'
      aListing[i++]  := '         "Right") + " mouse button held.    ")'
      aListing[i++]  := ''
      aListing[i++]  := '   END CASE'
      aListing[i++]  := ''
      aListing[i++]  := '   pw():setOutput(oOutput, .F.)'
      aListing[i++]  := ''
      aListing[i++]  := '   RETURN(NIL)'
      aListing[i++]  := '   // END WritingEventHandler( idMsg, xParam1, xParam2, xParam3, ;'
   END IF // aListing[1] == NIL

   RETURN(aListing)
   // END WritingList()



/*****************************************************************************
** STATIC WritingWindow() --> oWritingWnd
**
** This function creates and opens the sample window for this topic.
**
*****************************************************************************/
STATIC FUNCTION WritingWindow()

   STATIC   nFilter


   // If the window has not been created, do so.
   IF oWritingWnd == NIL

      // Turn the mouse cursor into an hourglass (or display a wait message).
      WaitMsg(.T.)

      // Create the window.
      CREATE WINDOW oWritingWnd ;
         AT 01, pwMaxCol() / 2 ;
         SIZE 10, 39 ;
         STYLE PWSTYLE_DIALOG ;
         TITLE "A little color" ;
         WINDOW HANDLER { | idMsg | IIF(idMsg == PWMSG_CLOSE, ;
            pw():delFilter(nFilter), ), .T. }

      // Write using @...SAY...COLOR.
      @ 02, 02 SAY "Written with @...SAY...COLOR" COLOR "+R/BG"

      // Write using ?.
      ? "  Written with ?"

      // Write using SETPOS() and ??.
      SETCOLOR("+R/B")
      SETPOS(ROW() + 1, 02)
      ?? "Written with SETPOS() and ??"

      // Draw a box around what we just wrote.
      SETCOLOR("+GR/B")
      @ 01, 01 TO 06, 30

      // Use SCROLL() to clear an area.
      SETCOLOR("+W/G")
      SCROLL(01, 32, 06, 36, 0)

      // Restore the mouse cursor (or remove the wait message).
      WaitMsg(.F.)

   END IF // oWritingWnd == NIL

   // Open the window.
   OPEN WINDOW oWritingWnd

   // Install a system message filter.
   nFilter  := pw():addFilter({ | idMsg, xParam1, xParam2, xParam3, xParam4 | ;
         WritingFilter( idMsg, xParam1, xParam2, xParam3, xParam4 ) }, ;
         PWMSG_MOUSEPRESS, PWMSG_MOUSERELEASE, PWMSG_MOUSEHELD)

   // Return a reference to the window.
   RETURN(oWritingWnd)
   // END WritingWindow()



/*****************************************************************************
** STATIC WritingFilter( idMsg, xParam1, xParam2, xParam3, ;
**                       xParam4 ) --> NIL
**
** This function serves as a system message filter for the sample window.
**
*****************************************************************************/
STATIC FUNCTION WritingFilter(   idMsg, xParam1, xParam2, xParam3, ;
                                 xParam4 )

   LOCAL oOutput  := pw():setOutput(oWritingWnd, .F.)


   DO CASE
   CASE idMsg == PWMSG_MOUSEPRESS
      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;
         "Right") + " mouse button pressed. ")

   CASE idMsg == PWMSG_MOUSERELEASE
      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;
         "Right") + " mouse button released.")

   CASE idMsg == PWMSG_MOUSEHELD
      pwWriteStr(PWRW_TEXT, 05, 02, IIF(xParam1 == PMBUTTON_LEFT, "Left ", ;
         "Right") + " mouse button held.    ")

   END CASE

   pw():setOutput(oOutput, .F.)

   RETURN(NIL)
   // END WritingFilter(   idMsg, xParam1, xParam2, xParam3, ;

