/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

void getviewsettings(struct viewporttype  *viewport)
{
  _DO_INIT_CHECK;
  viewport->left   = VL;
  viewport->right  = VR;
  viewport->top    = VT;
  viewport->bottom = VB;
  viewport->clip   = __gr_clip;
}

/* ----------------------------------------------------------------- */
void setviewport(int left, int top, int right, int bottom, int clip)
{
  int mm;

  _DO_INIT_CHECK;
  GrSetContext( NULL);         /* ViewPort == Full screen */
  if (left > right) SWAP(left,right);
  if (bottom < top) SWAP(bottom,top);
  if (left < 0) left = 0;
  if (right > (mm=getmaxx())) right = mm;
  if (top < 0) top = 0;
  if (bottom > (mm=getmaxy())) bottom = mm;
  __gr_clip = clip;
  VL = left;
  VR = right;
  VT = top;
  VB = bottom;
  __gr_Reset_ClipBox();
  moveto( 0,0);
}
