/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

void fillellipse( int x, int y, int xradius, int yradius)
{
  _DO_INIT_CHECK;
  x += VL;
  y += VT;
  xradius = XR(xradius);
  yradius = YR(yradius);
  switch (FPATT) {
    case SOLID_FILL :
      GrFilledEllipse( x, y, xradius, yradius, FILL);
      if (COL != FILL)
	GrEllipse( x, y, xradius, yradius, COL);
      break;
    case EMPTY_FILL :
      GrFilledEllipse( x, y, xradius, yradius, COLBG);
      if (COL != COLBG)
	GrEllipse( x, y, xradius, yradius, COL);
      break;
    default :
      FILLP.gp_bmp_fgcolor = FILL;
      FILLP.gp_bmp_bgcolor = COLBG;
      GrPatternFilledEllipse( x, y, xradius, yradius, &FILLP);
      GrEllipse( x, y, xradius, yradius, COL);
      break;
  }
}

