/*
   BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
   Copyright (C) 1993  Hartmut Schirmer

   see bccgrx.c for details


   Borland like delay() function

   The delay function is realized by
   monitoring the hardware time and
   the interrupt driven software timer.
   No timer value is altered.
*/

	.globl  _delay
_delay:
	pushl   %ebp
	movl    %esp,%ebp

	pushl   %ebx
	push    %edx

	movl    8(%ebp),%edx
	cmpl    $0, %edx
	je      done


	cli
	movl    0xE000046A, %eax
	movb    $4, %al
	out     %al, $0x43
	call    wait
	inb     $0x40, %al
	mov     %al, %bl
	call    wait
	inb     $0x40, %al
	sti
	movb    %al, %ah
	movb    %bl, %al
	notw    %ax

	imull   $19091,%edx,%edx
	shr     $4, %edx
	addl    %eax, %edx

loop:   cli
	movl    0xE000046A, %eax
	movb    $4, %al
	out     %al, $0x43
	call    wait
	inb     $0x40, %al
	movb    %al, %bl
	call    wait
	inb     $0x40, %al
	sti
	movb    %al, %ah
	movb    %bl, %al
	notw    %ax

	movl    %edx, %ebx
	subl    %eax, %ebx
	jae     loop

done:   popl    %edx
	popl    %ebx
	leave
wait:   ret
