/*
 *	WADFILE.H
 *
 *	Version 1.0.0
 *
 *	Abstract:
 *	 This module contains all the WADFILE definitions for the WadLib library.
 *
 *	History:
 *	 1.0.0	(March 31, 1994)
 *
 *  Author:
 *	 Michael McMahon
 *
 ****************************************************************************
 * Wadfile Structure Directory
 *---------------------------------------------------------------------------
 *Index: Name	  : Description
 *---------------------------------------------------------------------------
 * #1  : Wadfile  : The definition for a Wadfile context.
 ****************************************************************************
 *
 *  WADLIB SOFTWARE LICENSE AGREEMENT
 *
 *	1. GRANT OF LICENSE. Michael McMahon and his affiliations (collectively
 *	   the "AUTHOR") grant you (either an individual or an entity) the
 *	   non-exclusive, royalty-free right to use this library source code,
 *	   documentation, and sample code (collectively, the "SOFTWARE") for
 *	   any lawful purpose subject to the terms of this license.  By using the
 *	   SOFTWARE you are agreeing to be bound to all the terms of this license.
 *
 *	2. COPYRIGHT.  The SOFTWARE is Copyright (c) 1994, Michael McMahon,
 *	   PO Box 14807, San Luis Nabisco, CA 93406-4807 USA. All Rights Reserved
 *	   Worldwide.  You may not use, modify, or distribute the SOFTWARE except
 *	   as otherwise provided herein.
 *
 *	2. DECLARATION OF PUBLIC DOMAIN DISTRIBUTION AND USE. The distribution
 *	   and use of the SOFTWARE is hereby designated PUBLIC DOMAIN by the
 *	   the AUTHOR.	You may not sell, rent, or lease this SOFTWARE.  The
 *	   SOFTWARE may be reproduced verbatim in part or in full by any
 *	   reproduction means for any lawful purpose, and may also be subject to
 *	   the following agreement.
 *
 *	3. AGREEMENT FOR USE OF SOFTWARE. The AUTHOR grants you a non-exclusive,
 *	   royalty-free right to incorporate the SOFTWARE into any production for
 *	   any legal purpose as long as you agree
 *		(a) to indemnify, hold harmless, and defend the AUTHOR from and against
 *			any claims or lawsuits, including attorneys' fees, that arise or
 *			result from the use or distribution of your software production; and
 *		(b) no matter how much the SOFTWARE is modified, the AUTHOR owns the
 *			copyright and this original, unmodified copyright notice remains
 *			intact in the source code; and,
 *		(c) the AUTHOR is not held responsible for fixing bugs or making
 *			enhancements or changes to the SOFTWARE for any reason; and,
 *		(d) the SOFTWARE is not redistributed if it is modified in any way; and,
 *      (e) otherwise comply with the terms of this agreement; and,
 *		(f) the AUTHOR is forgiven for making so many demands.
 *
 *	 THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. THE
 *	 AUTHOR FURTHER DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING WITHOUT
 *	 LIMITATION ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR OF FITNESS
 *	 FOR A PARTICULAR PURPOSE.	THE ENTIRE RISK ARISING OUT OF THE USE
 *	 OR PERFORMANCE OF THE SOFTWARE REMAINS WITH YOU.
 *
 *	 The author can be reached at:
 *	  Michael McMahon
 *	  P.O. Box 14807
 *	  San Luis Nabisco, CA 93406-4807 USA
 *	  Internet: mmcmahon@oboe.calpoly.edu
 *	  [Bug reports, suggestions, success stories, etc. are welcome; tech
 *	   support, and other unnecessary two-way mail, is not]
 */

#ifndef WADFILE
#define WADFILE

/* Values that are DOOM specific */
#define DOOM_LASTEPISODE	 3
#define DOOM_BOSSLEVEL		 8
#define DOOM_LASTMAP		 9
#define NUM_ENTRIES_PER_MAP  11

/* Values for flag field */
#define FLAG_WADFILE_OPEN		1
#define FLAG_WADFILE_IWAD		2
#define FLAG_WADFILE_DIRCACHED	4
#define FLAG_WADFILE_WRITEONLY	8
#define FLAG_LUMP_OPEN			16

/* Fixed wadfile sizes */
#define SIZEOF_WAD_DIR_LOCATION 4
#define SIZEOF_WAD_DIR_SIZE 	4
#define SIZEOF_WAD_SIGNATURE	4
#define SIZEOF_WAD_DIR_NAME     8
#define SIZEOF_WAD_DIR_ENTRY	16

/* Constants for WadfileOpen command */
#define WANTIWAD       1
#define WANTPWAD       2
#define IWADPWAD       3

/* Constants for WadfileCreate command */
#define TYPE_IWAD		WANTIWAD
#define TYPE_PWAD		WANTPWAD

/* WAD file signatures */
#define IWAD_SIGNATURE	"IWAD"
#define PWAD_SIGNATURE	"PWAD"

/* Invalid WAD cached directory entry */
#define INVALID_ENTRY	0xffff

/* Wadfile memory allocation routine pointers */
typedef void * (*WadfileMalloc) (unsigned long size);
typedef void (*WadfileFree) (void * ptr);

/* Our WAD file handler structure */
typedef struct {
	unsigned long flags;
	FILE * wf;
	unsigned long dirLocation;
	unsigned long dirNumEntries;
	unsigned int  entryIndex;
	unsigned long entryLocation;
	unsigned long entrySize;
	unsigned char entryName[SIZEOF_WAD_DIR_NAME+1];
	unsigned char * dirCache;
	unsigned long lumpLocation;
	unsigned long lumpSize;
	unsigned char lumpName[SIZEOF_WAD_DIR_NAME];
	unsigned char * lumpData;
} Wadfile;

/* Wadfile Function Prototypes */
int  WadfileAddLump(Wadfile * wad, unsigned long size, char * name, char * data);
void WadfileClose(Wadfile * wad);
int  WadfileCopyEntry(Wadfile * dest, char * destName,
                     Wadfile * src,  char * srcName);
int  WadfileCopyMap(Wadfile * dest, int destEpisode, int destMap,
                   Wadfile * src,  int srcEpisode,  int srcMap);
int  WadfileCreate(Wadfile * wad, char * filename, int type, int maxEntries);
int  WadfileGetDirInfo(Wadfile * wad, int entryNum);
int  WadfileGetNextDirInfo(Wadfile * wad);
int  WadfileGetPrevDirInfo(Wadfile * wad);
int  WadfileInitialize(WadfileMalloc wfm, WadfileFree wff);
int  WadfileLumpClose(Wadfile * wad);
int  WadfileLumpCopy(Wadfile * dest, char * destName, Wadfile * src);
int  WadfileLumpOpen(Wadfile * wad);
int  WadfileOpen(Wadfile * wad, char * filename, int fileType);
int  WadfileSeek(Wadfile * wad, char * targetName);
int  WadfileSeekMap(Wadfile * wad, int episodeNum, int mapNum);

#endif

