@ECHO OFF
ECHO.
ECHO ALFRED, The Automatic LMP File Recorder and Developer v1.2

REM **************************************************************
REM **      The DOOM Hall of Fame: The Collectors Edition       **
REM **         Automatic LMP File Recorder and Developer        **
REM **  by Michael Houston (mp_hous@pavo.concordia.ca) 03/03/94 **
REM **************************************************************

REM ** SET WADPATH TO BE THE DIRECTORY CONTAINING YOUR WADFILES **
SET WADPATH=LMP\PWAD
SET E=
SET L=
SET S=
SET A1=
SET A2=
SET A3=

IF NOT EXIST DOOM.EXE GOTO DirErr
IF "%1" == "LIST" GOTO showlist
IF "%1" == "list" GOTO showlist
IF "%1" == "" GOTO saidnada
IF "%1" == "r" GOTO record
IF "%1" == "R" GOTO record
IF "%1" == "w" GOTO edit
IF "%1" == "W" GOTO edit
IF "%1" == "t" GOTO Tedit
IF "%1" == "T" GOTO Tedit
IF "%1" == "p" GOTO Play
IF "%1" == "P" GOTO Play

:pwadcheck
IF NOT EXIST lmp\pwad\%1.lmp GOTO Nextstep
IF "%A2%" == "text" SET A1=pwad
IF "%A2%" == "text" GOTO Tedit3
copy lmp\pwad\%1.lmp . > nul
IF NOT EXIST lmp\pwad\%1.txt GOTO wadfile
type lmp\pwad\%1.txt |more
PAUSE
GOTO wadfile

REM ***** CHECK ALL DIRECTORIES ****
:Nextstep
IF NOT "%a2%" == "text" IF NOT "%2" == "" GOTO randoom
IF NOT EXIST lmp\levels\%1.lmp GOTO CheckHall
IF "%A2%" == "text" SET A1=levels
IF "%A2%" == "text" GOTO Tedit3
copy lmp\levels\%1.lmp . > nul
IF NOT EXIST lmp\levels\%1.txt GOTO Later
type lmp\levels\%1.txt |more
PAUSE
GOTO Later

:CheckHall
IF NOT EXIST lmp\hall\%1.lmp GOTO CheckMult
IF "%A2%" == "text" SET A1=hall
IF "%A2%" == "text" GOTO Tedit3
copy lmp\hall\%1.lmp . > nul
IF NOT EXIST lmp\hall\%1.txt GOTO Later
type lmp\hall\%1.txt |more
PAUSE
GOTO Later

:CheckMult
IF NOT EXIST lmp\multiplr\%1.lmp GOTO CheckMisc
IF "%A2%" == "text" SET A1=multiplr
IF "%A2%" == "text" GOTO Tedit3
copy lmp\multiplr\%1.lmp . > nul
IF NOT EXIST lmp\multiplr\%1.txt GOTO Later
type lmp\multiplr\%1.txt |more
PAUSE
GOTO Later

:CheckMisc
IF NOT EXIST lmp\misc\%1.lmp GOTO CheckNite
IF "%A2%" == "text" SET A1=misc
IF "%A2%" == "text" GOTO Tedit3
copy lmp\misc\%1.lmp . > nul
IF NOT EXIST lmp\misc\%1.txt GOTO Later
type lmp\misc\%1.txt |more
PAUSE
GOTO Later

:CheckNite
IF NOT EXIST lmp\nitemare\%1.lmp GOTO randoom
IF "%A2%" == "text" SET A1=nitemare
IF "%A2%" == "text" GOTO Tedit3
copy lmp\nitemare\%1.lmp . > nul
IF NOT EXIST lmp\nitemare\%1.txt GOTO Later
type lmp\nitemare\%1.txt |more
PAUSE
GOTO Later

REM ***** PLAY A RANDOOM FILE *****
:randoom
IF "%A2%" == "text" IF NOT EXIST lmp\randoom\%1.lmp GOTO Tedit2
IF "%A2%" == "text" SET A1=randoom
IF "%A2%" == "text" GOTO Tedit3
IF NOT EXIST lmp\randoom\%1.lmp GOTO NotFound
copy lmp\randoom\%1.lmp . > nul
IF NOT EXIST lmp\randoom\%1.txt GOTO notext
type lmp\randoom\%1.txt |more
PAUSE
IF NOT EXIST lmp\randoom\%1.w GOTO noW1
IF "%2" == "" GOTO NoSeed
SET A3=randoomb
GOTO ranepi

:randoomb
LMP\RANDOOM\RANDOOM -D
ECHO.
IF "%E%" == "4" LMP\RANDOOM\RANDOOM -C%2 -M3 -Wlmp\randoom\%1.w
IF NOT "%E%" == "4" LMP\RANDOOM\RANDOOM -C%2 -M3 -Wlmp\randoom\%1.w -Le%E%M%L%
ECHO.
doom -playdemo %1
del %1.lmp
LMP\RANDOOM\RANDOOM -D
ECHO.
GOTO end

:notext
ECHO.
ECHO ERROR: NO ACCOMPANYING TEXT FILE FOR RANDOOM .LMP
ECHO.
ECHO You must create a text file for the RanDOOM .LMP you specified, since you
ECHO need a record of the seed, episode and level you have used to create the
ECHO RanDOOM file. Create this text file by typing:   LMP t %1
ECHO.
del %1.lmp
GOTO end.

REM ***** DISPLAY ALL .LMP FILES IN THE .LMP DIRECTORIES *****
:showlist
ECHO.
dir lmp\*.lmp /s /p
GOTO end

:NotFound
ECHO. 
ECHO ERROR: .LMP FILE NOT FOUND
ECHO.
ECHO Sorry, I could not find the file %1.lmp in the following directories:
ECHO LMP\HALL, LMP\LEVELS, LMP\MISC, LMP\MULTIPLR, LMP\NITEMARE, LMP\PWAD or 
ECHO LMP\RANDOOM. In order to use this batch file your .LMP must be in one 
ECHO of these directories.
GOTO saidnada

REM ***** HELP SCREEN *****
:saidnada
ECHO.
ECHO Proper usage:          LMP [rwtp] lmpfile [seed, pwadfile]
ECHO No extensions (.lmp, .w, .txt, .wad) required.
ECHO.
ECHO            LMP LIST     Gives directory of the .LMPs available.
ECHO            lmpfile      Either .LMP, .W or .TXT file format.
ECHO            seed         Character seed for RanDOOM files.
ECHO            pwadfile     .WAD pwad file for pwad .LMPs
ECHO Options:   r            Record an .LMP file.
ECHO            w            Create/edit RanDOOM .W file.
ECHO            t            Create/edit .LMP intro .TXT file.
ECHO            p            Play (not record) DOOM with a RanDOOM .W file.
GOTO end

:DirErr
ECHO.
ECHO ERROR: LMP.BAT NOT RUN FROM DOOM DIRECTORY
ECHO.
ECHO In order to run this program you must be in your DOOM directory.
GOTO end

:NoSeed
ECHO.
ECHO ERROR: NO SEED SPECIFIED
ECHO.
ECHO You must specify the proper seed in order for this RanDOOM .LMP
ECHO to work. To see what seed it is, check the text file %1.txt which
ECHO was displayed above.
GOTO saidnada

REM ***** PLAY THE LMP FILE *****
:Later
doom -playdemo %1
del %1.lmp
ECHO.
ECHO lmp.bat execution completed.
ECHO.
GOTO end

REM *****                         *****
REM *****   RECORD AN .LMP FILE   *****
REM *****                         *****

:record
IF "%2" == "" GOTO NoRec
IF "%3" == "" GOTO recrd2
IF EXIST %WADPATH%\%3.wad SET A1=pwad
IF EXIST %WADPATH%\%3.wad GOTO Check
ECHO.
ECHO There was no pwad file named %3.wad in the %WADPATH% directory, 
ECHO so I'm assuming that '%3' is a random seed for a RanDOOM .LMP, O.K.?
CHOICE /C:YN
IF ERRORLEVEL 2 GOTO END
SET A1=randoom
GOTO Check

:recrd2
ECHO.
ECHO Please choose what category you want %2.lmp to be recorded, so I know
ECHO what directory to put it in. NOTE: If you want to record a RANDOOM .LMP,
ECHO include a random seed as your third parameter.

:recrd2B
ECHO.
ECHO 1) LEVELS                         2) HALL OF FAME
ECHO 3) MULTIPLAYER                    4) MISCELLANEOUS
IF "%A2%"=="text" ECHO 5) NIGHTMARE                      6) RANDOOM
IF "%A2%"=="text" ECHO 7) PWAD                           8) QUIT
IF NOT "%A2%"=="text" ECHO 5) NIGHTMARE                      Q) QUIT
CHOICE /C:1234567Q /n
IF ERRORLEVEL 8 GOTO end
IF ERRORLEVEL 1 SET A1=levels
IF ERRORLEVEL 2 SET A1=hall
IF ERRORLEVEL 3 SET A1=multiplr
IF ERRORLEVEL 4 SET A1=misc
IF ERRORLEVEL 5 SET A1=nitemare
IF "%A2%"=="text" IF ERRORLEVEL 6 SET A1=randoom
IF "%A2%"=="text" IF ERRORLEVEL 7 SET A1=pwad
IF NOT "%A2%"=="text" IF ERRORLEVEL 6 GOTO recrd2B
IF NOT "%A2%"=="text" IF ERRORLEVEL 7 GOTO recrd2B

REM ***** CHECK IF FILE EXISTS *****
:Check
IF "%A2%"=="text" GOTO Tedit3
IF NOT EXIST lmp\%A1%\%2.LMP GOTO EPISODE
ECHO.
ECHO WARNING: lmp\%A1%\%2.lmp already exists. Overwrite? (Y/N)
CHOICE /C:YN /n
IF ERRORLEVEL 2 GOTO END
IF ERRORLEVEL 1 GOTO EPISODE

:NoRec
ECHO.
ECHO ERROR: NO .LMP FILE SPECIFIED
ECHO.
ECHO You must include the name of the .LMP file you wish to record.
GOTO saidnada

:EPISODE
ECHO.
ECHO Enter Episode:
ECHO.
ECHO 1) Knee Deep in the Dead          2) The Shores of Hell
ECHO 3) Inferno                        Q) Quit
CHOICE /C:123Q /n
IF ERRORLEVEL 4 GOTO end
IF ERRORLEVEL 1 SET E=1
IF ERRORLEVEL 2 SET E=2
IF ERRORLEVEL 3 SET E=3

:LEVEL
ECHO.
ECHO Enter Level (1-9) or (Q)uit:
CHOICE /C:123456789Q /n
IF ERRORLEVEL 10 GOTO end
IF ERRORLEVEL 1 SET L=1
IF ERRORLEVEL 2 SET L=2
IF ERRORLEVEL 3 SET L=3
IF ERRORLEVEL 4 SET L=4
IF ERRORLEVEL 5 SET L=5
IF ERRORLEVEL 6 SET L=6
IF ERRORLEVEL 7 SET L=7
IF ERRORLEVEL 8 SET L=8
IF ERRORLEVEL 9 SET L=9

:SKILL
IF "%A1%"=="nitemare" SET S=5
IF "%A1%"=="nitemare" GOTO REC2
ECHO.
ECHO Enter Skill:
ECHO.
ECHO 1) I'm too young to die           2) Hey, not too rough
ECHO 3) Hurt me plenty                 4) Ultra Violence
ECHO 5) NIGHTMARE!                     Q) Quit
CHOICE /C:12345Q /n
IF ERRORLEVEL 6 GOTO end
IF ERRORLEVEL 1 SET S=1
IF ERRORLEVEL 2 SET S=2
IF ERRORLEVEL 3 SET S=3
IF ERRORLEVEL 4 SET S=4
IF ERRORLEVEL 5 SET S=5

REM ***** ACTUAL RECORDING OF THE .LMP FILE *****
:REC2
IF "%A1%" == "randoom" GOTO rand2
IF "%A1%" == "pwad" GOTO recwad
doom -devparm -warp %e% %l% -skill %s% -record %2
copy %2.lmp lmp\%A1% > nul
del %2.lmp
ECHO.
ECHO lmp.bat execution completed. It has been put in the lmp\%A1%
ECHO directory.
ECHO.
GOTO end

REM ***** RECORDING OF A RANDOOM .LMP FILE *****
:rand2
IF "%3" == "" GOTO NoRecSeed
IF NOT EXIST lmp\randoom\%2.w GOTO noW2
ECHO.
ECHO Do you want RanDOOM to: 
ECHO                           1) change ALL the levels
ECHO                           2) change only the level to be recorded
ECHO                           Q) Quit
ECHO.
ECHO NOTE: (1) and (2) will give different randoom setups for the same 
ECHO       level, even if the same seed is used.
ECHO.
CHOICE /C:12Q /n Please select (1, 2 or Q): 
IF ERRORLEVEL 3 GOTO end
IF ERRORLEVEL 1 SET A3=1
IF ERRORLEVEL 2 SET A3=2
ECHO.
LMP\RANDOOM\RANDOOM -D
ECHO.
IF "%A3%" == "1" LMP\RANDOOM\RANDOOM -C%3 -M3 -Wlmp\randoom\%2.w
IF "%A3%" == "2" LMP\RANDOOM\RANDOOM -C%3 -M3 -Wlmp\randoom\%2.w -Le%e%M%L%
ECHO.
doom -devparm -warp %e% %l% -skill %s% -record %2
copy %2.lmp lmp\%A1% > nul
del %2.lmp
LMP\RANDOOM\RANDOOM -D
ECHO.
ECHO.
ECHO Remember: You played Episode %e%, Level %l%, with randoom seed '%3'.
ECHO Would you like to create an introductory text file to store this
ECHO information? (Y/N): 
CHOICE /C:YN /n
IF ERRORLEVEL 2 GOTO end
IF NOT EXIST lmp\randoom\%2.txt copy lmp\template.txt lmp\randoom\%2.txt > nul
edit lmp\randoom\%2.txt
GOTO end

:NoRecSeed
ECHO.
ECHO ERROR: NO RANDOOM SEED SPECIFIED
ECHO.
ECHO You MUST include a character seed in order to record a RanDOOM lmp,
ECHO otherwise you will not be able to re-load the same items when viewing
ECHO it. 
GOTO saidnada

:noW1
ECHO.
ECHO ERROR: RANDOOM .W WEIGHT FILE NOT FOUND
ECHO.
ECHO I was unable to find the file %1.w in the LMP\RANDOOM directory.
ECHO In order for you to run a RanDOOM .LMP file, you must have created
ECHO this file.
del %1.lmp
GOTO saidnada

:noW2
ECHO.
ECHO ERROR: RANDOOM .W WEIGHT FILE NOT FOUND
ECHO.
ECHO I was unable to find the file %2.w in the LMP\RANDOOM directory.
ECHO In order for you to record a RanDOOM .LMP file, you must have 
ECHO 1) LMP\RANDOOM\%2.w, the RanDOOM weight file. 
ECHO 2) The character seed.
GOTO saidnada

REM ***** EDITING OF A RANDOOM .W WEIGHT FILE *****
:edit
IF "%2" == "" GOTO noedit
IF NOT EXIST lmp\randoom\%2.w copy lmp\template.w lmp\randoom\%2.w > nul
edit lmp\randoom\%2.w
GOTO end

:Noedit
ECHO.
ECHO ERROR: NO .W FILE SPECIFIED
ECHO.
ECHO You must include the name of the .w file you wish to edit.
GOTO saidnada

REM ***** EDITING OF A .LMP INTRODUCTORY TEXT FILE *****
:Tedit
IF "%2" == "" GOTO noedtxt
ECHO.
SET A2=text
SHIFT
GOTO Pwadcheck

:Tedit2
ECHO.
ECHO WARNING: There is no accompanying .LMP file for %1.txt. Continue? (Y/N)
CHOICE /C:YN /n
IF ERRORLEVEL 2 GOTO END
IF ERRORLEVEL 1 GOTO recrd2B

:Tedit3
IF NOT EXIST lmp\%A1%\%1.txt copy lmp\template.txt lmp\%A1%\%1.txt > nul
edit lmp\%A1%\%1.txt
GOTO end

:noedtxt
ECHO.
ECHO ERROR: NO .TXT FILE SPECIFIED
ECHO.
ECHO You must include the name of the .TXT file you wish to edit.
GOTO saidnada

REM ***** PLAY DOOM WITH A .W WEIGHT FILE *****
:Play
IF NOT EXIST lmp\randoom\%2.w GOTO NoPlay
ECHO.
ECHO Setting up DOOM to play with RanDOOM weight file %2.w,
IF NOT "%3" == "" ECHO With character seed '%3'.
IF "%3" == "" ECHO Without a character seed.

:ranepi
ECHO.
ECHO Enter Episode to change:
ECHO.
ECHO 1) Knee Deep in the Dead          2) The Shores of Hell
ECHO 3) Inferno                        4) All Episodes
ECHO Q) Quit
CHOICE /C:1234Q /n
IF ERRORLEVEL 5 GOTO end
IF ERRORLEVEL 1 SET E=1
IF ERRORLEVEL 2 SET E=2
IF ERRORLEVEL 3 SET E=3
IF ERRORLEVEL 4 SET E=4
IF ERRORLEVEL 4 GOTO Play2

:ranlev
ECHO.
ECHO Enter Level (1-9) to change or (Q)uit:
CHOICE /C:123456789Q /n
IF ERRORLEVEL 10 GOTO end
IF ERRORLEVEL 1 SET L=1
IF ERRORLEVEL 2 SET L=2
IF ERRORLEVEL 3 SET L=3
IF ERRORLEVEL 4 SET L=4
IF ERRORLEVEL 5 SET L=5
IF ERRORLEVEL 6 SET L=6
IF ERRORLEVEL 7 SET L=7
IF ERRORLEVEL 8 SET L=8
IF ERRORLEVEL 9 SET L=9

:Play2
IF "%A3%" == "randoomb" GOTO randoomb
LMP\RANDOOM\RANDOOM -D
ECHO.
IF NOT "%E%" == "4" IF NOT "%3" == "" LMP\RANDOOM\RANDOOM -C%3 -M3 -Wlmp\randoom\%2.w -Le%e%M%L%
IF NOT "%E%" == "4" IF "%3" == "" LMP\RANDOOM\RANDOOM -M3 -Wlmp\randoom\%2.w -Le%e%M%L%
IF "%E%" == "4" IF NOT "%3" == "" LMP\RANDOOM\RANDOOM -C%3 -M3 -Wlmp\randoom\%2.w 
IF "%E%" == "4" IF "%3" == "" LMP\RANDOOM\RANDOOM -M3 -Wlmp\randoom\%2.w
ECHO.
IF "%E%" == "4" doom
IF NOT "%E%" == "4" doom -devparm -warp %e% %l% 
LMP\RANDOOM\RANDOOM -D
ECHO.
GOTO end

:NoPlay
ECHO.
ECHO ERROR: NO .W FILE SPECIFIED
ECHO.
ECHO You must include the name of the .w file you wish to play.
GOTO saidnada

REM ***** PLAY FROM A PWAD FILE *****
:wadfile
SET WADNAME=%2
IF "%2" == "" SET WADNAME=%1
IF NOT EXIST %WADPATH%\%WADNAME%.wad GOTO PWNotFound
doom -playdemo %1 -file %WADPATH%\%WADNAME%.wad 
del %1.lmp
GOTO end

:PWNotFound
ECHO. 
ECHO ERROR: PWAD FILE NOT FOUND
ECHO.
ECHO Sorry, I could not find the file %2.wad in the %WADFILE% Directory.
ECHO In order to play a PWAD .LMP you must have %1.lmp in the LMP\PWAD
ECHO directory and %2.wad in the %WADFILE% directory.
GOTO saidnada

REM ***** RECORD A WAD .LMP *****
:recwad
doom -devparm -file  %WADPATH%\%3.wad -warp %e% %l% -skill %s% -record %2
copy %2.lmp lmp\pwad > nul
del %2.lmp
ECHO.
ECHO Remember: You played Episode %e%, Level %l%, with Pwad %3.wad.
ECHO Would you like to create an introductory text file to store this
ECHO information? (Y/N): 
CHOICE /C:YN /n
IF ERRORLEVEL 2 GOTO end
IF NOT EXIST lmp\pwad\%2.txt copy lmp\template.txt lmp\pwad\%2.txt > nul
edit lmp\pwad\%2.txt
GOTO end

REM ***** CLEAR VARIABLES AND END *****
:end
ECHO.
SET E=
SET L=
SET S=
SET A1=
SET A2=
SET A3=
SET WADPATH=
SET WADNAME=
