# This awk file will convert a family group record (that has been 
# pre-processed with paf.sed (placing field separators with ":")
# S Valentine, 7.6.89

BEGIN {  # set field separator to ":" vice the default space
    FS =":" 
    }

$1 ~ /FAMILY/ {  # get the mirn for the individual
    mirn = $2+0 }
$1 ~ /HUSBAND/ { # get the husband's name, rin
    husband = $2
    hrin = $3+0  # force to numeric
    sex = "M" }
$1 ~ /BORN/ { # get the husband's birthdate and place of birth
    birthdate = $2
    birthplace = $4 }
$1 ~ /MARR/ { # get the husband's wedding date and place of wedding
    marrdate = $2
    marrplace = $4 }
$1 ~ /DIED/ { # get the husband's death date and place of death
    deathdate = $2
    deathplace = $4 }
$1 ~ /FATHER/ && sex ~ /M/ {  # get husband's parent's info
    father = father_rin = mother = mother_rin = parent_mrin = ""
    $3 ~ /MOTHER/ ? father = "" : father = $2
    $3 ~ /MOTHER/ ? father_rin = "" : father_rin = $3+0
    if ($3 ~ /MOTHER/ && $6 ~ /PARENT/) {
        mother = $4
        mother_rin = $5+0 }
    if ($4 ~ /MOTHER/) {
        mother = $5
        mother_rin = $6+0 }
    $7 ~ /PARENT/ ? parent_mrin = $8+0 : parent_mrin = $7+0
    }
$1 ~ /WIFE/ { # get the Wife's name, rin - print the husband's record
    $2 == "" ? wife = "UNKNOWN" : wife = $2
    wrin = $3+0   # force to numberic
    sex = "F" 
    printf("\"%s\",\"M\",%d,\"%s\",\"%s\",\"%s\",%d,\"%s\"",
          husband, hrin, birthdate, birthplace, wife, wrin, marrdate)
    printf(",\"%s\",%d,\"%s\",\"%s\",\"%s\",%d,",
          marrplace, mrin, deathdate, deathplace, father, father_rin)
    printf("\"%s\",%d,%d", 
          mother, mother_rin, parent_mrin) 
    printf ("\n") }
$1 ~ /BORN/ { # get the wife's birthdate and place of birth
    birthdate = $2
    birthplace = $4 }
$1 ~ /DIED/ { # get the wife's death date and place of death
    deathdate = $2
    deathplace = $4 }
$1 ~ /FATHER/ && sex ~ /F/ { # get wife's parent's info & print the record
    father = father_rin = mother = mother_rin = parent_mrin = ""
    $3 ~ /MOTHER/ ? father = "" : father = $2
    $3 ~ /MOTHER/ ? father_rin = "" : father_rin = $3+0
    if ($3 ~ /MOTHER/ && $6 ~ /PARENT/) {
        mother = $4
        mother_rin = $5+0 }
    if ($4 ~ /MOTHER/) {
        mother = $5
        mother_rin = $6+0 }
    $7 ~ /PARENT/ ? parent_mrin = $8+0 : parent_mrin = $7+0
    printf("\"%s\",\"F\",%d,\"%s\",\"%s\",\"%s\",%d,\"%s\"",
        wife, wrin, birthdate, birthplace, husband, hrin, marrdate)
    printf(",\"%s\",%d,\"%s\",\"%s\",\"%s\",%d,",
        marrplace, mrin, deathdate, deathplace, father, father_rin)
    printf("\"%s\",%d,%d", 
        mother, mother_rin, parent_mrin) 
    printf ("\n") }


                                  