# Extract children data from FGRs
# This awk file will convert a family group record (that has been 
# pre-processed with paf1.sed (placing field separators with ":")
# to delimited format.  Note:  Still needs to be processed by
# cleanup.sed
# S Valentine, 7.7.89

BEGIN {  # set field separator to ":" vice the default space
    FS =":" }
$1 ~ /FAMILY/ {  # get the mrin for the individual
    mrin = $2+0 }
$1 ~ /HUSBAND/ { # get the husband's name, rin
    husband = $2
    hrin = $3+0 }
$1 ~ /WIFE/ { # get the Wife's name, rin 
    $2 == "" ? wife = "UNKNOWN" : wife = $2
    wrin = $3+0 }
$2 ~ /NAME/ { 
    child = $3 
    child_rin = $4+0 
    $6 != "" ? child_spouse = "DELETE" : child_spouse = "" 
    # note what I did above.  If the child's spouse is listed,
    # replace the name with DELETE.  Cleanup.sed will remove
    # those lines with DELETE
    # if you wish the name of the spouse, use the following line
    # child_spouse = $6  # remove the "#" remark symbol
    spouse_rin = $7+0 
    child_mrin = $9+0 } 
$1 ~ /BORN/ { # get the child's birthdate and place of birth
    birthdate = $2
    birthplace = $4 }
$2 ~ /CHR/ { # get the child's sex
    sex = $1 }
$1 ~ /MARR/ { # get the child's wedding date and place of wedding
    marrdate = $2
    marrplace = $4 }
$1 ~ /DIED/ { # print the record
    deathdate = $2
    deathplace = $4 
    printf("\"%s\",\"%s\",%d,\"%s\",\"%s\",\"%s\",",
        child, sex, child_rin, birthdate, birthplace, child_spouse)
    printf("%d,\"\",\"\",%d,\"%s\",\"%s\",\"%s\",%d,\"%s\"",
        spouse_rin, child_mrin, deathdate, deathplace, husband, hrin, wife)
    printf(",%d,%d", 
        wrin, mrin) 
    printf ("\n") }


