PROGRAM FTEtc_To_GED;
USES Crt,Dos,StrngLib,IOLib,TimeLib;
CONST
  MaxChildren =  12;
  MaxFamilies = 200;
TYPE
  TFields = (OwnID,Sex,FatherID,MotherID,SpouseID,
             MarriageCount,MarriageID,
             MarriageLID,BirthLID,DeathLID,
             MarriageDMY,BirthDMY,DeathDMY,OwnName,Spare,Last);
  TFamily = RECORD
             PopID,MomID : Word;
             Date        : String[10];
             Children    : Byte;
             ChildID     : Array[1..MaxChildren] of Word;
            END;
CONST
  FieldStart : Array[TFields] of Byte =
               (1,4,5,8,11,14,15,18,22,26,30,39,48,57,83,87);
VAR
  DTime   : TDateTime;
  Twirl   : Byte;
  InFile,
  OutFile : String;
  InText  : String;
  InUnit,
  OutUnit : Text;
  ID,i,j  : Word;
  nFams   : Word;
  Family  : Array[1..MaxFamilies] of TFamily;

  procedure Rotate;
  const
    Chars : Array[0..3] of Char = '-\|/';
  begin
    Twirl:=Succ(Twirl) mod 3;
    Write(Chars[Twirl]);
    GotoXY(Pred(WhereX),WhereY);
  end;
  function GetField(AField:TFields): String;
  begin
    GetField:=Copy(InText,FieldStart[AField],
                   FieldStart[Succ(AField)]-FieldStart[AField]);
  end;
  function GetNumber(AField: TFields): Integer;
  var
    hold,err : Integer;
  begin
    Val(GetField(AField),hold,err);
    GetNumber:=hold;
  end;
  function GetName: String;
  var
    i    : Byte;
    hold : String;
  begin
    hold:=TrimStr(GetField(OwnName));
    i:=Length(hold);
    Repeat
      Dec(i);
    Until hold[i]=' ';
    GetName:=Copy(hold,1,i)+'/'+Copy(hold,Succ(i),Length(hold)-i)+'/';
  end;
  function GetSex: String;
  begin
    If GetField(Sex)='1' then GetSex:='M'
                         else GetSex:='F';
  end;
  function GetDate(AField: TFields): String;
  var
    i    : Byte;
    hold : String;
  begin
    GetDate:='';
    If not (AField in [MarriageDMY,BirthDMY,DeathDMY]) then Exit;
    hold:=GetField(AField);
    hold:=Copy(hold,1,2)+' '+Copy(hold,3,3)+' '+Copy(hold,6,4);
    i:=1;
  { While (i<=Length(hold)) and (hold[i] in ['?',' ']) do Inc(i); }
    GetDate:=Copy(hold,i,Length(hold)-Pred(i));
  end;

BEGIN
  InFile:='';
  If ParamCount=1 then
  begin
    OutFile:=UCase(ParamStr(1));
    InFile:=OutFile+'.DB3';
    OutFile:=OutFile+'.GED';
  end;
  Writeln('Ft-Etc 3.0 to GED conversion program by Kjell Eikland');
  If (ParamCount<>1) or not FileExist(InFile) then
  begin
    Writeln('Syntax is: GED <FT-Etc.DataFile>');
    Exit;
  end;
  Writeln('Using data from ',InFile);

  Assign(InUnit,InFile);

  Reset(InUnit);
  Twirl:=0;
  Write('Scanning for families ... ');
  nFams:=0;
  While not EOF(InUnit) do
  begin
    Readln(InUnit,InText);
    Rotate;
    If (GetSex='M') and (GetNumber(SpouseID)>0) then
    begin
      Inc(nFams);
      With Family[nFams] do
      begin
        PopID:=GetNumber(OwnID);
        MomID:=GetNumber(SpouseID);
        Date:=GetDate(MarriageDMY);
        Children:=0;
      end;
    end;
  end;

  Reset(InUnit);
  Twirl:=0;
  Writeln;
  Write('Scanning for children ... ');
  While not EOF(InUnit) do
  begin
    Rotate;
    Readln(InUnit,InText);
    ID:=GetNumber(FatherID);
    If GetNumber(FatherID)>0 then
    begin
      j:=GetNumber(MotherID);
      i:=1;
      While (Family[i].PopID<>ID) and
            (Family[i].MomID<>j) do Inc(i);
      With Family[i] do
      begin
        Inc(Children);    
        ChildID[Children]:=GetNumber(OwnID);
      end;
    end;
  end;

  Reset(InUnit);
  Twirl:=0;
  Now(DTime);
  Writeln;
  Write('Writing individuals ... ');
  If FileExist(OutFile) then FileErase(OutFile);
  Assign(OutUnit,OutFile);
  Rewrite(OutUnit);
  Writeln(OutUnit,'0 HEAD');
  Writeln(OutUnit,'1 SOUR FT-ETC.');
  Writeln(OutUnit,'2 VERS 3.0');
  Writeln(OutUnit,'1 DEST PAF');
  Writeln(OutUnit,'1 DATE '+MakePadStr(DTime.Day,2,'0')+' '+
                            UCase(Copy(MonthName(DTime.Month,'E'),1,3))+' '+
                            MakePadStr(DTime.Year,4,'0'));
  Writeln(OutUnit,'1 CHAR IBMPC');
  Writeln(OutUnit,'1 FILE '+OutFile);
  While not EOF(InUnit) do
  begin
    Rotate;
    Readln(InUnit,InText);
    If GetNumber(MarriageCount)<2 then
    begin
      ID:=GetNumber(OwnID);
      Writeln(OutUnit,'0 @I'+MakeStr(ID,0)+'@ INDI');
      Writeln(OutUnit,'1 NAME '+GetName);
      Writeln(OutUnit,'1 SEX '+GetSex);
      If GetDate(BirthDMY)<>'' then
      begin
        Writeln(OutUnit,'1 BIRT');
        Writeln(OutUnit,'2 DATE '+GetDate(BirthDMY));
      end;
      If GetDate(DeathDMY)<>'' then
      begin
        Writeln(OutUnit,'1 DEAT');
        Writeln(OutUnit,'2 DATE '+GetDate(DeathDMY));
      end;
      If GetNumber(MarriageCount)>0 then
      begin
        If GetSex='M' then j:=1 else j:=0;
        i:=0;
        Repeat
          Inc(i);
          While (i<=nFams) and
                ((j=1) and (Family[i].PopID<>ID)) or
                ((j=0) and (Family[i].MomID<>ID)) do Inc(i);
          If i<=nFams then
            Writeln(OutUnit,'1 FAMS @F'+MakeStr(i,0)+'@');   { Own family }
        Until i>nFams;
      end;
      ID:=GetNumber(FatherID);
      If ID>0 then
      begin
        i:=1;
        While (i<=nFams) and (Family[i].PopID<>ID) do Inc(i);
        If i<=nFams then
          Writeln(OutUnit,'1 FAMC @F'+MakeStr(i,0)+'@');   { Parent's family }
      end;
    end;
  end;

  Twirl:=0;
  Writeln;
  Write('Writing families ... ');
  For i:=1 to nFams do With Family[i] do
  begin
    Rotate;
    Writeln(OutUnit,'0 @F'+MakeStr(i,0)+'@ FAM');
    Writeln(OutUnit,'1 HUSB @I'+MakeStr(PopID,0)+'@');
    Writeln(OutUnit,'1 WIFE @I'+MakeStr(MomID,0)+'@');

    For j:=1 to Children do
      Writeln(OutUnit,'1 CHIL @I'+MakeStr(ChildID[j],0)+'@');

    If Date<>'' then
    begin
      Writeln(OutUnit,'1 MARR');
      Writeln(OutUnit,'2 DATE '+Date);
    end;
  end;

  Writeln(OutUnit,'0 TRLR');

  Close(InUnit);
  Close(OutUnit);

  Writeln;
  Write('Done - Data saved in ',OutFile);

END.
