@echo off
rem ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
rem
rem     Geos 2.01 Patch Assembly Batch file
rem
rem     Purpose: Extracts downloaded self-extracting files into their
rem              original forms and copies files to floppy disks.
rem
rem     Copyright 1994, Geoworks
rem
rem ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

rem     Check user entered parameters
if %1.==. goto instructions
if %1.==a:. goto backup
if %1.==A:. goto backup
if %1.==b:. goto backup
if %1.==B:. goto backup
if %1.==HD. goto hd_install
if %1.==Hd. goto hd_install
if %1.==hD. goto hd_install
if %1.==hd. goto hd_install
goto wrong_parameter

:instructions
cls
echo Ŀ
echo           G E O S   P A T C H    I N S T A L L   A S S E M B L Y           
echo 
echo Ŀ
echo  This program can extract the downloaded files into their original form    
echo  and copy those files to floppy disks or extract them to the hard drive.   
echo  We *highly* recommend using floppy diskettes so you have a backup of the  
echo  program files. Geos 2.01 patch can be installed from floppy diskettes as  
echo  many times as you wish.                                                   
echo                                                                            
echo  TO PROCEED WITH THE INSTALL PROCESS:                                      
echo  It will be necessary to restart this program with an addional parameter.  
echo  Next time at the DOS prompt, type ASSEMBLE and follow it with the letter  
echo  of the floppy drive to which you wish to copy.   For example, to          
echo  copy to drive B, you would type:   ASSEMBLE B:                            
echo                                                                            
echo  YOU WILL NEED FOUR (4) 720k disks (or you may use higher capacity disks)  
echo  for this program to copy the necessary file onto.  Those disks must be    
echo  empty, formatted and we run DOS's Label command (each disk must have a    
echo  label for the install utility i.e. LABEL B:ENSEMBLE_n (n = 1 - 4)).       
echo                                                                            
echo  ***NOTE***                                                                
echo  TO INSTALL FROM YOUR HARD DRIVE:    type   ASSEMBLE HD                    
echo 
pause
goto end

:backup
cls
echo Ŀ
echo           G E O S   P A T C H    I N S T A L L   A S S E M B L Y           
echo 
echo Ŀ
echo  FLOPPY BACKUP INSTRUCTIONS:                                               
echo                                                                            
echo  You will need 4 blank, formatted 720K, 1.44m (3.5") or 1.2Mb (5.25")      
echo  disks to copy the necessary files.                                        
echo                                                                            
echo  Place the 1st disk in drive %1 and . . .                                  
echo 
pause
set step=001
geos21p1 %1
goto errortest
:001
Label %1ENSEMBLE_1
echo.
echo   Label the diskette outside as: Geos2.01 Patch -- Disk 1
echo   Place the 2nd disk in drive %1 and . . .
pause
set step=002
geos21p2 %1
goto errortest
:002
Label %1ENSEMBLE_2
echo.
echo   Label the diskette outside as: Geos2.01 Patch -- Disk 2
echo   Place the 3rd disk in drive %1 and . . .
pause
set step=003
geos21p3 %1
goto errortest
:003
Label %1ENSEMBLE_3
echo.
echo   Label the diskette outside as: Geos2.01 Patch -- Disk 3
echo   Place the 4th disk in drive %1 and . . .
pause
set step=004
geos21p4 %1
goto errortest
:004
Label %1ENSEMBLE_4
set step=005
echo.
echo   Label the diskette outside as: Geos2.01 Patch -- Disk 4
echo   Take the last disk out of drive %1 and . . .
pause
goto delete_temp_files
:005
set step=
echo.
goto run_install

:hd_install
cls
echo Ŀ
echo           G E O S   P A T C H    I N S T A L L   A S S E M B L Y           
echo 
echo.
echo Ŀ
echo   Extracting files to current directory. This may take a few minutes       
echo   on slower machines...                                                    
echo 
echo.
set step=011
geos21p1
goto errortest
:011
set step=012
geos21p2
goto errortest
:012
set step=013
geos21p3
goto errortest
:013
set step=014
geos21p4
goto errortest
:014
set step=015
goto delete_temp_files
:015
set step=
echo.
install
goto END

:errortest
if errorlevel 2 goto err_msg
if errorlevel 1 goto err_msg
goto %step%

:wrong_parameter
cls
echo Ŀ
echo           G E O S   P A T C H    I N S T A L L   A S S E M B L Y           
echo 
echo Ŀ
echo  The parameter you used, %1, is not A: or B:. This batch file will only    
echo  copy files to floppy drives A: or B:.  If your floppy drive has another   
echo  drive letter, or if you wish to back the files up to a hard drive, please 
echo  do so after you exit this batch file.                                     
echo                                                                            
echo  The following files are self-extracting:                                  
echo                                                                            
echo  GEOS21P1.EXE                                                              
echo  GEOS21P2.EXE                                                              
echo  GEOS21P3.EXE                                                              
echo  GEOS21P4.EXE                                                              
echo                                                                            
echo  Those files will need to extracted to their own individual floppy disks   
echo  before the actual installation can be accomplished.  Four 720k (or bigger)
echo  floppy disks are needed labeled disk 1 - disk 5.                          
echo 
pause
cls
echo Ŀ
echo           G E O S   P A T C H    I N S T A L L   A S S E M B L Y           
echo 
echo Ŀ
echo                                                          Continued:        
echo  Put disk 1 into its floppy drive and from the directory with the self-    
echo  extracting files type GEOS21P1 [drive]: ("drive" is the letter).  Then    
echo  do the same with disk 2 and GEOS21P2, and etc.                            
echo                                                                            
echo  For Example:   GEOS21P3 A:                                                
echo                                                                            
echo  When you are actully ready to install the Geos21 patch to your hard disk, 
echo  put disk 1 back into its floppy drive and type [drive]:INSTALL            
echo                                                                            
echo  For Example:   A:INSTALL                                                  
echo 
goto end

:run_install
echo.
echo   Re-insert disk 1 into drive %1 . . .
echo.
pause
echo.
echo   Running the install program . . .
%1INSTALL
goto END

:delete_temp_files
call TEMPDEL
goto %step%

:err_msg
echo.
echo.
echo The file extraction process had errors in the above named file.
echo You may need to download the file again.
echo.
echo.

:end
echo Ŀ
echo  Thank you for downloading Geos2.01 Patch.  Enjoy this latest Geos Ensemble
echo  software and have a very good time!                                       
echo 
echo.
