// CHARS.INC R1.02
// Characters for POV-RAY V1.0
// An including file.
// by Ken Maeno 1992-93
//
// This file includes 26 upper-case characters defined as objects.
// The size of most characters is 4 * 5 * 1. 'A','M', and 'V' have
// 5 * 5 * 1, and 'W' has 6 * 5 * 1. The center of the bottom side of 
// a character face is set to the origin, so please translate a character
// appropriately before rotating it about the x or z axes.
// 	Usage:
// 	object{  // character A
// 		char_A
//		texture{ color Red }
//	}
//
#declare char_A = object { union { 
    intersection{
        plane{ <0 1 0> 0 inverse }
        plane{ <0 1 0> 5 }
        plane{ <1 0 0> 0 rotate<0 0 -21.8014> inverse }
        plane{ <1 0 0> 1 rotate<0 0 -21.8014> }
        plane{ <0 0 1> 0 inverse }
        plane{ <0 0 1> 1 }
        translate<-2.5 0 0>
    }
    intersection{
        plane{ <0 1 0> 0 inverse }
        plane{ <0 1 0> 5 }
        plane{ <1 0 0> 0 rotate<0 0 21.8014> inverse }
        plane{ <1 0 0> 1 rotate<0 0 21.8014> }
        plane{ <0 0 1> 0 inverse }
        plane{ <0 0 1> 1 }
        translate<1.5 0 0>
    }
    box{ <-1.5 1 0> <1.5 2 1> }
  }
  bounded_by{ box { <-2.5 0 0> <2.5 5 1> } }
}
#declare char_B = object { union {
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<0.5 3.5 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<0.5 1.5 0>
    }
    box{ <-1 4 0> <0.5 5 1> }
    box{ <-1 2 0> <0.5 3 1> }
    box{ <-1 0 0> <0.5 1 1> }
    box{ <-2 0 0> <-1 5 1 > }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_C = object { union {
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 3 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        rotate<0 0 180>
        translate<0 2 0>
    }
    box{ <-2 2 0> <-1 3 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_D = object { union {
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2.5 2.5 1>
            }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<1.5 1.5 1>
        }
        translate<-0.5 2.5 0>
    }
    box{ <-1 4 0> <-0.5 5 1> }
    box{ <-1 0 0> <-0.5 1 1> }
    box{ <-2 0 0> <-1   5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_E = object { union {
	box{ <-2 0 0> <-1 5 1> }
	box{ <-1 0 0> < 2 1 1> }
	box{ <-1 2 0> <1.5 3 1> }
	box{ <-1 4 0> < 2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_F = object{ union {
    box{ <-2 0 0> <-1 5 1> }
    box{ <-1 2 0> <1.5 3 1> }
    box{ <-1 4 0> <2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_G = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 3 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        rotate<0 0 180>
        translate<0 2 0>
    }
    box{ <-2  2  0> <-1  3  1> }
    box{ < 0 1.5 0> < 2 2.3 1> }
    box{ <1.2 0  0> < 2  2  1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_H = object{ union{
    box{ <-2 0 0> <-1 5 1> }
    box{ < 1 0 0> < 2 5 1> }
    box{ <-1 2 0> < 1 3 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_I = object{
    box{ <-0.5 0 0> <0.5 5 1> }
    bounded_by{ box { <-0.5 0 0> <0.5 5 1> } }
}
#declare char_J = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 2 0>
    }
    box{ <1 2 0> <2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_K = object { union {
	intersection{
		box{ <0 -2 0> <0.9 5 1> rotate <0 0 45> }
		plane{ <1 0 0>  -2 inverse }
		plane{ <0 -1 0> 0 }
		translate <0.7272 0 0>
	}
	intersection{
		box{ <0 -5 0> <0.9 2 1> rotate <0 0 -45> }
		plane{ <1 0 0>  -2 inverse }
		plane{ <0 1 0> 0 }
		translate <0.7272 5 0>
	}
	box{ <-2 0 0> <-1 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_L = object { union {
	box{ <-2 1 0> <-1 5 1> }
	box{ <-2 0 0> <2 1 1>  }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_M = object { union {
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 26.5651> inverse }
		plane{ <1 0 0> 0 rotate <0 0 26.5651> translate <1 0 0> }
		plane{ <0 1 0> 4 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 1 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -26.5651> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -26.5651> translate <1 0 0> }
		plane{ <0 1 0> 4 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 1 0>
	}
	box{ <-2.5 0 0> <-1.5 5 1> }
	box{ <1.5 0 0> <2.5 5 1> }
  }
  bounded_by{ box { <-2.5 0 0> <2.5 5 1> } }
}
#declare char_N = object { union {
	intersection{
	    box{ <0 0 0> <1 6 1> rotate <0 0 32.5031> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <1 0 0> -3 inverse }
		plane{ <1 0 0> 1 }
		translate <1 0 0>
	}
	box{ <-2 0 0> <-1 5 1> }
	box{ <1 0 0> <2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_O = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 3 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        rotate<0 0 180>
        translate<0 2 0>
    }
    box{ <-2 2 0> <-1 3 1> }
    box{ < 1 2 0> < 2 3 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_P = object { union {
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<0.5 3.5 0>
    }
    box{ <-1 4 0> <0.5 5 1> }
    box{ <-1 2 0> <0.5 3 1> }
    box{ <-2 0 0> <-1 5 1 > }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_Q = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 3 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        rotate<0 0 180>
        translate<0 2 0>
    }
    box{ <-2 2 0> <-1 3 1> }
    box{ < 1 2 0> < 2 3 1> }
    box{ < 0 0 0> < 1 2.2 1> rotate <0 0 45> translate <1.29289 0 0> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_R = object { union {
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<0.5 3.5 0>
    }
	intersection{
		box{ <0 -2 0> <1 5 1> rotate <0 0 36.8699> }
		plane{ <0 1 0>  2}
		plane{ <0 -1 0> 0 }
    	translate <0.75 0 0>
	}
    box{ <-1 4 0> <0.5 5 1> }
    box{ <-1 2 0> <0.5 3 1> }
    box{ <-2 0 0> <-1 5 1 > }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_S = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<0.5 3.5 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ <0 -1 0> 0 }
            plane{ <-1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        rotate<0 0 180>
        translate<-0.5 1.5 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ < 1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        translate<-0.5 3.5 0>
    }
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<1.5 1.5 1>
            }
            plane{ < 1 0 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0  1> 1 }
        }
        quadric{
            Cylinder_Z
            scale<0.5 0.5 1>
        }
        rotate<0 0 180>
        translate<0.5 1.5 0>
    }
    box{ <-0.5 4 0> <0.5 5 1> }
    box{ <-0.5 2 0> <0.5 3 1> }
    box{ <-0.5 0 0> <0.5 1 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_T = object{ union{
    box{ <-0.5 0 0> <0.5 4 1> }
    box{ <-2   4 0> <  2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_U = object{ union{
    difference{
        intersection{
            quadric{
                Cylinder_Z
                scale<2 2 1>
            }
            plane{ <0 1 0> 0 }
            plane{ <0 0 -1> 0 }
            plane{ <0 0 1 > 1 }
        }
        quadric{
            Cylinder_Z
            scale<1 1 1>
        }
        translate<0 2 0>
    }
    box{ <-2 2 0> <-1 5 1> }
    box{ < 1 2 0> < 2 5 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_V = object { union {
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 21.8014> inverse }
		plane{ <1 0 0> 0 rotate <0 0 21.8014> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 0 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -21.8014> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -21.8014> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 0 0>
	}
  }
  bounded_by{ box { <-2.5 0 0> <2.5 5 1> } }
}
#declare char_W = object { union {
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 11.3099> inverse }
		plane{ <1 0 0> 0 rotate <0 0 11.3099> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-2 0 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -16.6992> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -16.6992> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-2 0 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 16.6992> inverse }
		plane{ <1 0 0> 0 rotate <0 0 16.6992> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <1 0 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -11.3099> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -11.3099> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <1 0 0>
	}
  }
  bounded_by{ box { <-3 0 0> <3 5 1> } }
}
#declare char_X = object { union {
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 30.9638> inverse }
		plane{ <1 0 0> 0 rotate <0 0 30.9638> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <1 0 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -30.9638> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -30.9638> translate <1 0 0> }
		plane{ <0 1 0> 5 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-2 0 0>
	}
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_Y = object { union {
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 26.5651> inverse }
		plane{ <1 0 0> 0 rotate <0 0 26.5651> translate <1 0 0> }
		plane{ <0 1 0> 3 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 2 0>
	}
	intersection{
		plane{ <1 0 0> 0 rotate <0 0 -26.5651> inverse }
		plane{ <1 0 0> 0 rotate <0 0 -26.5651> translate <1 0 0> }
		plane{ <0 1 0> 3 }
		plane{ <0 1 0> 0 inverse }
		plane{ <0 0 1> 1 }
		plane{ <0 0 1> 0 inverse }
		translate <-0.5 2 0>
	}
	box{ <-0.5 0 0> <0.5 2 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
#declare char_Z = object { union {
	intersection{
		box{ <0 0 0> <1 7 1> rotate <0 0 -29.6749> }
		plane{ <0 1 0>  5 }
		plane{ <0 -1 0> 0 }
		translate <-2 0 0>
	}
	box{ <-2 4 0> <1.2 5 1> }
	box{ <-1.2 0 0> <2 1 1> }
  }
  bounded_by{ box { <-2 0 0> <2 5 1> } }
}
// End of CHARS.INC
