/*   RayLathe (c) Koehler
   - Thick <0 = draw solid, =0 = move, >0 = draw hollow
   Revision History:
   03-24-93 1.00 KJK  New. Inspired by uLathe.
   03-28-93 1.01 KJK  Attempting Vivid output for Doug Downs.
   04-11-93 1.10 KJK  Releasable Vivid output version.
		      Noticed THICK in Vivid no supported! Must fix if possible.
   04-11-93 1.11 KJK  Cured black speckles in POVRAY output.
   04-14-93 1.12 KJK  Allow 0 length cones (rings) for Vivid.
   04-15-93 1.13 KJK  Enable THICK for Vivid. Print line # of .DAT file.
   04-24-93 1.20 KJK  Since they are necessary when thickness is used,
		      simulate cone/rings for POVRAY.
*/

#include <math.h>
#include <stdio.h>

#define min(a,b) (a<b ? a : b)
#define max(a,b) (a>b ? a : b)

#define VERSION 1.20

double intercept(double, double, double, double);
void  lathe_cut_viv(double, double, double, double, double);
void  lathe_cut_pov(double, double, double, double, double);

void main(argc,argv)
int argc;
char *argv[];
   {
   double oldx = 0.01, oldy = 0.01;
   double x, y, thick;
   double boundminx=10000000, boundmaxx=-10000000, boundmaxy=0;
   double length, center, eye_distance;
   char tracer;     /* p=POVRAY  v=Vivid */
   int line=0;

   fprintf(stderr,"RayLathe v%2.2f (c) 1993 Koehler\n",VERSION);

   tracer = 'p';
   if(argc > 1)   /* Look for Vivid option */
       {
       if ((strcmp(argv[1],"-v")==0) || (strcmp(argv[1],"-V")==0))
	   tracer = 'v';
       if ((strcmp(argv[1],"?")==0) || (strcmp(argv[1],"-?")==0) || (strcmp(argv[1],"/?")==0))
	   {
	   fprintf(stderr,"    Usage: RAYLATHE [-V] <infile.dat >outfile.inc\n");
	   exit();
	   }
       }
   if (tracer == 'p')
       fprintf(stderr,"    Generating POVRAY 1.0 object  (use -v for Vivid)\n");
   if (tracer == 'v')
       fprintf(stderr,"    Generating Vivid 2.0 object\n");

   if (tracer == 'p')
       {
       printf("// POVRAY 1.0 object created by RayLathe v%2.2f (c) 1993 Koehler\n",VERSION);
       printf("// See suggested camera vectors at end of this file\n\n");
       printf("#declare LatheWork =\n");
       printf("   composite\n");
       printf("      {\n");
       }
   if (tracer == 'v')
       {
       printf("// Vivid 2.0 object created by RayLathe v%2.2f (c) 1993 Koehler\n",VERSION);
       printf("// See overall dimensions of object at end of this file\n");
       /* printf("// See suggested camera vectors at end of this file\n"); */
       printf("\n");
       }
   scanf("%lf %lf %lf", &x, &y, &thick);
   line++;
   do
       {
       printf("// Line %4d (%lf, %lf, %lf)\n", line, x, y, thick);
       if (thick)
	   {
	   if (tracer == 'p')
	       lathe_cut_pov(oldx, oldy, x, y, thick);
	   if (tracer == 'v')
	       lathe_cut_viv(oldx, oldy, x, y, thick);
	   }
       boundmaxx = max(boundmaxx, x);
       boundminx = min(boundminx, x);
       boundmaxy = max(boundmaxy, y);
       oldx = x;
       oldy = y;
       scanf("%lf %lf %lf", &x, &y, &thick);
       line++;
       }
   while (y >= 0);
   if (tracer == 'v')
       printf("\n// Min X Y Z = %f %f %f    Max X Y Z = %f %f %f\n",boundminx,-boundmaxy,-boundmaxy, boundmaxx, boundmaxy, boundmaxy);
   if (tracer == 'p')
       {
       printf("      bounded_by\n");
       printf("         {\n");
       printf("         box {<%f %f %f>  <%f %f %f> }\n",boundminx,-boundmaxy,-boundmaxy, boundmaxx, boundmaxy, boundmaxy);
       printf("         }\n");
       printf("      }\n");
       length = boundmaxx - boundminx;
       center = length / 2 + boundminx;
       printf("\n#declare Look_At = <%f 0 0>   // Center of object\n", center);
       eye_distance = -max(fabs(length), boundmaxy*2.4);
       printf("#declare Location = <%f 0 %f>    // Good camera position\n", center, eye_distance);
       }
   }

void lathe_cut_viv(x1, y1, x2, y2, thick)
   double x1, y1, x2, y2, thick;
   {
   double minx, miny, minz, maxx, maxy, maxz, origin;

   /* cone { base 1 1 1 base_radius 4  apex 0 0 5 apex_radius 1 } */
   printf("   cone { base %f 0.0 0.0  base_radius %f   ", x1, y1);
   printf("apex %f 0.0 0.0  apex_radius %f }\n", x2, y2);
   if (thick > 0)
       {
       printf("   cone { base %f 0.0 0.0  base_radius %f   ", x1, max(y1-thick,0));
       printf("apex %f 0.0 0.0  apex_radius %f }\n", x2, max(y2-thick,0));
       printf("   cone { base %f 0.0 0.0  base_radius %f   ", x1, max(y1,0));
       printf("apex %f 0.0 0.0  apex_radius %f }\n", x1, max(y1-thick,0));
       printf("   cone { base %f 0.0 0.0  base_radius %f   ", x2, max(y2,0));
       printf("apex %f 0.0 0.0  apex_radius %f }\n", x2, max(y2-thick,0));
       }
   }

void lathe_cut_pov(x1, y1, x2, y2, thick)
   double x1, y1, x2, y2, thick;
   {
   double minx, miny, minz, maxx, maxy, maxz, origin;

   if (x1 == x2)
       if (thick)
	   x1 = x1 * 1.001;    /* Fudge a flat cone (ring) */
       else
	   return;
   minx = min(x1,x2);
   maxx = max(x1,x2);
   maxy = max(y1,y2);
   miny = -maxy;
   maxz = maxy;
   minz = miny;
/* printf("      object       // Line %4d (%lf, %lf, %lf)\n", line, x2, y2, thick); */
   printf("      object\n");
   printf("         {\n");
   printf("         intersection\n");
   printf("            {\n");
   if (y1 == y2)
       {
       if (y1 > 0)
	   {
	   printf("            quadric {Cylinder_X  ");
	   printf("scale <1 %f %f> }\n", y1, y1);
	   }
       }
   else
       {
       if ((x1 == 0) || (x2 == 0))
	   origin = 0;
       else
	   origin=intercept(x1, y1, x2, y2);
       printf("            quadric {QCone_X  ");
       if (x1 == 0)
	   printf("scale <%f %f %f>  ", fabs(origin-x2), y2, y2);
       else
	   printf("scale <%f %f %f>  ", fabs(origin-x1), y1, y1);
       printf("translate <%f 0 0> }\n", origin);
       }
   if ((thick >= 0) && (((y1-thick)>0) || ((y2-thick)>0)))
       {
       if (y1 == y2)
	   {
	   if ((y1-thick) > 0)
	       {
	       printf("            quadric {Cylinder_X  ");
	       printf("scale <1 %f %f> inverse }\n", y1-thick, y1-thick);
	       }
	   }
       else
	   {
	   if ((x1 == 0) || (x2 == 0))
	       origin = 0;
	   else
	       origin = (((y1-thick)/y1)*(origin-x1))+x1;
	   printf("            quadric {QCone_X  ");
	   if ((origin-x1) == 0)
	       printf("scale <%f %f %f>  ", fabs(origin-x2), y2-thick, y2-thick);
	   else
	       printf("scale <%f %f %f>  ", fabs(origin-x1), y1-thick, y1-thick);
	   printf("translate <%f 0 0> inverse }\n", origin);
	   }
       }
   printf("            box {<%f %f %f>  <%f %f %f> }\n",minx,miny,minz,maxx,maxy,maxz);
   printf("            }\n");
   minx = minx*1.001;  /* Adjust for bounding */
   maxx = maxx*1.001;
   maxy = maxy*1.001;
   miny = -maxy;
   maxz = maxy;
   minz = miny;
   printf("         bounded_by\n");
   printf("            { box {<%f %f %f>  <%f %f %f> } }\n",minx,miny,minz,maxx,maxy,maxz);
   printf("         texture { LatheWorkTex }\n");
   printf("         }\n");
   }

double intercept(x1, y1, x2, y2)
   double x1, y1, x2, y2;
   {
   double result;
   return(x2 - ((x2-x1) / (y2-y1) * y2));
   }
