#include <stdio.h>

#define VERSION 1.10

FILE *lathefile1, *lathefile2;

void main(argc,argv)
    int argc;
    char *argv[];
    {
    char filename1[30], filename2[30];
    unsigned char byte, slices;
    int word, x, y;
    int count;
    int io_count = 0;
    unsigned char slice_table[] = { 3,	4,  5,	6,  8,	9, 10, 12, 15, 18,
				   20, 24, 30, 36, 40, 45, 60, 72, 90, 120};

    fprintf(stderr,"Lat2RayL v%2.2f (c) 1993 Koehler\n\n",VERSION);
    if(argc < 2)   /* Missing the input file name argument - bitch and die */
       {
       puts("     Usage: lat2rayl <infile>\n");
       exit(1);
       }
    strcpy(filename1, argv[1]);
    if (strchr(filename1, '.') != NULL)
	{
	printf("File cannot have an extension\n");
	exit(2);
	}
    strcpy(filename2, filename1);
    strcat(filename1, ".lat");
    strcat(filename2, ".dat");
    lathefile1=fopen(filename1,"rb");
    if (lathefile1 == NULL)
	{
	printf("Error opening '%s'\n", filename1);
	exit(3);
	}
    lathefile2=fopen(filename2,"w");
    if (lathefile2 == NULL)
	{
	printf("Error opening '%s'\n", filename2);
	fclose(lathefile1);
	exit(3);
	}

    /*	-- Get Number of Slices -- */
    if (fseek(lathefile1, 14, SEEK_SET))
	{
	printf("Error seeking '%s'\n", filename1);
	fclose(lathefile1);
	fclose(lathefile2);
	exit(4);
	}
    if (fread(&byte, 1, 1, lathefile1) != 1)
	{
	printf("Error reading '%s'\n", filename1);
	fclose(lathefile1);
	fclose(lathefile2);
	exit(5);
	}
    slices = slice_table [byte];
    fprintf(lathefile2, "%d %d %d\n", -1, -1, slices);

    /*	-- Get Number of Points -- */
    if (fseek(lathefile1, 48, SEEK_SET))
	{
	printf("Error seeking '%s'\n", filename1);
	fclose(lathefile1);
	fclose(lathefile2);
	exit(4);
	}
    io_count = fread(&byte, 1, 1, lathefile1);
    count = byte;
    io_count += fread(&byte, 1, 1, lathefile1);
    if (io_count != 2)
	{
	printf("Error reading '%s'\n", filename1);
	fclose(lathefile1);
	fclose(lathefile2);
	exit(5);
	}
    count += byte * 256;

    printf("%s contains %d points\n", filename1, count);
    io_count += fread(&byte, 1, 1, lathefile1);
    x = byte;
    io_count += fread(&byte, 1, 1, lathefile1);
    x += byte * 256;
    io_count += fread(&byte, 1, 1, lathefile1);
    y = byte;
    io_count += fread(&byte, 1, 1, lathefile1);
    y += byte * 256;
    if (io_count != 6)
	{
	printf("Error reading '%s'\n", filename1);
	fclose(lathefile1);
	fclose(lathefile2);
	exit(5);
	}
    fprintf(lathefile2, "%d %d %d\n", x, y, 0);
    for (word=1; word < count; word++)
	{
	io_count = 0;
	io_count += fread(&byte, 1, 1, lathefile1);
	x = byte;
	io_count += fread(&byte, 1, 1, lathefile1);
	x += byte * 256;
	io_count += fread(&byte, 1, 1, lathefile1);
	y = byte;
	io_count += fread(&byte, 1, 1, lathefile1);
	y += byte * 256;
	if (io_count != 4)
	    {
	    printf("Error reading '%s'\n", filename1);
	    fclose(lathefile1);
	    fclose(lathefile2);
	    exit(5);
	    }
	fprintf(lathefile2, "%d %d %d\n", x, y, -1);
	}
    fprintf(lathefile2, "%d %d %d\n", -1, -1, -1);
    fclose(lathefile2);
    fclose(lathefile1);
    }
