/* File.C
** 4/26/91
** mjs
*/

/*
	12/06/91 -- Vivid output modified for 2.0 format (equals signs
		and semicolons removed)  Stephen Coy

*/

#include "sp.h"

static char *tri_prefix;
static char *vert_str;
static char *norm_str;
static char *tri_suffix;
static void output_triangles(void);

/************************************************************************/
/* Triangle output routines	*/

/* Raw output format	*/
void raw_out()
{
	tri_prefix = "";
	vert_str = "%7.4f %7.4f %7.4f ";
	norm_str = "%7.4f %7.4f %7.4f\n";
	tri_suffix = "\n";
	output_triangles();
}

/* NFF (MTV) output format	*/
void nff_out()
{
	tri_prefix = "pp 3\n";
	vert_str = "%7.4f %7.4f %7.4f ";
	norm_str = "%7.4f %7.4f %7.4f\n";
	tri_suffix = "\n";
	output_triangles();
}

/* Rayshade output format	*/
void rsh_out()
{
	tri_prefix = "triangle\n";
	vert_str = "%7.4f %7.4f %7.4f ";
	norm_str = "%7.4f %7.4f %7.4f\n";
	tri_suffix = "\n";
	output_triangles();
}

/* Vivid output format	*/
void viv_out()
{
	tri_prefix = "patch {\n";
	vert_str = "\tvertex %7.4f %7.4f %7.4f " ;
	norm_str = " normal %7.4f %7.4f %7.4f\n" ;
	tri_suffix = "}\n\n";
	output_triangles();
}

/* Vivid output format	*/
void viv1_out()
{
	tri_prefix = "patch = {\n";
	vert_str = "\tvertex = %7.4f %7.4f %7.4f; " ;
	norm_str = " normal = %7.4f %7.4f %7.4f;\n" ;
	tri_suffix = "}\n\n";
	output_triangles();
}

/* DKBTrace (STAR) output format	*/
void dkb_out()
{
	tri_prefix = "SMOOTH_TRIANGLE\n";
	vert_str = "< %7.4f %7.4f %7.4f > " ;
	norm_str = "< %7.4f %7.4f %7.4f >\n";
	tri_suffix = "END_TRIANGLE\n\n";
	output_triangles();
}

/* PoV Ray output format	*/
void pov_out()
{
	tri_prefix = "smooth_triangle\n";
	vert_str = "< %7.4f %7.4f %7.4f > " ;
	norm_str = "< %7.4f %7.4f %7.4f >\n";
	tri_suffix = "end_triangle\n\n";
	output_triangles();
}

/* Output triangles with normals	*/
void output_triangles()
{
	Triangle *t;

	t = t_root;
	while(t != NULL) {
		printf(tri_prefix);

		printf(vert_str, t->p1->x,  t->p1->y,  t->p1->z );
		printf(norm_str, t->p1->nx, t->p1->ny, t->p1->nz);

		printf(vert_str, t->p2->x,  t->p2->y,  t->p2->z );
		printf(norm_str, t->p2->nx, t->p2->ny, t->p2->nz);

		printf(vert_str, t->p3->x,  t->p3->y,  t->p3->z );
		printf(norm_str, t->p3->nx, t->p3->ny, t->p3->nz);

		printf(tri_suffix);

		t = t->next;		/* step to next in list	*/
	}
}

/************************************************************************/
/* Read a new triangle from stdin, saving the coordinates in the global
** variables.  Return TRUE if good data was read, else return FALSE.
** This is a *very* simple routine that expects *very* simple input data.
** It would be nice if it were intelligent enough to scan a ready-to-run
** tracer input file and pull out the data of interest, but...
*/

int read_triangle()
{
if(3 != (scanf(" %f%f%f \n",&new_v1.x, &new_v1.y, &new_v1.z))) return(FALSE);
if(3 != (scanf(" %f%f%f \n",&new_v2.x, &new_v2.y, &new_v2.z))) return(FALSE);
if(3 != (scanf(" %f%f%f \n",&new_v3.x, &new_v3.y, &new_v3.z))) return(FALSE);
	return(TRUE);
}

/*** eof ****************************************************************/
