/* Getopt.C
** 4/26/90
** mjs
**
** Originally yanked from the MTV raytracer source code, with index()
** replaced with strchr(), error reporting changed a little bit...
*/

#include <stdio.h>
#include <string.h>

/*
 * get option letter from argument vector
 */
int	opterr = 1,		/* useless, never set or used		*/
	optind = 1,		/* index into parent argv vector	*/
	optopt;			/* character checked for validity	*/
char	*optarg;		/* argument associated with option	*/

#define BADCH	(int)'?'
#define EMSG	""
#define err_tell(s)	/* fputs(*nargv,stderr); */ \
		fputc('\n',stderr); \
		fputs(s,stderr); \
		fputc(optopt,stderr); \
		fputc('\n',stderr); \
		return(BADCH);

int getopt(int, char *[], char *);	/* function prototype	*/
int getopt(int nargc, char *nargv[], char *ostr)
{
	static char	*place = EMSG;	/* option letter processing */
	register char	*oli;		/* option letter list index */

	/* allow '-', '/' and '\' as option prefixes	*/
	if(!*place) {			/* update scanning pointer */
		if(optind >= nargc || (
		   (*(place = nargv[optind]) != '-' ) &&
		   (*place != '/' ) && (*place != '\\')) ||
		   !*++place) return(EOF);

		if (*place == '-') {	/* found "--" */
			++optind;
			return(EOF);
		}
	}				/* option letter okay? */
	if ((optopt = (int)*place++) == (int)':' ||
	    !(oli = strchr(ostr,optopt))) {
		if(!*place) ++optind;
		err_tell("illegal option -- ");
	}
	if (*++oli != ':') {		/* don't need argument */
		optarg = NULL;
		if (!*place) ++optind;
	}
	else {				/* need an argument */
		if (*place) optarg = place;	/* no white space */
		else if (nargc <= ++optind) {	/* no arg */
			place = EMSG;
			err_tell("option requires an argument -- ");
		}
	 	else optarg = nargv[optind];	/* white space */
		place = EMSG;
		++optind;
	}
	return(optopt);			/* dump back option letter */
}

/*** eof ****************************************************************/
