/* Main.C
** 4/26/91
** mjs
**
** Entry point for the Sandpaper program.
*/

#define MAIN			/* make all GLOBALs show up here	*/
#include "sp.h"

int main(int argc, char *argv[])
{
	int c, output_fmt = FMT_NON;
	quiet = debug = FALSE;

	/* scan command line and catch all the options			*/
	while((c = getopt(argc,argv,"PpRrNnDdVvOoQqZzHh?")) != EOF) {
		switch(c) {

			case 'N' :	/* NFF(MTV) output format	*/
			case 'n' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_NFF;
				out_func = nff_out;	/* pt to func	*/
				break;

			case 'V' :	/* Vivid output format	*/
			case 'v' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_VIV;
				out_func = viv_out;	/* pt to func	*/
				break;

			case 'O' :	/* Vivid output format	*/
			case 'o' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_VIV1;
				out_func = viv1_out;	/* pt to func	*/
				break;

			case 'R' :	/* Rayshade output format	*/
			case 'r' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_RSH;
				out_func = rsh_out;	/* pt to func	*/
				break;

			case 'D' :	/* DKB output format	*/
			case 'd' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_DKB;
				out_func = dkb_out;	/* pt to func	*/
				break;

			case 'P' :	/* PoV output format	*/
			case 'p' :
				if(output_fmt != FMT_NON) df_erx(argv[0]);
				output_fmt = FMT_POV;
				out_func = pov_out;	/* pt to func	*/
				break;

			case 'Q' :
			case 'q' : quiet = TRUE; break;

			case 'Z' :
			case 'z' : debug = TRUE; break;

			case '?' :
			case 'H' :
			case 'h' :
				instr(argv[0]);		/* bad option	*/
				break;
		}
	}

	/* If not specified on the command line, use "raw" by default */
	if(output_fmt == FMT_NON) {
		out_func = raw_out;
	}

	/* All set up, now go do business	*/
	sp();

	return(0);
}

/* Duplicate format error exit	*/
void df_erx(char *s)
{
	fputs("Only 1 format spec allowed",stderr);
	instr(s);
}

void erx(char *s)
{
	fprintf(stderr,"%s\n",s);
	fprintf(stderr,"%d triangles, %d unique points, %d clist entries\n",
		tri_cnt, pt_cnt, cl_cnt);
	exit(1);
}

/* The value passed to instr should be the program's name, ie, argv[0]	*/
void instr(char *s)
{
	/* This prelimary nonsense is so that the "usage:" line will
	** show the program's name without drive, path and extension.
	** I *like* it like that; so sue me.
	*/
	char drive[_MAX_DRIVE], dir[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];

	_splitpath(s,drive,dir,fname,ext);	/* isolate pgm name	*/
	strlwr(fname);				/* convert to lower	*/

fprintf(stderr,"\nUsage: %s [-n | v | r | d ] [-q] [-z]\n",fname);
fputs("Output format flags...\n",stderr);
fputs("   -n : NFF (MTV)\n",stderr);
fputs("   -v : Vivid 2.0\n",stderr);
fputs("   -o : Vivid 1.0\n",stderr);
fputs("   -r : Rayshade\n",stderr);
fputs("   -d : DKB (STAR)\n",stderr);
fputs("   -p : PoV Ray(lowercase)\n",stderr);
fputs("If no format is specified, a 'raw' output is generated\n",stderr);
fputs("-q : quiet, no triangle count displayed while working\n",stderr);
fputs("-z : copious debugging info (not for the squeemish)\n",stderr);

	exit(1);
}

/*** eof ****************************************************************/
