/* SP.C
** 4/26/91
** mjs
*/

/*
	10/28/91 -- Added check for NULL pointer in function end_of_list().
		Now compiles clean in all memory models.  Stephen Coy
*/

#include "sp.h"

/************************************************************************/
void sp()
{
	Triangle *t_ptr;

	tri_cnt = pt_cnt = cl_cnt = 0;
	p_root = NULL;
	t_root = NULL;

while(read_triangle()) {
	if(t_root==NULL) {
		t_root = tri_alloc();		/* alloc new tri node	*/
		t_ptr = t_root;
	} else {
		t_ptr->next = tri_alloc();	/* alloc new tri node	*/
		t_ptr = t_ptr->next;
	}

	t_ptr->p1 = pt_save(&new_v1,t_ptr);	/* save the 3 points	*/
	t_ptr->p2 = pt_save(&new_v2,t_ptr);
	t_ptr->p3 = pt_save(&new_v3,t_ptr);

	calc_tri_normal(t_ptr);		/* crunch plane eq for normal	*/

	if(!quiet) {                    /* show our progress            */
		fprintf(stderr,"%3d\r",tri_cnt);
	}
}

	/* walk point list calculating point normals	*/
	calc_pt_normals();

	if(debug) {
		walk_triangles();
		walk_points();
	}

	/* Walk the triangle list outputing processed triangles
	** in the prefered format.
	*/
	(out_func)();

	/* That's all there is to it.	*/
}

/************************************************************************/
Point *pt_save(Vector *v, Triangle *t)
{
	Point *p;
	CList *eolist, *new_cl;

	if(p_root==NULL) {
		p_root = pt_alloc();
		p = p_root;
		p->x = v->x; p->y = v->y; p->z = v->z;
	} else {
		/* Is point already in list?  If not, alloc a new one	*/
		if((p = find_point(v)) == NULL) {
			p = pt_alloc();
			p->x = v->x; p->y = v->y; p->z = v->z;
			last_point->next = p;	/* link new node to end	*/
		}
	}

	/* Always alloc a new cl-node & save ptr to tri there	*/
	new_cl = cl_alloc();		/* get a new CList node		*/
	new_cl->tri = t;		/* save ptr to parent tri	*/

	/* Find end of "containing list" so we can add the caller's
	** triangle to it.
	*/
	eolist = end_of_list(p->cl);	/* find end of this pt's list	*/
	if(eolist == NULL) {		/* If none in list yet...	*/
		p->cl = new_cl;		/* make this the first		*/
	} else {
		eolist->next = new_cl;	/* link new node to end of list	*/
	}

	return(p);
}

/* Return a pointer to the last node in the CList	*/
CList *end_of_list(CList *c)
{
	if(c == NULL)
		return NULL;

	while(c->next != NULL) {
		c = c->next;
	}
	return(c);
}

/* Search the Point list for a point identical to the one contained in the
** passed vector.  If there is no matching point, return NULL.  This is
** where things can get real slow when many triangles are input.
*/
Point *find_point(Vector *v)
{
	Point *p;

	p = p_root;			/* start at the top	*/
	while(p != NULL) {
		if((p->x==v->x) && (p->y==v->y) && (p->z==v->z)) {
			return(p);		/* found one!		*/
		} else {
			last_point = p;		/* save this		*/
			p = p->next;		/* bump to next in list	*/
		}
	}

	return(NULL);		/* never found a match but last_point	*/
				/* will contain	a ptr to the last point	*/
				/* node	for subsequent linking		*/
}

/* Allocation routines	*/
Point *pt_alloc()
{
	Point *p;

	if(!(p = (Point *)malloc(sizeof(Point)))) {
		erx("Can't allocate another Point node");
	}
	pt_cnt++;		/* count 'em up			*/
	p->next = NULL;		/* null out forward pointer	*/
	p->cl = NULL;		/* null out "containg list" ptr	*/
	return(p);		/* return with the goods	*/
}

Triangle *tri_alloc()
{
	Triangle *t;

	if(!(t = (Triangle *)malloc(sizeof(Triangle)))) {
		erx("Can't allocate another Triangle node");
	}
	t->next = NULL;
	tri_cnt++;
	return(t);
}

CList *cl_alloc()
{
	CList *c;

	if(!(c = (CList *)malloc(sizeof(CList)))) {
		erx("Can't allocate another CList node");
	}
	c->next = NULL;
	cl_cnt++;
	return(c);
}

/************************************************************************/
/* Debugging routine to walk down the triangle list	*/
void walk_triangles()
{
	Triangle *t;
	int count = 0;

	t = t_root;
	while(t != NULL) {
		printf("Triangle %2d at %p\n",count,t);

		printf("Point 1 = < %7.4f %7.4f %7.4f > at %p\n",
			t->p1->x, t->p1->y, t->p1->z, t->p1);

		printf("Point 2 = < %7.4f %7.4f %7.4f > at %p\n",
			t->p2->x, t->p2->y, t->p2->z, t->p2);

		printf("Point 3 = < %7.4f %7.4f %7.4f > at %p\n",
			t->p3->x, t->p3->y, t->p3->z, t->p3);

		printf("Normal = %7.4f %7.4f %7.4f\n",
			t->eq_a, t->eq_b, t->eq_c);

		t = t->next;		/* step to next in list	*/
		count++;
		putchar('\n');
	}
}

/* Debugging routine to walk down the point list	*/
void walk_points()
{
	Point *p;
	int count = 0;

	p = p_root;
	while(p != NULL) {
		printf("Point %2d at %p ",count, p);
		printf("< %7.4f %7.4f %7.4f >\n", p->x, p->y, p->z);
		printf("Normal: < %7.4f %7.4f %7.4f >\n", p->nx, p->ny, p->nz);
		walk_clist(p->cl);

		p = p->next;
		count++;
		putchar('\n');
	}
}

/* Debugging routine to walk down the "containing" list	*/
void walk_clist(CList *cl)
{
	while(cl != NULL) {
		printf("%p=%p ",cl, cl->tri);
		cl = cl->next;
	}
	putchar('\n');
}

/*** eof ****************************************************************/
