/* SP.H
** 4/26/91
** mjs
**
** Header file for the Sandpaper program.
*/

#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>			/* for _splitpath()		*/
#include <string.h>			/* for strlwr()			*/
#include <process.h>			/* for exit()			*/

#define FALSE (0)
#define TRUE (!FALSE)

/* Output format flag values	*/
#define FMT_NON 0			/* "raw"						*/
#define FMT_NFF	1			/* NFF (MTV)			*/
#define FMT_VIV	2			/* Vivid					*/
#define FMT_VIV1	5			/* Vivid	1.0			*/
#define FMT_DKB	3			/* DKBTrace (STAR)	*/
#define FMT_POV	6			/* PoV Ray - DKB		*/
#define FMT_RSH   4			/* Rayshade				*/

typedef float real;

typedef struct {
	real x,y,z;
} Vector;

typedef struct pt_node {		/* Point node structure		*/
	real x, y, z;			/* point coordinates		*/
	real nx, ny, nz;		/* calc'd normals for the point	*/
	struct clist_node *cl;		/* ptr to list of using tri's 	*/
	struct pt_node *next;		/* ptr to next node in list	*/
} Point ;

typedef struct tri_node {		/* Triangle node structure	*/
	Point *p1, *p2, *p3;		/* ptr to 3 Point nodes		*/
	real eq_a, eq_b, eq_c;		/* plane eq surface normal	*/
	struct tri_node *next;		/* ptr to next node in list	*/
} Triangle ;

typedef struct clist_node {		/* "Containing List" node stru	*/
	struct tri_node *tri;		/* a triangle that uses this pt	*/
	struct clist_node *next;	/* ptr to next node in list	*/
} CList ;

/* Global Variables	*/
#ifdef MAIN
#define GLOBAL
#else
#define GLOBAL extern
#endif

//GLOBAL int getopt(int, char *[], char *);
//GLOBAL int optind, opterr;
//GLOBAL char *optarg;
GLOBAL Vector new_v1, new_v2, new_v3;	/* storage for inbound tri's	*/
GLOBAL Point *p_root;			/* top of Point list		*/
GLOBAL Triangle *t_root;		/* top of Triangle list		*/
GLOBAL Point *last_point;		/* ptr to end of point list	*/
GLOBAL int tri_cnt, pt_cnt, cl_cnt;	/* counts for error reporting	*/
GLOBAL int debug, quiet, format;	/* misc cmd line flags		*/
GLOBAL void (*out_func)(void);		/* pointer to output function	*/

/* Function Prototypes	*/
#define PROTO				/* just something to grep for	*/

/* from Main.C	*/
PROTO      int   main(int, char *[]);
PROTO     void	 df_erx(char *);
PROTO     void   erx(char *);
PROTO     void   instr(char *);

/* from SP.C	*/
PROTO     void   sp(void);
PROTO    Point * pt_alloc(void);
PROTO    Point * find_point(Vector *);
PROTO    Point * pt_save(Vector *, Triangle *);
PROTO    CList * cl_alloc(void);
PROTO    CList * end_of_list(CList *);
PROTO Triangle * tri_alloc(void);
PROTO      int   read_triangle(void);
PROTO     void   walk_clist(CList *);
PROTO     void   walk_points(void);
PROTO     void   walk_triangles(void);

/* from Normal.C	*/
PROTO void calc_tri_normal(Triangle *);
PROTO void calc_pt_normals(void);

/* from File.C	*/
PROTO void raw_out(void);
PROTO void nff_out(void);
PROTO void viv_out(void);
PROTO void viv1_out(void);
PROTO void rsh_out(void);
PROTO void pov_out(void);
PROTO void dkb_out(void);

/*** eof ****************************************************************/
