#define FALSE 0
#define TRUE !FALSE

#define MAXTRANSIENTS 1000       // "Throwaway" iterations

// Function prototypes
int huge DetectVGA256(void);
int huge DetectVGA16(void);
int huge Init_Graphics(void);
void far getvgapalette16(DacPalette16 *PalBuf);
void far getvgapalette256(DacPalette256 *PalBuf);
void far setvgapalette16(DacPalette16 *PalBuf);
void far setvgapalette256(DacPalette256 *PalBuf);
int loadpalette(void);
void rotate_palette(int direction, int single_step_flag);
void findpath(char *filename, char *fullpathname);
int save_screen(void far *imagebuffer, int x1, int y1, int x2, int y2);
void restore_screen(void far *imagebuffer, int x, int y);
unsigned far getimgsize(int x1, int y1, int x2, int y2);

void iterate(void);
void iterate1(void);
void iterate2(void);
void iterate3(void);

void plot_points1(double x, double y);
void plot_points2(double x, double y);

void next_formula(int *whichformula, int direction);
void next_formula_1(int *whichformula, int direction);
void next_formula_2(int *whichformula, int direction);
void next_formula_3(int *whichformula, int direction);
void print_formula_name(char *thisformula);

void color_mode(void);
int getkey(void);
int dokeypress(int key);
int matherr(struct exception *e);
void reset_scale(void);
void clear_trig_tables(void);
void init_trig_tables(void);
void trig(void);
void init_stats(void);

// Key values
#define CR 13
#define ESC 27
#define HOMEKEY 327
#define ENDKEY 335
#define UPKEY 328
#define DOWNKEY 336
#define PGUPKEY 329
#define PGDNKEY 337
#define LEFTKEY 331
#define INSKEY 338
#define RIGHTKEY 333
#define DELKEY 339
#define CTRLLEFTKEY 371
#define CTRLRIGHTKEY 372
#define F1 315
#define F2 316
#define F3 317
#define F4 318
#define F5 319
#define F6 320
#define F7 321
#define F8 322
#define F9 323
#define F10 324

/**********************************************/
/* SuperVGA BGI Video "Detection" procedures. */
/* Copyright (c) 1991                         */
/* Jordan Hargraphix Software                 */
/**********************************************/

int Xasp, Yasp;
int HicolorFlag;
int GDriver = DETECT, GMode, Errorcode;

int huge DetectVGA256(void)
{
	int Vid;
	gotoxy(1,1);
	printf("\n");
	printf("Select Video Mode:ͻ\n");
	printf(" [ 1 ] ... 320x200x256  \n");
	printf(" [ 2 ] ... 640x400x256  \n");
	printf(" [ 3 ] ... 640x480x256  \n");
	printf(" [ 4 ] ... 800x600x256  \n");
	printf(" [ 5 ] ...1024x768x256  \n");
	printf("ͼ\n\n>");
	scanf("%d",&Vid);
	if(Vid < 1 || Vid > 5) exit(-1);
	return Vid -1;
}

int huge DetectVGA16(void)
{
	int Vid;
	gotoxy(1,1);
	printf("\n");
	printf("Select Video Mode:ͻ\n");
	printf(" [ 1 ] ... 320x200x16   \n");
	printf(" [ 2 ] ... 640x200x16   \n");
	printf(" [ 3 ] ... 640x350x16   \n");
	printf(" [ 4 ] ... 640x480x16   \n");
	printf(" [ 5 ] ... 800x600x16   \n");
	printf(" [ 6 ] ...1024x768x16   \n");
	printf("ͼ\n\n>");
	scanf("%d",&Vid);
	if(Vid < 1 || Vid > 6) exit(-1);
	return Vid -1;
}
int huge Init_Graphics(void)
{
	int Drv;
	clrscr();
	printf("\n");
	printf("Select Video Mode:ͻ\n");
	printf(" [ 1 ] ... SVGA16       \n");
	printf(" [ 2 ] ... SVGA256      \n");
    printf("ͼ\n\n>");
	scanf("%d",&Drv);
	if(Drv < 1 || Drv > 2) exit(-1);
	switch(Drv)
	{
	case 1: installuserdriver("Svga16",DetectVGA16);
			registerfarbgidriver(Svga16_fdriver);
			break;
	case 2: installuserdriver("Svga256",DetectVGA256);
			registerfarbgidriver(Svga256_fdriver);
			break;
	}
	initgraph(&GDriver,&GMode,"");
	Errorcode = graphresult();          /* read result of initgraph call */
	if (Errorcode != grOk)              /* an error occurred */
	{
		printf("Graphics error: %s\n",grapherrormsg(Errorcode));
		printf("Press any key to halt:");
		getch();
		exit(1);
	}
//   getaspectratio(&Xasp, &Yasp);
//   setaspectratio(Xasp, Yasp);
	return(0);
}



// Getvgapalette16 gets the entire 16 color palette
// PalBuf contains RGB values for all 16 colors
// R,G,B values range from 0 to 63
// Usage:
//  DacPalette16 dac16;
//
//  getvgapalette(&dac16);
void far getvgapalette16(DacPalette16 *PalBuf)
{
  struct REGPACK reg;

  reg.r_ax = 0x1017;
  reg.r_bx = 0;
  reg.r_cx = 16;
  reg.r_es = FP_SEG(PalBuf);
  reg.r_dx = FP_OFF(PalBuf);
  intr(0x10,&reg);
}

// Getvgapalette256 gets the entire 256 color palette
// PalBuf contains RGB values for all 256 colors
// R,G,B values range from 0 to 63
// Usage:
//  DacPalette256 dac256;
//
// getvgapalette256(&dac256);
void far getvgapalette256(DacPalette256 *PalBuf)
{
  struct REGPACK reg;

  reg.r_ax = 0x1017;
  reg.r_bx = 0;
  reg.r_cx = 256;
  reg.r_es = FP_SEG(PalBuf);
  reg.r_dx = FP_OFF(PalBuf);
  intr(0x10,&reg);
}

// Setvgapalette16 sets the entire 16 color palette
// PalBuf contains RGB values for all 16 colors
// R,G,B values range from 0 to 63
// Usage:
//  DacPalette16 dac16;
//
//  setvgapalette(&dac16);
void far setvgapalette16(DacPalette16 *PalBuf)
{
  struct REGPACK reg;

  reg.r_ax = 0x1012;
  reg.r_bx = 0;
  reg.r_cx = 16;
  reg.r_es = FP_SEG(PalBuf);
  reg.r_dx = FP_OFF(PalBuf);
  intr(0x10,&reg);
}

// Setvgapalette256 sets the entire 256 color palette
// PalBuf contains RGB values for all 256 colors
// R,G,B values range from 0 to 63
// Usage:
//  DacPalette256 dac256;
//
// setvgapalette256(&dac256);
void far setvgapalette256(DacPalette256 *PalBuf)
{
  struct REGPACK reg;

  reg.r_ax = 0x1012;
  reg.r_bx = 0;
  reg.r_cx = 256;
  reg.r_es = FP_SEG(PalBuf);
  reg.r_dx = FP_OFF(PalBuf);
  intr(0x10,&reg);
}

DacPalette256 Palette256;
