
;Pcspace-screen driver Hercules- 16colors
;
;To create a hercl.drv:
; tasm hercl
; tlink hercl
; exe2bin hercl
; ren hercl.bin hercl.drv
; Attention: Maximum length of the drv file: 256 Bytes

prog  segment para 'code'
 assume cs:prog
 assume ds:prog
 assume ss:prog
 assume es:prog

start  proc  far
       ; Initialize entry point for video mode
       jmp short init

       ; Set the entry point 64k bank and set the segment address to es
       ; The bank number has been set in al.
       jmp short bank

     ;parameter for the driver
       db 15 ;number of colors-1
       ;Table of parameters for initialization
       ;Parametertabelle fr Initialisierung
       db 12h ;Mode 0: resolution 640*480
       db 5bh ;Mode 1: resolution 800*600
       db 5fh ;Mode 2: resolution 1024*768
       db -1  ;Mode 3: resolution 1280*960 (no such resolution)
       db -1  ;Mode 4: resolution 1280*1024 (no such resolution)

       db "Hercules SVGA 16colors" ;Identification text for SETUP
       db 0                        ;length can be adjustable

     ;Initialize video mode
     ;Used registers: ax,bx
     ;al has been set to the value of the parameter table
     ;No such resolution (Par.-1) has been captured already.
 init: xor   ah,ah
       int   10h
       retf


     ;set video bank
     ;Used registers: ax,dx,es
 bank: mov   dx,0a000h   ;segmentadr. video memory
       mov   es,dx

       mov   ah,al
       mov   dx,03ceh
       in    al,dx
       push  ax
       mov   al,6
       out   dx,al

       inc   dl
       in    al,dx
       dec   dl
       or    al,4
       mov   ah,al
       mov   al,06h
       out   dx,ax
       mov   dl,0c4h
       mov   al,0bh
       out   dx,al

       inc   dl
       in    al,dx
       dec   dl
       pop   ax
       push  ax
       xor   ah,2
       mov   al,0eh
       out   dx,ax
       pop   ax
       mov   dx,03ceh
       out   dx,al
       retf


start  endp

prog  ends

 end  start