
;Pcspace-screen driver S3- 256colors
;
;To create a S3h.drv:
; tasm s3h
; tlink s3h
; exe2bin s3h
; ren s3h.bin s3h.drv
;
; Attention: Maximum length of the drv file: 256 Bytes

prog  segment para 'code'
 assume cs:prog
 assume ds:prog
 assume ss:prog
 assume es:prog

start  proc  far
       ; Initialize entry point for video mode
       jmp short init

       ; Set the entry point 64k bank and set the segment address to es
       ; The bank number has been set in al.
       jmp short bank

     ;parameter for the driver
       db 255 ;number of colors-1
       ;Table of parameters for initialization
       db 01h ;Mode 0: resolution 640*480
       db 03h ;Mode 1: resolution 800*600
       db 05h ;Mode 2: resolution 1024*768
       db -1  ;Mode 3: resolution 1280*960 (no such resolution)
       db -1  ;Mode 4: resolution 1280*1024 (no such resolution)

       db "S3 256colors" ;Identification text for SETUP
       db 0              ;length can be adjustable

     ;Initialize video mode
     ;Used registers: ax,bx
     ;al has been set to the value of the parameter table
     ;No such resolution (Par.-1) has been captured already.
 init: push  ax
       mov   bl,al
       mov   bh,2
       mov   ax,4f02h
       int   10h

       xor   ax,ax
       mov   es,ax

       pop   ax
       mov   ah,al
       mov   al,50h
       cmp   ah,1
       je    inz
       mov   al,64h
       cmp   ah,3
       je    inz
       mov   al,80h
       cmp   ah,5
       je    inz
       mov   al,0a0h
   inz:xor   ah,ah
       mov   es:044ah,ax

       mov   ah,al
       mov   dx,3d4h
       mov   al,11h
       out   dx,al
       inc   dx
       in    al,dx
       and   al,07fh
       out   dx,al

       dec   dx
       mov   al,13h
       out   dx,al
       inc   dx
       mov   al,ah
       out   dx,al
       retf


     ;set video bank
     ;Used registers: ax,dx,es
 bank: push  cx
       mov   cl,al
       mov   dx,03d4h

       mov   al,38h
       out   dx,al
       inc   dx
       mov   al,48h
       out   dx,al

       dec   dx
       mov   al,31h
       out   dx,al

       inc   dx
       in    al,dx
       or    al,09h
       out   dx,al

       dec   dx
       mov   al,35h
       out   dx,al
       inc   dx
       in    al,dx

       and   al,0f0h
       or    al,cl
       out   dx,al
       pop   cx

       ;segmentadr. video memory
       mov   ax,0a000h
       mov   es,ax
       retf


start  endp

prog  ends

 end  start