
;Pcspace-screen driver ET3000/ET4000- 256colors
;
;To create a tsengh.drv:
; tasm tsengh
; tlink tsengh
; exe2bin tsengh
; ren tsengh.bin tsengh.drv
;
; Attention: Maximum length of the drv file: 256 Bytes

prog  segment para 'code'
 assume cs:prog
 assume ds:prog
 assume ss:prog
 assume es:prog

start  proc  far
       ; Initialize entry point for video mode
       jmp short init

       ; Set the entry point 64k bank and set the segment address to es
       ; The bank number has been set in al.
       jmp short bank

     ;parameter for the driver
       db 255 ;number of colors-1
       ;Table of parameters for initialization
       db 2eh ;Mode 0: resolution 640*480
       db 30h ;Mode 1: resolution 800*600
       db 38h ;Mode 2: resolution 1024*768
       db -1  ;Mode 3: resolution 1280*960 (no such resolution)
       db -1  ;Mode 4: resolution 1280*1024 (no such resolution)

       db "Tseng 256colors" ;Identification text for SETUP
       db 0                 ;length can be adjustable

     ;Initialize video mode
     ;Used registers: ax,bx
     ;al has been set to the value of the parameter table
     ;No such resolution (Par.-1) has been captured already.
 init: push  bx
       xor   ah,ah
       int   10h

       mov   dx,3cdh
       in    al,dx       ;et3000/4000 test

       mov   dx,0e4d0h
       and   al,0c0h
       jz    etst
       mov   dx,0400ch

  etst:pop   bx
       add   bx,offset mark
       mov   cs:bx,dx
       retf


     ;set video bank
     ;Used registers: ax,dx,es
 bank: mov   ah,al
       shl   ah,1
       shl   ah,1
       shl   ah,1
  mark:nop
       nop
       or    al,ah
       mov   dx,03cdh
       out   dx,al

       ;segmentadr. video memory
       mov   dx,0a000h
       mov   es,dx
       retf


start  endp

prog  ends

 end  start