;init V2.0 / bank V2.0 routines for VESA 256 colors
;(c) 1993 Christian Wagner (wagner@informatik.tu-muenchen.de)
; and Peter Liebel
;for Pcspace from Peter Liebel

;Pcspace-screen driver VESA- 256colors
;
;To create a vesah.drv:
; tasm vesah
; tlink vesah
; exe2bin vesah
; ren vesah.bin vesah.drv
;
; Attention: Maximum length of the drv file: 256 Bytes

prog  segment dword 'code'
 assume cs:prog

start  proc  far
       ; Initialize entry point for video mode
       jmp short init

       ; Set the entry point 64k bank and set the segment address to es
       ; The bank number has been set in al.
       jmp short bank

     ;parameter for the driver
       db 255 ;number of colors-1
       ;Table of parameters for initialization
       db 01h ;Mode 0: resolution 640*480
       db 03h ;Mode 1: resolution 800*600
       db 05h ;Mode 2: resolution 1024*768
       db -1  ;Mode 3: resolution 1280*960 (no such resolution)
       db -1  ;Mode 4: resolution 1280*1024 (no such resolution)

       db "VESA 256colors" ;Identification text for SETUP
       db 0                ;length can be adjustable

     ;Initialize video mode
     ;Used registers: ax,bx
     ;al has been set to the value of the parameter table
     ;No such resolution (Par.-1) has been captured already.
 init:  push    bx              ;offsetadress of the driver
        mov     bl,al           ;value of the parameter table
        mov     bh,1
        mov     ax,4f02h
        int     10h

        xor     bx,bx
        mov     dx,1
        mov     ax,4f05h
        int     10h

        mov     ax,0a000h
        mov     es,ax
        mov     es:0,ah
        push    ax

        xor     bx,bx
        xor     dx,dx
        mov     ax,4f05h
        push    ax
        int     10h
        xor     dx,dx
        mov     bx,1
        pop     ax
        int     10h

        pop     ax
        mov     bx,100h
        mov     cl,8
   grlp:shl     bx,1
        dec     cl
        jz      grout
        cmp     es:bx,ah
        jne     grlp

  grout:pop     bx
        add     bx,1+offset mark
        mov     cs:bx,cl

        xor     bx,bx
        mov     dx,1
        mov     ax,4f05h
        int     10h

        xor     al,al
        mov     es:0,al
        retf


     ;set video bank
     ;Used registers: ax,dx,es
 bank:
        push    bx
        push    cx

        xor     dx,dx
        mov     dl,al

   mark:mov     cl,0
        shl     dx,cl
        push    dx              ;save bank no.

        xor     bx,bx           ;set frame no.0
        mov     ax,4f05h        ;VESA frame function
        int     10h

        pop     dx              ;restore bank
        mov     bx,01           ;set frame no.1
        mov     ax,4f05h        ;VESA frame function
        int     10h

        mov     dx,0a000h       ;segmentadr. video memory
        mov     es,dx

        pop     cx
        pop     bx
        retf


start  endp

prog  ends

 end  start