/******************************************************************************		      
*		FT990.C							      * 
*									      * 
* 1. Computer Aided Transceiver sytem for the Yaesu FT-990 (Primary)          * 
*									      * 
* 2. Some of the main commands are identical for the FT-1000, FT-890	      * 
*									      * 
* This is just a template program to test the CAT interface		      * 
* on the FT-1000 ,FT-990, and FT-890					      * 
*									      * 
* This source (FT990.C and FT990.H) is in the public domain		      * 
* and may be freely copied						      * 
*									      * 
* I do request any enhancements made to the program be made		      * 
* available to the general ham community too, so that others		      * 
* can enjoy doing this as much as I did.				      * 
*=============================================================================+
* and my thanks to:							      * 
*		     C. Karcher						      * 
*     		     Seattle WA						      * 
*     		     CSID 76406,536					      * 
*									      * 
* for providing the serial communications utility.			      * 
*		(RS232.C,RS232.H)					      * 
*=============================================================================+ 
*									      * 
* Any questions or ideas for ft990.c should be addressed to the		      * 
* author:								      * 
*									      * 
*	Robert Cartier							      * 
*	112 Fieldbrook Rd.						      * 
*	Middletown, Ct. 06457						      * 
*	(203)771-7027 (Days)						      * 
*       (203)632-9055 (Evenings)					      * 
*	Compuserve : (76424,176)					      * 
*	Packet     : KD1JG @ W1NRG.CT.USA				      * 
*									      * 
*	Source was compiled using Borland Turbo C++ 1.0			      * 
*									      * 
*	Date		Version						      * 
*	--------	-------						      * 
*	12/11/92	1.10	Released to the public domain by* Author      * 
*                                                                             *
* 	12/16/92	1.20    Completed the Read Meter, Read Flags and      *
*				Read Status.                                  *
*                                                                             *
*	12/17/92	1.21	Added Memory status option		      * 
******************************************************************************/
#include <conio.h>						
#include <ctype.h>						
#include <dir.h>						
#include <stdio.h>						
#include <stdlib.h>
#include <string.h>
#include "ft990.h"
#include "rs232.c"

#define OUT_BUFSIZE 16U  /* 16 bytes output  buffer to minimize scan ahead*/
#define IN_BUFSIZE 2048U /* enough for read status */

#define ESC 0x1b

char *version = "1.21";
char *date    = "12-17-92";

static char in_buf[IN_BUFSIZE];
static char out_buf[OUT_BUFSIZE];

int Convert_to_BCD(char *);

void Press_Rtn(void);
void Read_5_Bytes(void);
void Flush_Inbuffer(void);
void Toggle_Value(int);
void ScanDir(void);

void Read_Status(void);
void Send_To_Radio(void);
void Set_Freq(void);
void Set_Up(char *, char *);
void Toggle_Split_Vfo(void);
void Recall_Mem(void);
void Vfo_Mem(void);
void Lock_Dial(void);
void Toggle_Vfo(void);
void Copy_Vfo_Mem(void);
void Up_Down_Freq(void);
void Scan(void);
void Clarifier(void);
void Set_Modes(void);
void Set_Pacing(void);
void Ptt(void);
void Status_Update(void);
void Tuner_Toggle(void);
void Start_Tuner(void);
void Rpt_Shift_Offset(void);
void Vfo_A_B(void);
void Bandwidth(void);
void Mem_Scan_Skip(void);
int  Step_Freq(void);
void Read_Meter(void);
void Dim_Level(void);
void Read_Flags(void);
void Update_Radio(void);
void Scan_File(void);
void Get_Mode(int);
void Get_Filter(char *,int);
void Disp_Mem(void);

void main()
{
	char answer[3] = {'\0'};
	clrscr();

	Set_Up(in_buf,out_buf);	/*	initialize I/O port */

	for(;;)	{
  	 clrscr();
	 puts("                   ͻ");
	 puts("                    Computer Aided Transceiver Control ");
	 puts("                                for the                ");
	 puts("                              YAESU FT-990             ");
	 puts("                            with support for           ");
	 puts("                              FT-1000/890              "); 
	 puts("                                 KD1JG                 ");
	 puts("                   ͼ");
	 puts("                               Ŀ");
	 puts("                                Main Menu ");
	 puts("                               \n");
	 puts("    1. Set New Frequency    2. Recall Memory        3. Copy VFO->M ");
	 puts("    4. Lock/Unlock Dial     5. Select VFO           6. Copy M->VFO");
	 puts("    7. Step UP/DOWN         8. SCAN                 9. Set Clarifier");
	 puts("   10. Split VFO           11. Select Mode         12. Set Pacing ");
	 puts("   13. Ptt                 14. Get Radio Status    15. Activate Tuner");
	 puts("   16. Start Tuner         17. Rptr Shift/Offset   18. Copy VFO A<->B");
	 puts("   19. Select Bandwidth    20. Memory Chan skip    21. Step OP freq");
	 puts("   22. Read Meter          23. Dim Level           24. Read Flags");
	 puts("   25. Display Memory      26. Update from file    27. Scan From File");
	 puts("");
	 puts("                           99. Exit");
	 gotoxy(1,1);
	 printf("Ver. %s",version);
	 gotoxy(72,1);
	 printf("%s",date);
	 fflush(stdin);
	 gotoxy(1,25);
	 printf("Choice    ");
	 gets(answer);

	 clrscr();

	 switch(atoi(answer)) {
   	   case 1:
		Set_Freq();
		break;
	   case 2:
		Recall_Mem();
		break;
	   case 3:
		Vfo_Mem();
		break;
	   case 4:
		Lock_Dial();
		break;
	   case 5:
		Toggle_Vfo();
		break;
	   case 6:
		Copy_Vfo_Mem();
		break;
	   case 7:
		Up_Down_Freq();
		break;
	   case 8:
		Scan();
		break;
	   case 9:
		Clarifier();
		break;
	   case 10:
		Toggle_Split_Vfo();
		break;
	   case 11:
		Set_Modes();
		break;
	   case 12:
		Set_Pacing();
		break;
	   case 13:
		Ptt();
		break;
	   case 14:
		Status_Update();
		break;
	   case 15:
		Tuner_Toggle();
		break;
	   case 16:
		Start_Tuner();
		break;
	   case 17:
		Rpt_Shift_Offset();
		break;
	   case 18:
		Vfo_A_B();
		break;
	   case 19:
		Bandwidth();
		break;
	   case 20:
		Mem_Scan_Skip();
		break;
	   case 21:
		Step_Freq();
		break;
	   case 22:
		Read_Meter();
		break;
	   case 23:
		Dim_Level();
		break;
	   case 24:
		Read_Flags();
		break;
	   case 25:
		Disp_Mem();
		break;
	   case 26:
		Update_Radio();
		break;
	   case 27:
		Scan_File();
		break;
	   case 99:
		rs_close();
		clrscr();
		puts("Robert Cartier - KD1JG ");
		puts("Packet: KD1JG @ W1NRG.CT");
		puts("CIS:    76424,176");
		sleep(2);
		exit(0);
	 }
	}
}
void Set_Freq(void)
{
	int	i,j;

	double real_freq = 0;
	double freq_khz = 0;

	char freq_out[20];
	char freq_str[20];

	send.cmd.opcode = SET_FREQ;		
enter_frq:
	printf("Enter New Frequency : ");
	scanf("%lf",&real_freq);

	freq_khz = real_freq * 100000.0;

	if ((freq_khz > 2999999) || (freq_khz < 100)){
		printf("out of range -- re-enter\n\a");
		goto enter_frq;
	}
	printf("Real Freq in khz : %08.0f\n",freq_khz);

	sprintf(freq_str,"%08.0f",freq_khz);

	for(i = 0, j = 0; i < 8 ; i += 2,j++)	
	 send.cmd.data[j] = Convert_to_BCD(&freq_str[i]);

	Send_To_Radio();
}

int Convert_to_BCD(char *tmp)
{
	int bcd;
	char high[2];
	char low[2];
	
	strncpy(high,&tmp[0],1);
	high[1] = '\0';
	strncpy(low,&tmp[1],1);
	low[1] = '\0';

	bcd = atoi(low);

	bcd += (atoi(high) * 16);

	return(bcd);
}

void Set_Up(char *in_buf,char *out_buf)
{

  char port,parity,bits,stop;
  char tmp[2];
  long baud;

  *tmp = '\0';
  while(*tmp < '1' || *tmp > '4') {
    printf("Communications Port (1,2,3 or 4):");
    gets(tmp);
  }
  port = *tmp;
  baud = 4800L;
  parity = 'N';
  bits = '8';
  stop = '2';

  /* initialize port */
  if(rs_initport(port,baud,parity,bits,stop,IN_BUFSIZE,in_buf,OUT_BUFSIZE,out_buf)) {
    printf("Failed to initialize port\n");
    rs_close();
    exit(1);
  }
}

void Send_To_Radio(void)
{ 
	short i = COMMAND_SIZE; /* init to size of command */

	Flush_Inbuffer();       /* flush input buffer */

	/* send data to radio in reverse order */

	do {
	  rs_sndbyt(send.cmd_fill.fill[i-1]);
	  i--;
	}while(i != 0);

	memset(&send,0x00,COMMAND_SIZE);

	return;
}
void Toggle_Split_Vfo(void)
{
	Toggle_Value(SPLIT);
}
void Recall_Mem(void)
{
	char ch_str[3];
	char answer[2];

	short channel = 0;

	printf("Enter Channel to Recall : ");
	scanf("%s",ch_str);
	channel = atoi(ch_str);
	if(channel > 90) {
		printf("\aMust between 0 and 90");
		return;
	}
	send.cmd.opcode  = RECALL_MEM;
	send.cmd.data[0] = channel;
	Send_To_Radio();


}
void Vfo_Mem(void)
{
	char ch_str[3];
	char answer[2];

	short hide = 0;
	short channel = 0;

	printf("Enter Channel to Store : ");
	scanf("%s",ch_str);
	channel = atoi(ch_str);
	if((channel < 1) || (channel > 90)) {
		printf("\aMust between 1 and 90");
		return;
	}
	printf("Channel Selected : %s\n",ch_str);
	printf("okay to update (y/n) : ");
	scanf("%s",answer);

	if((toupper(*answer)) == 'Y') {
		send.cmd.opcode  = VFO_M;
		send.cmd.data[0] = channel;
		send.cmd.data[1] = hide;

		Send_To_Radio();
	}

}
void Lock_Dial(void)
{
	Toggle_Value(LOCK_DIAL);

}
void Toggle_Vfo(void)
{
	short flag = 1;
	printf("Press any key to toggle <ESC> to exit\n ");
	for(;;) {
	 if(kbhit()) {
	   if((getch()) == 0x1b)
	   	break;
	   else {
		gotoxy(35,12);
		if( flag){
			puts("VFO A");
			send.cmd.data[0] = OFF;
			flag = FALSE;
		}
		else{
			puts("VFO B"); 
			send.cmd.data[0] = ON;
			flag = TRUE;
		}
                send.cmd.opcode  = SELECT_VFO;
		Send_To_Radio();
	   }
	 }
	}
}
void Copy_Vfo_Mem(void)
{
	char ch_str[3];
	char answer[2];

	short channel = 0;

	printf("Enter Channel to Copy : ");
	scanf("%s",ch_str);
	channel = atoi(ch_str);
	if(channel > 90) {
		printf("\aMust between 0 and 90");
		return;
	}
	send.cmd.opcode  = M_VFO;
	send.cmd.data[0] = channel;
	Send_To_Radio();


}
void Up_Down_Freq(void)
{
	unsigned char c;
	unsigned short step =0;
	printf("Enter (1) for 1 MHZ or (0) 100 KHZ : ");
	scanf("%d",&step);

	send.cmd.data[1] = step;

	puts("Enter <ESC> to quit or '+' or '-'");

	for(;;) {
	 if(kbhit()) {
 	   gotoxy(35,12);
	   switch(getch()) {
	      case 0x1b : return;
	      case '+'  : 
		puts("UP  ");
		send.cmd.data[1] = step;
		send.cmd.opcode  = UP;
		break;			  
	      case '-'  : 
		puts("DOWN");
		send.cmd.data[1] = step;
		send.cmd.opcode  = DOWN;
		break;			  
	   }
	   Send_To_Radio();
	 }
        }

}
void Scan(void)
{
	int	c,i,j;
	int	delay_time = 0;
	int 	step_counter = 0;

	double freq = 0;
	double start_freq = 0;
	double start_khz = 0;
	double end_freq = 0;
	double end_khz = 0;

	char freq_out[20];
	char freq_str[20];


start:
	printf("Enter New Frequency in Mhz: ");
	scanf("%lf",&start_freq);

end:
	printf("Enter END Frequency in Mhz: ");
	scanf("%lf",&end_freq);


	start_khz = start_freq * 100000.0;
	end_khz = end_freq * 100000.0;

	printf("Delay (tenths): ");
	scanf("%d",&delay_time);

	if ((start_khz > 2999999) || (start_khz < 100)){
		printf("out of range -- re-enter\n\a");
		goto start;
	}
	if ((end_khz > 2999999) || (end_khz < 100)){
		printf("out of range -- re-enter\n\a");
		goto end;
	}
	sprintf(freq_str,"%08.0f",start_khz);

	for(i = 0, j = 0; i < 8 ; i += 2,j++)
	    send.cmd.data[j] = Convert_to_BCD(&freq_str[i]);

	send.cmd.opcode = SET_FREQ;		

	Send_To_Radio();

	Set_Modes();

	clrscr();

        gotoxy(20,20);
	puts("Press any key to stop scanning");

	for(freq = start_khz; freq < end_khz + 1.0 ; freq++){


 	 if (kbhit()){
		step_counter = Step_Freq();
		freq = freq + step_counter; 
		gotoxy(20,20);
		clreol();
		printf("Press any key to continue scan or <ESC> to exit");

	 	while (!kbhit());
		c = getch();
		if (c == ESC)
			break;

		gotoxy(20,20);
		clreol();
	        gotoxy(20,20);
		puts("Press any key to stop scanning");
	  }
	  delay(delay_time * 100); 
	  gotoxy(35,12);
	  printf("%2.5f",(freq) / 100000.00);

	  send.cmd.opcode = STEP_FREQ;
	  Send_To_Radio();

	/* start over  */

	  if (freq == end_khz  )
	  {

 	   sprintf(freq_str,"%08.0f",start_khz);
	  
	   for(i = 0, j = 0; i < 8 ; i += 2,j++)	
	    send.cmd.data[j] = Convert_to_BCD(&freq_str[i]);

	   send.cmd.opcode = SET_FREQ;

	   Send_To_Radio();

	   freq = start_khz;

	  }
	}	
}

void Clarifier(void)
{
	puts("Not completed sorry...");
	sleep(5);	
}
void Set_Modes(void)
{
	char answer[3];	
	int mode = 0;

	do{
	 clrscr();
	 fflush(stdin);
	 printf("Enter Mode\n\n");
	 printf("\t 0.  LSB\n");
	 printf("\t 1.  USB\n");
	 printf("\t 2.  CW 2.4k\n");
	 printf("\t 3.  CW 500\n");
	 printf("\t 4.  AM 6k\n");
	 printf("\t 5.  AM 2.4k\n");
	 printf("\t 6.  FM\n");
	 printf("\t 8.  RTTY (LSB) FT-990\n");
	 printf("\t 9.  RTTY (USB) FT-990\n");
	 printf("\t10.  PKT (LSB)  FT-990\n");
	 printf("\t11.  PKT (FM)   FT-990\n");
	 printf("\t12.  Exit\n");
	 printf("\nChoice : ");
	 gets(answer); 
	 mode = atoi(answer); 

	 if(mode > 12) {
		printf("\aMust between 0 and 11");
		delay(2000);
		continue;
	 }
	 send.cmd.opcode  = SET_MODE;
	 send.cmd.data[0] = mode;
	 Send_To_Radio();
	}while(mode != 12);
	
}
void Set_Pacing(void)
{
	unsigned short delay = 0;
	unsigned char answer[2];

	printf("Enter Pacing delay in Milliseconds : ");
	scanf("%d",&delay);

	if((delay > 255)) {
		printf("\aMust between less than 255");
		return;
	}
	printf("Pacing Delay : %d\n",delay);
	printf("okay to set (y/n) : ");
	scanf("%s",answer);

	if((toupper(*answer)) == 'Y') {
	 send.cmd.opcode  = PACING;
	 send.cmd.data[0] = delay;

	 Send_To_Radio();
	}
	
}
void Ptt(void)
{
	Toggle_Value(PTT);
}
void Status_Update(void)
{
	double frequency = 0;

	clrscr();

	send.cmd.opcode  = UPDATE;

	Send_To_Radio();
	
	Read_Status();

	clrscr();

	gotoxy(1,2);
	printf("Split       : %s",r_update.r_update_data.byte_1.bit_0 == 0 ? "Off":"On");

	gotoxy(1,3);
	printf("VFO_B       : %s",r_update.r_update_data.byte_1.bit_1 == 0 ? "Transmit" : "Receive");

	gotoxy(1,4);
	printf("Fast Tuning : %s",r_update.r_update_data.byte_1.bit_2 == 0 ? "Deactive" : "Active");

	gotoxy(1,5);
	printf("Tuner       : %s",r_update.r_update_data.byte_3.bit_6 == 0 ? "Off" : "On");

	gotoxy(1,6);
	printf("Transmision : %s",r_update.r_update_data.byte_1.bit_7 == 0 ? "None" : "In-progress");

	gotoxy(56,2);
	printf("Scanning    : %s",r_update.r_update_data.byte_2.bit_2 == 0 ? "None" : "In-progress");

	gotoxy(56,3);
	printf("Tuning Knob : %s",r_update.r_update_data.byte_2.bit_3 == 0 ? "Unlocked" : "Locked");

	gotoxy(56,4);
	printf("M Tune      : %s",r_update.r_update_data.byte_2.bit_4 == 0 ? "Inactive" : "Active");

	gotoxy(56,5);
	printf("Tuner       : %s",r_update.r_update_data.byte_1.bit_4 == 0 ? "Inactive" : "Tuning");

	gotoxy(56,6);
	if(r_update.r_update_data.byte_2.bit_5 == TRUE)
		printf("Operation   : VFO");
	else if(r_update.r_update_data.byte_2.bit_6 == TRUE)
		printf("Operation   : MEM");
	else if(r_update.r_update_data.byte_2.bit_7 == TRUE)
		printf("Operation   : GEN");
	else
		printf("Operation   : Unknown");

	
	gotoxy(30,8);
	printf("Memory Channel  :  ( %d ) ",
			r_update.r_update_data.mem_ch  + 1 );

/********************************************************************/

	gotoxy(1,9);
        printf("");
	gotoxy(1,11);
	printf("  Current status               VFO A  status              VFO B  status \n");
	printf("  --------------               ---------------            --------------\n\n");

	gotoxy(1,13);
	printf("Filter      :  %#04x",r_update.r_update_data.current.bpf);

	frequency = frequency + ((double)r_update.r_update_data.current.freq1 * 65536);
	frequency = frequency + ((double)r_update.r_update_data.current.freq2 * 256);
	frequency = frequency + (double)r_update.r_update_data.current.freq3;

	gotoxy(1,14);
	printf("Frequency   :  %2.5f",frequency/100000);

	gotoxy(1,15);
	Get_Mode(r_update.r_update_data.current.mode);

	gotoxy(1,16);
	Get_Filter("Filter      ",r_update.r_update_data.current.filter);

	gotoxy(1,17);
	Get_Filter("Last SSB    ",r_update.r_update_data.current.ssb);

	gotoxy(1,18);
	Get_Filter("Last CW     ",r_update.r_update_data.current.cw);

	gotoxy(1,19);
	Get_Filter("Last RTTY   ",r_update.r_update_data.current.rtty);

	gotoxy(1,20);
	Get_Filter("Last PKT    ",r_update.r_update_data.current.pkt);

	gotoxy(1,21);
	printf("Skip Status :  %s\n",r_update.r_update_data.current.skip == 1 ? "True":"False");

/* VFO_A */

	gotoxy(30,13);
	printf("Filter      :  %#04x",r_update.r_update_data.vfo_a.bpf);

	frequency = 0;

	frequency = frequency + ((double)r_update.r_update_data.vfo_a.freq1 * 65536);
	frequency = frequency + ((double)r_update.r_update_data.vfo_a.freq2 * 256);
	frequency = frequency + (double)r_update.r_update_data.vfo_a.freq3;

	gotoxy(30,14);
	printf("Frequency   :  %2.5f",frequency/100000);

	gotoxy(30,15);
	Get_Mode(r_update.r_update_data.vfo_a.mode);

	gotoxy(30,16);
	Get_Filter("Filter      ",r_update.r_update_data.vfo_a.filter);

	gotoxy(30,17);
	Get_Filter("Last SSB    ",r_update.r_update_data.vfo_a.ssb);

	gotoxy(30,18);
	Get_Filter("Last CW     ",r_update.r_update_data.vfo_a.cw);

	gotoxy(30,19);
	Get_Filter("Last RTTY   ",r_update.r_update_data.vfo_a.rtty);

	gotoxy(30,20);
	Get_Filter("Last PKT    ",r_update.r_update_data.vfo_a.pkt);

	gotoxy(30,21);
	printf("Skip Status :  %s\n",r_update.r_update_data.vfo_a.skip == 1 ? "True":"False");

/* VFO_B */



	gotoxy(58,13);
	printf("Filter      :  %#04x",r_update.r_update_data.vfo_b.bpf);

	frequency = 0;

	frequency = frequency + ((double)r_update.r_update_data.vfo_b.freq1 * 65536);
	frequency = frequency + ((double)r_update.r_update_data.vfo_b.freq2 * 256);
	frequency = frequency + (double)r_update.r_update_data.vfo_b.freq3;

	gotoxy(58,14);
	printf("Frequency   :  %2.5f",frequency/100000);

	gotoxy(58,15);
	Get_Mode(r_update.r_update_data.vfo_b.mode);

	gotoxy(58,16);
	Get_Filter("Filter      ",r_update.r_update_data.vfo_b.filter);

	gotoxy(58,17);
	Get_Filter("Last SSB    ",r_update.r_update_data.vfo_b.ssb);

	gotoxy(58,18);
	Get_Filter("Last CW     ",r_update.r_update_data.vfo_b.cw);

	gotoxy(58,19);
	Get_Filter("Last RTTY   ",r_update.r_update_data.vfo_b.rtty);

	gotoxy(58,20);
	Get_Filter("Last PKT    ",r_update.r_update_data.vfo_b.pkt);

	gotoxy(58,21);
	printf("Skip Status :  %s\n",r_update.r_update_data.vfo_b.skip == 1 ? "True":"False");
/********************************************************************/

	gotoxy(1,24);


	Press_Rtn();


}

void Tuner_Toggle(void)
{
	Toggle_Value(ANT_TUNER);
}
void Start_Tuner(void)
{
	send.cmd.opcode  = TUNER_START;

	Send_To_Radio();
	
}
void Rpt_Shift_Offset(void)
{
	int i,j;
	double offset = 0;
	char freq_str[9];
	char direction[2];

	send.cmd.opcode  = RPT_SHIFT;
shift:
	printf("Enter <ESC> to quit or '+'  '-' or '=' :  ");
	gets(direction);

	switch(*direction) {
	      case 0x1b : return;
	      case '+'  : 
		send.cmd.data[0] = 0x02;
		break;			  
	      case '-'  : 
		send.cmd.data[0] = 0x01;
		break;			  
	      case '='  : 
		send.cmd.data[0] = 0x00;
		break;			  
	      default:
		goto shift;
	}

	Send_To_Radio();
	 
offset:
	printf("Enter Offset Frequency : ");
	scanf("%lf",&offset);	

	if(offset > 19999 ) 
	{
		puts("Offset must be less than 20000 khz");
		goto offset;
	}

	sprintf(freq_str,"%06.0f",offset);

	send.cmd.data[0]  = 0;	/* pad and set parameter (P1) */

	for(i = 0, j = 1; i < 6 ; i += 2,j++) 		/* skip parameter P1 */
	    send.cmd.data[j] = Convert_to_BCD(&freq_str[i]);

	send.cmd.opcode  = RPT_OFFSET;

	Send_To_Radio();


}
void Vfo_A_B(void)
{
	send.cmd.opcode  = A_EQUAL_B;

	Send_To_Radio();
	
}
void Bandwidth(void)
{
	char answer[3];	
	short Bandwidth = 0;

	printf("Enter Bandwidth\n\n");
	printf("\t 0.  2.4 khz\n");
	printf("\t 1.  2.0 khz\n");
	printf("\t 2.  500 hz\n");
	printf("\t 3.  250 hz\n");
	printf("\nChoice : ");
	scanf("%d",&Bandwidth);
	if(Bandwidth > 3) {
		printf("\aMust between 0 and 3");
		return;
	}
	send.cmd.opcode  = BANDWIDTH;
	send.cmd.data[0] = BANDWIDTH;
	Send_To_Radio();

	
}
void Mem_Scan_Skip(void)
{
	char ch_str[3];
	char answer[2];

	short hide = 0;
	short channel = 0;

	printf("Enter Channel to Change : ");
	scanf("%s",ch_str);
	channel = atoi(ch_str);
	if((channel < 1) || (channel > 90)) {
		printf("\aMust between 1 and 90");
		return;
	}
	printf("Enter (1) to Hide or (0) to Include ");
	scanf("%d",&hide);

	printf("Channel Selected : %s ",ch_str);

	if (hide)
		printf("Hidden : True\n");		
	else
		printf("Hidden : False\n");	

	printf("okay to update (y/n) : ");
	scanf("%s",answer);

	if((toupper(*answer)) == 'Y') {
		send.cmd.opcode  = MEMORY_SKIP;
		send.cmd.data[0] = channel;
		send.cmd.data[1] = hide;

		Send_To_Radio();
	}
		
}
int Step_Freq(void)
{
	unsigned char c;
	int counter = 0;

	clrscr();

	puts("Enter <ESC> to quit or '+' or '-'");

	for(;;) {
	 if(kbhit()) {
 	   gotoxy(35,12);
	   switch(getch()) {
	      case 0x1b : 
		clrscr();
		return(counter);
	      case '+'  : 
		puts("UP  ");
		send.cmd.opcode  = STEP_FREQ;
		send.cmd.data[0]  = 0;
		counter++;
		break;			  
	      case '-'  : 
		puts("DOWN");
		send.cmd.opcode  = STEP_FREQ;
		send.cmd.data[0]  = 1;
		counter--;
		break;			  
	   }
	   Send_To_Radio();
	 }
        }


}
void Read_Meter(void)
{
	clrscr();
	puts("Presently under beta test for FT-990");

	send.cmd.opcode  = READ_METER;

	Send_To_Radio();
	
	Read_5_Bytes();

	printf("Meter value is : (%d)\n",rcv_cmd.r_meter.meter1);

	if (rcv_cmd.r_meter.meter1 == 0)
		printf("S-Meter reading is S0");
	if (rcv_cmd.r_meter.meter1 > 1 && rcv_cmd.r_meter.meter1 < 10 )
		printf("S-Meter reading is S1");
	if (rcv_cmd.r_meter.meter1 > 10 && rcv_cmd.r_meter.meter1 < 41)
		printf("S-Meter reading is S3");
	if (rcv_cmd.r_meter.meter1 > 40 && rcv_cmd.r_meter.meter1 < 71)
		printf("S-Meter reading is S5");
	if (rcv_cmd.r_meter.meter1 > 70 && rcv_cmd.r_meter.meter1 < 101)
		printf("S-Meter reading is S7");
	if (rcv_cmd.r_meter.meter1 > 100 && rcv_cmd.r_meter.meter1 < 126)
		printf("S-Meter reading is S9");
	if (rcv_cmd.r_meter.meter1 > 125 && rcv_cmd.r_meter.meter1 < 146)
		printf("S-Meter reading is S9 + 10");
	if (rcv_cmd.r_meter.meter1 > 145 && rcv_cmd.r_meter.meter1 < 166)
		printf("S-Meter reading is S9 + 20");
	if (rcv_cmd.r_meter.meter1 > 165 && rcv_cmd.r_meter.meter1 < 186)
		printf("S-Meter reading is S9 + 30");
	if (rcv_cmd.r_meter.meter1 > 185 && rcv_cmd.r_meter.meter1 < 206)
		printf("S-Meter reading is S9 + 40");
	if (rcv_cmd.r_meter.meter1 > 205 && rcv_cmd.r_meter.meter1 < 231)
		printf("S-Meter reading is S9 + 50");
	if (rcv_cmd.r_meter.meter1 > 230 && rcv_cmd.r_meter.meter1 < 251)
		printf("S-Meter reading is S9 + 50");


	Press_Rtn();	
	
}
void Dim_Level(void)
{
	unsigned short i = 0;
	printf("Press any key to toggle <ESC> to exit\n ");
	for(;;) {
	 if(kbhit()) {
	   if((getch()) == 0x1b)
	   	break;
	   else {
		if (i > 0x0d)
			i = 0;
	   	gotoxy(30,12);
	   	printf("Dim Value (%-2d)",i);
		send.cmd.data[0] = i++;
	   }
           send.cmd.opcode  = DIM_LEVEL;
	   Send_To_Radio();
	 }
	}
	
}
void Read_Flags(void)
{
	clrscr();

	send.cmd.opcode  = READ_FLAGS;

	Send_To_Radio();
	
	Read_5_Bytes();

/********Rig type *********/
	printf("                       Model : ");

	switch(rcv_cmd.r_flags.rig1)
	{
	  case 0x10  :	printf("FT-1000\n"); 	break;
	  case 0x09  :	printf("FT-990\n");	break;
	  case 0x08  :	printf("FT-890\n");	break;
	  default    :	printf("\n");		break;
	}

	puts("                       ==============");

/********Byte 1 ***********/

	printf("Split       : %s\n",rcv_cmd.r_flags.byte_1.bit_0 == 0 ? "Off":"On");
	printf("VFO_B       : %s\n",rcv_cmd.r_flags.byte_1.bit_1 == 0 ? "Transmit" : "Receive");
	printf("Fast Tuning : %s\n",rcv_cmd.r_flags.byte_1.bit_2 == 0 ? "Off" : "On");
	printf("CAT         : %s\n",rcv_cmd.r_flags.byte_1.bit_3 == 0 ? "Off" : "On");
	printf("Tuner       : %s\n",rcv_cmd.r_flags.byte_1.bit_4 == 0 ? "Inactive" : "Tuning");
	printf("Keyboard    : %s\n",rcv_cmd.r_flags.byte_1.bit_5 == 0 ? "Idle" : "In-progress");
	printf("Current Mem : %s\n",rcv_cmd.r_flags.byte_1.bit_6 == 0 ? "Not Blank" : "Empty");
	printf("Transmision : %s\n",rcv_cmd.r_flags.byte_1.bit_7 == 0 ? "None" : "In-progress");

/********Byte 2 ***********/

	printf("Scan Paused : %s\n",rcv_cmd.r_flags.byte_2.bit_0 == 0 ? "False" : "True");
	printf("Memory CHK  : %s\n",rcv_cmd.r_flags.byte_2.bit_1 == 0 ? "Off" : "In-progress");
	printf("Scanning    : %s\n",rcv_cmd.r_flags.byte_2.bit_2 == 0 ? "None" : "In-progress");
	printf("Tuning Knob : %s\n",rcv_cmd.r_flags.byte_2.bit_3 == 0 ? "Unlocked" : "Locked");
	printf("M Tune      : %s\n",rcv_cmd.r_flags.byte_2.bit_4 == 0 ? "Inactive" : "Active");

	printf("Operation   : ");

	if(rcv_cmd.r_flags.byte_2.bit_5 == TRUE)
		printf(" VFO ");
	else if(rcv_cmd.r_flags.byte_2.bit_6 == TRUE)
		printf(" MEM ");
	else if(rcv_cmd.r_flags.byte_2.bit_7 == TRUE)
		printf(" GEN ");

	printf("\n");

/********Byte 3 ***********/

	printf("PTT by CAT  : %s\n",rcv_cmd.r_flags.byte_3.bit_0 == 0 ? "False" : "True");
	printf("TX inhibit  : %s\n",rcv_cmd.r_flags.byte_3.bit_1 == 0 ? "Off" : "On");
	printf("Key Timer   : %s\n",rcv_cmd.r_flags.byte_3.bit_2 == 0 ? "Off" : "On");
	printf("M CHK Timer : %s\n",rcv_cmd.r_flags.byte_3.bit_3 == 0 ? "Off" : "On");
	printf("PTT Inhibit : %s\n",rcv_cmd.r_flags.byte_3.bit_4 == 0 ? "Off" : "On");
	printf("TX Monitor  : %s\n",rcv_cmd.r_flags.byte_3.bit_5 == 0 ? "Off" : "On");
	printf("Tuner       : %s\n",rcv_cmd.r_flags.byte_3.bit_6 == 0 ? "Off" : "On");
	printf("Spot        : %s",rcv_cmd.r_flags.byte_3.bit_7 == 0 ? "Off" : "On");

	Press_Rtn();	
	
}
void Press_Rtn(void)
{
	printf("\n                         Press any key to Continue"); 
	while(!kbhit());
	getch();
}
void Read_5_Bytes(void)
{
	short i = 0;
	
	delay(500); 

/*	printf("Characters read : %d\n",rs_inrcvd()); */

	while(rs_inrcvd()) {
 	  if (i < 5)
		rcv_cmd.rcv_data.fill[i++] = rs_getbyt();
	  else
  	        rs_getbyt();
	}
}
void Read_Status(void)
{
	unsigned int i = 0;
	
	printf("Stand-by retrieving information....");

	delay(4000);

	clrscr();

/*	printf("Characters Recvd : %d\n",rs_inrcvd()); */

	while(rs_inrcvd()) {
 	  if (i < UPDATE_DATA_SIZE)
		r_update.r_update_fill.fill[i++] = rs_getbyt();
	  else
  	        rs_getbyt();

	}
}
void Update_Radio()
{
FILE *in;

	int	i,
		j, 
		channel,
		mode;
	
	double real_freq = 0;
	double freq_khz = 0;

	char freq_out[20];
	char freq_str[20];
	char comments[80];
	char tmp[10];

	if((in = fopen("MYCONFIG.DAT","r")) == NULL){
		perror("Error Opening MYCONFIG");
		Press_Rtn();
		return;
	}

/* put radio into vfo mode */

	send.cmd.opcode  = SELECT_VFO;
	Send_To_Radio();

	while( (fscanf(in,"%d %lf %d %s",&channel,&real_freq,&mode,comments)) !=EOF){

/* set mode */

	 switch(mode){
	   case 0 : 	strcpy(tmp,"LSB");
			break;
	   case 1 :	strcpy(tmp,"USB");
			break;
	   case 2 :	strcpy(tmp,"CW 2.4K");
			break;
	   case 3 :	strcpy(tmp,"CW 500");
			break;
	   case 4 :	strcpy(tmp,"AM 6K");
			break;
	   case 5 :	strcpy(tmp,"AM 2.4K");
			break;
	   case 6 :
	   case 7 :	strcpy(tmp,"FM");
			break;
	   case 8 :	strcpy(tmp,"RTTY LSB");
			break;
	   case 9 :	strcpy(tmp,"RTTY USB");
			break;
	   case 10: 	strcpy(tmp,"PKT LSB");
			break;
	   case 11:	strcpy(tmp,"PKT FM");
			break;
	   default:	printf("\amode (%d) illegal on Channel entry %d\n",mode,channel);
			Press_Rtn();
			return;
	 }

	 send.cmd.opcode  = SET_MODE;
	 send.cmd.data[0] = mode;
	 Send_To_Radio();

/* Calculate frequency */

	 freq_khz = real_freq * 100000.0;

	 if ((freq_khz > 2999999) || (freq_khz < 100)){
		printf("(%lf) out of range -- re-enter\n\a",freq_khz);
		Press_Rtn();
		return;
	 }

	 sprintf(freq_str,"%08.0f",freq_khz);

	 send.cmd.opcode = SET_FREQ;		

	 for(i = 0, j = 0; i < 8 ; i += 2,j++)	
	  send.cmd.data[j] = Convert_to_BCD(&freq_str[i]);

/* display update info */

	 printf("Ch : %2d  Freq : %10.5f  Mode : %-8s Desc : %s\n",channel,real_freq,tmp,comments);

/* update radio's frequency */

	 Send_To_Radio();

/* store in defined memory */

	 if(channel > 90){
		printf("\a---> chan (%d) illegal\n",channel);
		Press_Rtn();
		return;
	 }

	 send.cmd.opcode  = VFO_M;
	 send.cmd.data[0] = channel;
	 Send_To_Radio();

        }

	Press_Rtn();
        fclose(in);
 
}
void Flush_Inbuffer(void)
{
	while(rs_inrcvd())
 	   rs_getbyt(); 
}
void Scan_File(void)
{
FILE *in;

	int	c= 0,
		i= 0,
		j= 0, 
		l= 0,
		m= 0,
		time_delay = 0,	
		mode[255];

	int loop =0;
	double real_freq[255];
	double freq_khz[255];

	char freq_out[20];
	char freq_str[20];
	char tmp[10];
	char comments[255][80];
	char filename[64];

	printf("Files available for scanning\n");
	printf("----------------------------\n");

	ScanDir();

	printf("\n\nEnter Filename : ");
	gets(filename);

	if (*filename == '\0')
		return;

	if((in = fopen(filename,"rb")) == NULL){
		perror("Error Opening specified file");
		Press_Rtn();
		return;
	}

	printf("Enter scan delay in Seconds : ");
	scanf("%d",&time_delay);
	time_delay *=  1000;

/* put radio into vfo mode */

	send.cmd.opcode  = SELECT_VFO;
	Send_To_Radio();

	while( (fscanf(in,"%lf %d %s",&real_freq[i],&mode[i],comments[i])) !=EOF)
	{
		if (i > 255){
		   puts("file has to many entries -- must be less than 256");
		   Press_Rtn();
		   return;
		}
		i++;
	}

	for(j = 0 ; j < i ; j++)
		freq_khz[j] = real_freq[j] * 100000.0;
	
/* start scanning */

	clrscr();

	gotoxy(20,20);

	puts("Press any key to stop scanning");

	for(loop = 0 ; loop < j ; loop++){	

	 send.cmd.opcode  = SET_MODE;
	 send.cmd.data[0] = mode[loop];
	 Send_To_Radio();

/* Calculate frequency */

	 sprintf(freq_str,"%08.0f",freq_khz[loop]);

	 send.cmd.opcode = SET_FREQ;		

	 for(l = 0, m = 0; l < 8 ; l += 2,m++)	
	  send.cmd.data[m] = Convert_to_BCD(&freq_str[l]);

/* update radio's frequency */

	 gotoxy(20,13);	
	 clreol();
	 printf("Freq %lf  Desc : %s\n",real_freq[loop],comments[loop]);

	 Send_To_Radio();

	 if(loop == j - 1)
	  loop= -1;		/* reset and start over */

	 delay(time_delay);

	 if (kbhit()){
		gotoxy(20,20);
		clreol();
		printf("Press any key to continue scan or <ESC> to exit");
		c = getch();
		if (c == ESC)
			break;

	 	while (!kbhit());
		c = getch();
		if (c == ESC)
			break;

		gotoxy(20,20);
		clreol();
	 }

        }

        fclose(in);
}

void Toggle_Value(command)
{
	short flag = 0;
	printf("Press any key to toggle <ESC> to exit\n ");
	for(;;) {
	 if(kbhit()) {
	   if((getch()) == 0x1b)
	   	break;
	   else {
		gotoxy(35,12);
		if( flag){
			puts("OFF");
			send.cmd.data[0] = OFF;
			flag = FALSE;
		}
		else{
			puts("ON "); 
			send.cmd.data[0] = ON;
			flag = TRUE;
		}
                send.cmd.opcode  = command;
		Send_To_Radio();
	   }
	 }
	}
}
void ScanDir(void)
{
	struct ffblk ffblk;

	int done=0;

	done = findfirst("*.dat",&ffblk,0);

	while(!done)
	{
	      if(strstr(ffblk.ff_name,"MYCONFIG.DAT") == NULL) 
	        printf("%s\n",ffblk.ff_name);
	      done = findnext(&ffblk);

	}	      

}
	
void Get_Mode(tmp)
{
	switch(tmp)
	{
		case 0 : printf("Mode        :  LSB");break;
		case 1 : printf("Mode        :  USB");break;
		case 2 : printf("Mode        :  CW");break;
		case 3 : printf("Mode        :  AM");break;
		case 4 : printf("Mode        :  FM");break;
		case 5 : printf("Mode        :  RTTY");break;
		case 6 : printf("Mode        :  PKT");break;
	}

}

void Get_Filter(char *desc,int tmp)
{
	switch(tmp)
	{
		case 0 : printf("%12s:  2.4k",desc);break;
		case 1 : printf("%12s:  2.0k",desc);break;
		case 2 : printf("%12s:  500",desc);break;
		case 3 : printf("%12s:  250",desc);break;
		case 4 : printf("%12s:  6k",desc);break;
		default: printf("%12s:  UNKNOWN",desc);break;
	}
}
void Disp_Mem(void)
{

#define	MEM_OFFSET	36	/* starting position of VFO_B */

/*	struct BYTE_16 memory_channel; */

	struct BYTE_16 *memptr;

	int offset = 0;
	int channel = 0;

	double frequency = 0;

	clrscr();

channel:
	printf("Enter Memory Channel to review : ");
	scanf("%d",&channel);

	if ( (channel == 0) || (channel > 90) )
	{
		printf("out-of-range\n");
		sleep(2);	
		goto channel;
	}

	send.cmd.opcode  = UPDATE;

	Send_To_Radio();
	
	Read_Status();

	clrscr();

	offset = MEM_OFFSET + (channel  * 16); 
	
/*	memcpy(&memory_channel , &r_update.r_update_fill.fill[offset] , 16); */

	memptr = (struct BYTE_16 *)&r_update.r_update_fill.fill[offset];

	gotoxy(25,3);

	printf("Memory Channel  :  ( %d ) \n",channel);

/********************************************************************/

	gotoxy(28,5);
	printf("  Current status\n");

	gotoxy(28,6);
	printf("  --------------\n");

	gotoxy(28,8);
	printf("Filter      :  %#04x\r\n",memptr->bpf);


	frequency = frequency + ((double)memptr->freq1 * 65536);
	frequency = frequency + ((double)memptr->freq2 * 256);
	frequency = frequency + (double)memptr->freq3;

	gotoxy(28,9);
	printf("Frequency   :  %2.5f\r\n",frequency/100000);

	gotoxy(28,10);
	Get_Mode(memptr->mode);

	gotoxy(28,11);
	Get_Filter("Filter      ",memptr->filter);

	gotoxy(28,12);
	Get_Filter("Last SSB    ",memptr->ssb);

	gotoxy(28,13);
	Get_Filter("Last CW     ",memptr->cw);

	gotoxy(28,14);
	Get_Filter("Last RTTY   ",memptr->rtty);

	gotoxy(28,15);
	Get_Filter("Last PKT    ",memptr->pkt);

	gotoxy(28,16);
	printf("Skip Status :  %s\r\n",memptr->skip == 1 ? "True":"False");

	gotoxy(1,24);


	Press_Rtn();

}