/**********************************************************
*                 FT990.h                                 *
*   
*   This include file provides all the commands and       *
*   return Record format from all commands                *
**********************************************************/

/*   Date	Version		Author		Description
    --------	-------		----------	--------------------------
    06-24-92    1.00		Robert Cartier	Program Creation

*/

/* define Commands */

#define SPLIT		0x01	/* switch split vfo operation on/1 off/0 */
#define RECALL_MEM	0x02    /* recalls memory number channel 01 - 5ah */
#define VFO_M		0x03    /* copy display to memory channel */
#define LOCK_DIAL	0x04	/* lock vfo knob */
#define SELECT_VFO	0x05	/* select a/b vfo */
#define M_VFO		0x06	/* copy memory channel t last used vfo */
#define UP		0x07	/* step current display (0=+100khz) (1=+1mhz)*/
#define DOWN		0x08	/* step current display (0=-100khz) (1=-1mhz)*/
#define CLARFIER	0x09	/* see manual for tx/rx clarifier info */
#define SET_FREQ	0x0a	/* enter new op freq in BCD format */
#define SET_MODE	0x0c	/* set op mode LSB/USB/CW/AM/FM/RTTY/PKT */
#define PACING		0x0e	/* add delay to character pacing */
#define PTT		0x0f	/* transmitter on/1 off/0  */
#define UPDATE		0x10	/* instructs radio to return status */
#define ANT_TUNER	0x81	/* turn on antenna tuner */
#define TUNER_START	0x82	/* start antenna tuner */
#define RPT_SHIFT	0x84	/* select repeater offset sinplex/+/- */
#define A_EQUAL_B	0x85	/* copy displayed vfo to other vfo */
#define BANDWIDTH	0x8c	/* select bandwidth 250/500/2.2k/2.4k */
#define MEMORY_SKIP	0x8d	/* skip specified mem channel during scan */
#define STEP_FREQ	0x8e	/* step operating freq up/down */
#define READ_METER	0xf7	/* read meter depedent on position */
#define DIM_LEVEL	0xf8	/* dim level of amber display */
#define RPT_OFFSET	0xf9	/* repeater offset in BCD */
#define READ_FLAGS	0xfa	/* read 24 s-bit status flags (5 bytes) */

#define ON		0x01
#define TRUE		0x01

#define OFF		0x00
#define FALSE		0x00

#define COMMAND_SIZE	0x05	/* maximum characters sent for command */
#define UPDATE_DATA_SIZE 1492   /* maximum update response */

typedef unsigned char	BYTE;	/* 8 bits  */
typedef unsigned int    WORD;	/* 16 bits */

typedef struct BYTE_MAP{
    unsigned	bit_0 : 1,
		bit_1 : 1,
		bit_2 : 1,
		bit_3 : 1,
		bit_4 : 1,
		bit_5 : 1,
		bit_6 : 1,
		bit_7 : 1;
}BYTE_MAP;

typedef struct WORD_MAP{
    unsigned	bit_0 : 1,
		bit_1 : 1,
		bit_2 : 1,
		bit_3 : 1,
		bit_4 : 1,
		bit_5 : 1,
		bit_6 : 1,
		bit_7 : 1,
		bit_8 : 1,
		bit_9 : 1,
		bit_10: 1,
		bit_11: 1,
		bit_12: 1,
		bit_13: 1,
		bit_14: 1,
		bit_15: 1;
}WORD_MAP;

struct send_command{
    BYTE 	opcode,
		data[4];
}cmd;

struct send_fill{
    BYTE	fill[COMMAND_SIZE];

}cmd_fill;

union send_cmd{ 
	struct	send_command	cmd;
	struct	send_fill	cmd_fill;
}send;


struct rcv_flags{
	BYTE_MAP	byte_1;
	BYTE_MAP	byte_2;
	BYTE_MAP	byte_3;
	BYTE		pad1;
	BYTE		pad2;

}r_flags;

struct read_meter{
    BYTE	meter1,
		meter2,
		meter3,
		meter4,
		pad;
}r_meter;

struct receive_data{
    BYTE 	fill[5];
}r_data;

union receive_command{
	struct	rcv_flags	r_flags;
	struct	read_meter	r_meter;
	struct  receive_data	rcv_data;
}rcv_cmd;

struct receive_update_data{
    BYTE_MAP	byte_1,
		byte_2,
		byte_3;
    BYTE	mem_ch,
    		current[16],
		vfo_a[16],
		vfo_b[16],
		mem1[16],
		mem2[16],
		mem3[16],
		mem4[16],
		mem5[16],
		mem6[16],
		mem7[16],
		mem8[16],
		mem9[16],
		mem10[16],
		mem11[16],
		mem12[16],
		mem13[16],
		mem14[16],
		mem15[16],
		mem16[16],
		mem17[16],
		mem18[16],
		mem19[16],
		mem20[16],
		mem21[16],
		mem22[16],
		mem23[16],
		mem24[16],
		mem25[16],
		mem26[16],
		mem27[16],
		mem28[16],
		mem29[16],
		mem30[16],
		mem31[16],
		mem32[16],
		mem33[16],
		mem34[16],
		mem35[16],
		mem36[16],
		mem37[16],
		mem38[16],
		mem39[16],
		mem40[16],
		mem41[16],
		mem42[16],
		mem43[16],
		mem44[16],
		mem45[16],
		mem46[16],
		mem47[16],
		mem48[16],
		mem49[16],
		mem50[16],
		mem51[16],
		mem52[16],
		mem53[16],
		mem54[16],
		mem55[16],
		mem56[16],
		mem57[16],
		mem58[16],
		mem59[16],
		mem60[16],
		mem61[16],
		mem62[16],
		mem63[16],
		mem64[16],
		mem65[16],
		mem66[16],
		mem67[16],
		mem68[16],
		mem69[16],
		mem70[16],
		mem71[16],
		mem72[16],
		mem73[16],
		mem74[16],
		mem75[16],
		mem76[16],
		mem77[16],
		mem78[16],
		mem79[16],
		mem80[16],
		mem81[16],
		mem82[16],
		mem83[16],
		mem84[16],
		mem85[16],
		mem86[16],
		mem87[16],
		mem88[16],
		mem89[16],
		mem90[16];
}r_update_data;

struct receive_update_fill{
    BYTE	fill[1492];
}r_update_fill;

union rcv_update_data{
	struct	receive_update_data	r_update_data;
	struct	receive_update_fill	r_update_fill;
}r_update;
