; Test processor type. Origins of this code unknown - modified for
; Turbo C by KA9Q 5 Feb 90

        .MODEL  LARGE,C
        LOCALS
        %MACS
        .LALL

p_80386   equ   7
p_80286   equ   6
p_80186   equ   5
p_80188   equ   4
p_v30     equ   3
p_v20     equ   2
p_8086    equ   1
p_8088    equ   0

        .CODE

;-- call from C : int getproc( void );
;-- gives the type of processor back , see equates
        public getproc
getproc proc

        pushf            ; save flags

        ;-- check 80386/80286
        xor  ax,ax
        push ax
        popf            ; get it as flags
        pushf
        pop  ax         ; and get back as AX again
        and  ax,0f000h  ; mask off high nibble
        cmp  ax,0f000h
        je   forget386  ; if true, no 80386 or 80286

        ;-- check if 80286 or 80386
        mov  dl,p_80286
        mov  ax,07000h
        push ax
        popf
        pushf
        pop  ax
        and  ax,07000h  ; mask off
        je   p_end      ; if bits 12-14 = 0 -> 80286
        inc  dl         ; no , 80386
        jmp  p_end

        ;-- check 80186/80188
forget386 label near
        mov  dl,p_80188
        mov  al,0ffh
        mov  cl,021h
        shr  al,cl
        jne  t88_86

        ;-- check V20/V30
        mov  dl,p_v20
        sti
        push si
        mov  si,0
        mov  cx,0ffffh          ; read complete segment
        rep  lods byte ptr es:[si]      ; REP with segment override works
                                ; only with V20 and V30
        pop  si
        or   cx,cx              ; check if whole segment read
        je   t88_86             ; jip ! -> V20 or V30

        mov  dl,p_8088          ; no should be 8088 or 8086

        ;-- check 8088/8086 or V20/V30
t88_86  label near
        push cs                 ; swap cs and es
        pop  es
        std
        mov  di,offset q_end
        mov  al,0fbh            ; instruction code for STI
        mov  cx,3
        cli
        rep  stosb
        cld
        nop
        nop
        nop

        inc  dx
        nop
q_end:  sti

p_end   label near          ; tests complete
        popf
        xor  dh,dh
        mov  ax,dx          ; processorcode is return value
        ret

getproc  endp
        end

