#ifndef _NNTP_H
#define _NNTP_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifndef _DOS_H
#include <dos.h>
#endif

#ifndef _TIME_H
#include <time.h>
#endif

#ifndef _TIMER_H
#include "timer.h"
#endif

#ifndef _SMTP_H			/* needed for header strings */
#include "smtp.h"
#endif

/****************************************************************/
/*                                                              */
/*      Compiler option for enhanced NNTP functions (DG1ZX)     */
/*                                                              */
/*      - nntp create <newsgroup >  ==> create new newsgroup    */
/*  - nntp config auto <on|off> ==> server will create          */
/*                              automaticly new newsgroup       */
/*                                                              */
/****************************************************************/
#define NNTPENH


/****************************************************************/
/*                                                              */
/*         Compiler option for posting allowed (DG1ZX)          */
/*                                                              */
/****************************************************************/
#define POST_ENBL


/************************************************************************/
/*                                                                      */
/*   Compiler option for XHDR command (DG1ZX)                           */
/*                                                                      */
/*   syntax: XHDR header [articlerange]                                 */
/*                                                                      */
/*   header is a case-insensitive header field, minus any colons.       */
/*   articlerange is one of:                                            */
/*   - an article number                                                */
/*   - an article number followed by a dash to indicate all following   */
/*   - an article number followed by a dash followed by another article */
/*     number                                                           */
/*                                                                      */
/*   e.g.,                                                              */
/*                                                                      */
/*   XHDR subject                 retrieve subject of current article   */
/*   XHDR subject 5589-6325       retrieve subject of arts 5589 to 6325 */
/*   XHDR subject 5589-           retrieve subject of arts 5589 and up  */
/*   XHDR subject 5589            retrieve subject of art 5589 only     */
/*                                                                      */
/*   This command is an extension and not included in RFC 977.          */
/************************************************************************/
#define XHEADER

#define LineLen 512

struct article {
    char *group;
    char *id;
    char *path;
    unsigned number;
    unsigned tmpu;
    struct article *next;
};
#define NULLARTICLE (struct article *)0

struct post {
	char *host;
    char *user;
    char *reply;
    char *sig;
    char *organ;
	char *fullname;
};
#define NULLPOST (struct post *)0

struct head {
    char *from;
    char *reply_to;
    char *subject;
    char *id;
};
#define NULLHEAD (struct head *)0

struct g_list {
    char *str;
    struct g_list *next;
};
#define NULLG (struct g_list *)0

struct nntpserv {
    int s;
    unsigned  first;
    unsigned  last;
    unsigned  pointer;
    unsigned  hold_i;

	char *buf;
    char *newnews;
    char *path;
    char *id;

	int states;
#define USER	0
#define N_SLAVE	1
#define N_DEBUG	2
#define CLOSED	4
	int32 unixtime;
	int32 ftime;
    struct date *datest;
    struct time *timest;

    struct article *ap;
};

extern char NEol[];

int	nntp1 	__ARGS((int argc, char *argv[], void *p));
int nntp0 	__ARGS((int argc, char *argv[], void *p));
int donntp 	__ARGS((int argc, char *argv[], void *p));
int nnGpost __ARGS((FILE *data,char *from,struct list *le));

/* in nntpcli.c */
extern char noart[], artmsg[], retrieve[], badsyntax[];
extern int LzwActive;
extern int16 Nntpquiet;
extern struct post Post;
extern unsigned short Nntpmaxcli;
#ifdef NNTPENH
extern int fullauto;
#endif
#ifdef POST_ENBL
extern int postingok;
#endif

/* in nntpserv.c */
void nntpserv __ARGS((int s,void *unused,void *p));

/* in nntpsubr.c */
extern int Filecheck;
int art_ret __ARGS((struct nntpserv *mp,int flag));
int doarticle __ARGS((struct nntpserv *mp,int flag,char *hname));
int check_system __ARGS((void));
int get_id __ARGS((struct nntpserv *mp));
int get_path __ARGS((struct nntpserv *mp));
FILE *open_message __ARGS((struct nntpserv *mp));
int recv_file __ARGS((FILE *fp,int s));
int check_article __ARGS((char *id));
int xfer_article2 __ARGS((FILE *fp,struct nntpserv *mp));
int check_blank __ARGS((char *bp));
int get_path2 __ARGS((struct article *ap));
int32 make_nntime __ARGS((struct date *d,struct time *t,char *str));
int newnews __ARGS((struct nntpserv *mp,FILE *f));
int garbled __ARGS((FILE *f));

#ifdef NNTPENH
int make_path __ARGS((char *group,int w));
#endif

#endif /* _NNTP_H */
