#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#include "global.h"


#define LEN_BID         12
#define NLEN_BID		12+1

#define LEN_SUBJECT     50
#define NLEN_SUBJECT	50

#define LEN				40
#define NLEN			40


#define NORMAL		0
#define DELETED		1
#define PRIVATE		2
#define BULLETIN	4
#define NEWS		8

struct old_index {
  int32 size;
  int32 date;
  int32 mesg;
  char lifetime_h;
  char lifetime_l;
  char flag;
  char bid[LEN_BID];
  char subject[LEN_SUBJECT];
  char to[LEN];
  char at[LEN];
  char from[LEN];
  char from_at[LEN];
};

struct new_index {
  int32 size;
  int32 date;
  int32 mesg;
  char lifetime_h;
  char lifetime_l;
  char flag;
  char bid[NLEN_BID];
  char subject[NLEN_SUBJECT];
  char to[NLEN];
  char at[NLEN];
  char from[NLEN];
  char from_at[NLEN];
};


main()
{
	int fdoindex = -1;
	int fdnindex = -1;
	unsigned uoindex_len = sizeof(struct old_index);
	unsigned unindex_len = sizeof(struct new_index);

	struct old_index oindex;
	struct new_index nindex;


	if((fdoindex = open("index",O_RDWR | O_CREAT | O_BINARY,S_IREAD | S_IWRITE)) < 1) {
		exit(1);
	}
	if((fdnindex = open("nindex",O_RDWR | O_CREAT | O_BINARY,S_IREAD | S_IWRITE)) < 1) {
		exit(1);
	}
	lseek(fdoindex,0,SEEK_SET);

	while(read(fdoindex,&oindex,uoindex_len) == uoindex_len) {
		if(oindex.flag & DELETED) {
			continue;
		}
		memset(&nindex,0,unindex_len);

		nindex.size = oindex.size;
		nindex.date = oindex.date;
		nindex.mesg = oindex.mesg;
		nindex.lifetime_h = oindex.lifetime_h;
		nindex.lifetime_l = oindex.lifetime_l;
		nindex.flag = oindex.flag;
		strncpy(nindex.bid,oindex.bid,min(LEN_BID,NLEN_BID));
		strncpy(nindex.subject,oindex.subject,min(LEN_SUBJECT,NLEN_SUBJECT));
		strncpy(nindex.to,oindex.to,min(LEN,NLEN));
		strncpy(nindex.at,oindex.at,min(LEN,NLEN));
		strncpy(nindex.from,oindex.from,min(LEN,NLEN));
		strncpy(nindex.from_at,oindex.from_at,min(LEN,NLEN));

		if(write(fdnindex,&nindex,unindex_len) != unindex_len) {
			close(fdoindex);
			close(fdnindex);
			exit(1);
		}
	}
	close(fdnindex);
	close(fdoindex);
	exit(0);
	return 0;
}