#ifndef	_SMTP_H
#define	_SMTP_H

/* Header types */
#define	NOHEADER 		-1
#define APPROVED		0
#define	FROM			1
#define	TO				2
#define	DATE			3
#define	MSGID			4
#define	SUBJECT			5
#define	RECEIVED		6
#define	SENDER			7
#define	REPLYTO			8
#define STATUS			9
#define BBSTYPE			10
#define XFORWARD		11
#define CC				12
#define RRECEIPT		13
#define APPARTO			14
#define ERRORSTO		15
#define ORGANIZATION	16
#define BULLID			17
#define EXPIRE			18
#define PATH			19
#define NEWSGROUPS		20
#define DISTRIBUTION	21
#define	UNKNOWN			22

#define MAXSESSIONS	10		/* most connections allowed */
#define JOBNAME		13		/* max size of a job name with null */
#define	LINELEN		256

/* types of address used by smtp in an address list */
typedef enum {
	BADADDR 	= 0,
	LOCAL		= 1,
	DOMAIN		= 2,
	NNTP_GATE	= 3,
} Mailtype;

/* a list entry */
struct list {
	struct list *next;
	char *val;
	Mailtype type;
};
#define	NULLLIST	(struct list *)0

/* Per-session control block  used by smtp server */
struct smtpserv {
	int s;						/* the socket for this connection */
	int states;					/* status of server */
#define OK		0
#define PROMPT	1
#define CLOSED	4
	char *buf;					/* input line buffer */
	char *system;				/* Name of remote system */
	char *from;					/* sender address */
	struct list *to;			/* Linked list of recipients */
	FILE *data;					/* Temporary input file pointer */
};
#define	NULLSMTPSV	(struct smtpserv *)0

/* used by smtpcli as a queue entry for a single message */
struct smtp_job {
	struct smtp_job *next;		/* pointer to next mail job for this system */
	char jobname[9];			/* the prefix of the job file name */
	long len;                   /* length of file */
	char *from;					/* address of sender */
	struct list *to;			/* Linked list of recipients */
};
#define NULLJOB		(struct smtp_job *)0

/* control structure used by an smtp client session */
struct smtpcli {
	struct smtpcli *next;
	int	s;						/* connection socket */
	int lock;					/* In use */
	int32 ipdest;				/* address of forwarding system */
	char *destname;				/* domain address of forwarding system */
	char *wname;				/* name of workfile */
	char *tname;				/* name of data file */
	char *buf;					/* Output buffer */
	char cnt;					/* Length of input buffer */
	FILE *tfile;
	struct smtp_job *jobq;
	struct list *errlog;
};
#define	NULLSMTPCLI	(struct smtpcli *)0

/* smtp server routing mode */
#define ROUTE	0
#define	QUEUE	1

/* smtp server delivering flags */
#define BBS		1
#define MAIL	2
#define NEWS	4

extern char *Days[], *Months[], *Hdrs[];

extern int Smtpmode, Smtplzw, Smtpbbs;
extern int16 Smtpquiet;
extern int32 Gateway;

/* In smtpserv.c: */
void smtpserv __ARGS((int s,void *unused,void *p));
struct list *addlist __ARGS((struct list **head,char *val,int type));

/* In smtpcli.c: */
int smtptick __ARGS((void *t));

/* in smtpsubr.c */
int htype __ARGS((char *s));
int32 mailroute __ARGS((char *dest));
void del_list __ARGS((struct list *lp));
char *rfc822_date __ARGS((int32 *t));
long get_msgid __ARGS((void));
char *getname __ARGS((char *cp));
int validate_address __ARGS((char *s));
struct list *expandalias __ARGS((struct list **head,char *user));
int mailit __ARGS((FILE *data,char *from,struct list *tolist));
int mdaemon __ARGS((FILE *data,char *to,struct list *lp,int bounce));

#endif	/* _SMTP_H */

