#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <conio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "trace.h"
#include "pktdrvr.h"
#include "commands.h"
#include "session.h"
#include "files.h"

#define ASCIIBUF    80
#define HEXBUF      16

void
dump(struct iface *iface,int direction,unsigned type,struct mbuf *bp)
{
	int16 size;
	struct mbuf *tbp;
    char *cp;
	void (*func) __ARGS((FILE *,struct mbuf **,int));

	if(iface == NULLIF) {
		return;
	}
	switch(direction) {
	case IF_TRACE_IN:
		iface->lastrecv = secclock();
		iface->rawrecvcnt++;
		break;
	case IF_TRACE_OUT:
		iface->lastsent = secclock();
		iface->rawsndcnt++;
		break;
	}
	if((Current != Trace && iface->trfile == NULLCHAR)
	  || (iface->trace & direction) == 0) {
		/* Nothing to trace */
		return;
	}
	if(direction == IF_TRACE_IN
	  && (iface->trace & IF_TRACE_NOBC)
	  && (Tracef[type].addrtest != NULLFP)
	  && (*Tracef[type].addrtest)(iface,bp) == 0) {
		return;
	}
    cp = ctime(&currtime);
    cp[24] = '\0';
    
	trprintf(iface->trfp,"%s %s (%s):\n",
        iface->name,(direction & IF_TRACE_OUT) ? "sent" : "recv",cp);

	if(bp == NULLBUF || (size = len_p(bp)) == 0) {
		trprintf(iface->trfp,"empty packet\n");
		return;
	}
	dup_p(&tbp,bp,0,size);

	if(tbp != NULLBUF) {
		if(iface->trace & IF_TRACE_RAW) {
			goto jp;
		}
		if((func = (type < NCLASS) ? Tracef[type].tracef : NULLVFP) != NULLVFP) {
			textattr(WHITE);
			(*func)(iface->trfp,&tbp,1);
			textattr(LIGHTGRAY);

			if(iface->trace & IF_TRACE_HEX) {
                char buf[HEXBUF];
				int len, address = 0;
jp:
				free_p(tbp);
				dup_p(&tbp,bp,0,len_p(bp));

				/* Dump entire packet in hex/ascii */
                while((len = pullup(&tbp,buf,HEXBUF)) != 0) {
					static char hex[] = "0123456789abcdef";
					char line[81], *cp = line, *aptr = &line[6], *cptr = &line[55], c;

					memset(line,' ',sizeof(line));

					*cp++ = hex[hinibble(hibyte(address))];
					*cp++ = hex[lonibble(hibyte(address))];
					*cp++ = hex[hinibble(lobyte(address))];
					*cp   = hex[lonibble(lobyte(address))];

					address += len;
					cp = buf;

					while(len-- != 0) {
						c = *cp++;
						*aptr++ = hex[hinibble(uchar(c))];
						*aptr   = hex[lonibble(uchar(c))];
						aptr += 2;
						c &= 0x7f;
						*cptr++ = isprint(uchar(c)) ? c : '.';
					}
					*cptr++ = '\n';
					*cptr   = '\0';

					trprintf(iface->trfp,"%s",line);
				}
			} else if(iface->trace & IF_TRACE_ASCII) {
				/* Dump only data portion of packet in ascii */
                char buf[ASCIIBUF];
				int len;
				unsigned char c = 13;

                while((len = pullup(&tbp,buf,ASCIIBUF)) != 0) {
					char *cp = buf;
					char *cpw = buf;
					while(len-- != 0) {
						switch(c = *cp) {
						default:
							if(c >= 0x20) {
								*cp++ = c;
							} else {
								*cp++ = '.';
							}
							break;
						case '\n':
						case '\r':
							*cp++ = '\0';
							trprintf(iface->trfp,"%s\n",cpw);

							if(*cp) {
								cpw = cp;

								if((c == '\r' && *cpw == '\n')
								  || (c == '\n' && *cpw == '\r')) {
									cpw++;
									cp++;
									c = 13;
									len--;
								}
							} else {
							  *cpw = '\0';
							}
							break;
						}
					}
					if(*cpw) {
						*cp = '\0';
						trprintf(iface->trfp,"%s",cpw);
					}
				}
				if(c != 13) {
					trprintf(iface->trfp,"\n");
				}
			}
		}
		free_p(tbp);
	} else {
		trprintf(iface->trfp,"No space!\n");
	}
}

static void near
d_trace(struct iface *ifp)
{
	tprintf("%s: ",ifp->name);

	if(ifp->port) {
	  tputs("Trace on master iface only");
	} else {
		if(ifp->trace & (IF_TRACE_IN | IF_TRACE_OUT | IF_TRACE_RAW)) {
			if(ifp->trace & IF_TRACE_IN) {
				tputs("input ");
			}
			if(ifp->trace & IF_TRACE_OUT) {
				tputs("output ");
			}
			if(ifp->trace & IF_TRACE_NOBC) {
				tputs("- no broadcasts ");
			}
			if(ifp->trace & IF_TRACE_HEX) {
				tputs("(Hex/ASCII dump) ");
			} else if(ifp->trace & IF_TRACE_ASCII) {
				tputs("(ASCII dump) ");
			} else {
				tputs("(headers only) ");
			}
			if(ifp->trace & IF_TRACE_RAW) {
				tputs("Raw output ");
			}
			if(ifp->trfile != NULLCHAR) {
				tprintf("trace file: %s",ifp->trfile);
			}
		} else {
			tputs("tracing off");
		}
	}
	tputs("\n");
}

/* Modify or displace interface trace flags */
int
dotrace(int argc,char **argv,void *p)
{
	struct iface *ifp;

	if(argc < 2){
		for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next) {
			d_trace(ifp);
		}
	} else {
		if((ifp = if_lookup(argv[1])) == NULLIF){
			tprintf(Badif,argv[1]);
			return 1;
		}
		if(argc == 2) {
			d_trace(ifp);
			return 0;
		}
		if(argc >= 3) {
			ifp->trace = htoi(argv[2]);
		}
		if(ifp->trfp != NULLFILE) {
			Fclose(ifp->trfp);
		}
		ifp->trfp = NULLFILE;

		if(ifp->trfile != NULLCHAR) {
			xfree(ifp->trfile);
		}
		ifp->trfile = NULLCHAR;

		if(argc >= 4){
			if((ifp->trfp = Fopen(argv[3],APPEND_TEXT,0,1)) != NULLFILE) {
				ifp->trfile = strxdup(argv[3]);
			}
		}
	}
	return 0;
}

/* shut down all trace files */
void
shuttrace(void)
{
	struct iface *ifp;

	for(ifp = Ifaces; ifp != NULLIF; ifp = ifp->next) {
		if(ifp->trfp != NULLFILE) {
			Fclose(ifp->trfp);
		}
		if(ifp->trfile != NULLCHAR) {
			xfree(ifp->trfile);
		}
		ifp->trfile = NULLCHAR;
		ifp->trfp = NULLFILE;
	}
}

void
trprintf(FILE *fp,char *fmt,...)
{
	va_list ap;
	char tmp[LINELEN];

	va_start(ap,fmt);
	vsprintf(tmp,fmt,ap);
	va_end(ap);

	if(Current == Trace) {
		if(cputs(tmp) == '\n') {
			cputs("\r");
		}
	}
	if(fp != NULLFILE) {
		fputs(tmp,fp);
	}
}
