@echo off

rem XQAZ.BAT v1.5 by Robert Rothenburg Walking-Owl (for use with QAZ v3.xx)

rem XQAZ is a demo utility that uses QAZ to identify an archive format
rem to either view, extract, test or scan archives recognized.

rem This could use a lot of work, and when used with a more powerful
rem batch language or with external programs written in C or Pascal,
rem you can do some amazing things.

if exist xqaz.$$$ erase xqaz.$$$

if exist %2 goto archive_exists
echo * Error: file not found (%2)
goto usage

:archive_exists
set vcmd=v
set ecmd=e
set tcmd=t
set scmd=s
set cmd=%1
if %cmd% == %vcmd%  goto view_archive
if %cmd% == %ecmd% goto identify
if %cmd% == %tcmd% goto identify
if %cmd% == %scmd% goto identify
echo * Error: unrecognized command (%cmd%)
goto usage

:view_archive
qaz %2 -cm42 -cl61 -wl79 -dfs0  -sr2 -ls -vn+22oar_dts -ffb > xqaz.$$$
goto done

rem possible modifications are to add the -r option, and if the archive
rem turns out to be a format which QAZ cannot list (such as UC2), then
rem to call the appropriate viewing function instead (UC2 V %2 %3).

:identify
qaz %2 -ri -mi -ff -cm42 > xqaz.$$$
if not %cmd% == %scmd% goto check
set scmd=%tcmd%
set cmd=%ecmd%

:check
if errorlevel 128 goto graphics
if errorlevel 68 goto xunrar
if errorlevel 67 goto xundef
if errorlevel 66 goto xunmd
if errorlevel 65 goto xunshrink
if errorlevel 64 goto xundef
if errorlevel 63 goto xlim
if errorlevel 59 goto xundef
if errorlevel 58 goto xbinhex
if errorlevel 57 goto xlharc
if errorlevel 56 goto xundef
if errorlevel 55 goto xcodec
if errorlevel 54 goto xundef
if errorlevel 53 goto xtar
if errorlevel 52 goto xproprietary
if errorlevel 51 goto xzoo
if errorlevel 50 goto xzip
if errorlevel 49 goto xusq
if errorlevel 48 goto xuc2
if errorlevel 47 goto xsqz
if errorlevel 46 goto xsit
if errorlevel 45 goto xundef
if errorlevel 44 goto xproprietary
if errorlevel 43 goto xlharc
if errorlevel 42 goto xundef
if errorlevel 41 goto xundef
if errorlevel 40 goto xpak
if errorlevel 39 goto xlharc
if errorlevel 38 goto xproprietary
if errorlevel 37 goto xundef
if errorlevel 36 goto xlib
if errorlevel 35 goto xundef
if errorlevel 34 goto xproprietary
if errorlevel 33 goto xwin
if errorlevel 32 goto xhpack
if errorlevel 31 goto xhyp
if errorlevel 30 goto xhap
if errorlevel 29 goto xha
if errorlevel 28 goto xgz
if errorlevel 27 goto xfrz
if errorlevel 26 goto xmsc
if errorlevel 25 goto xdwc
if errorlevel 24 goto xdiet
if errorlevel 23 goto xundef
if errorlevel 22 goto xundef
if errorlevel 21 goto xgz
if errorlevel 20 goto xarj
if errorlevel 19 goto xark
if errorlevel 18 goto xundef
if errorlevel 17 goto xlharc
if errorlevel 16 goto xtext
if errorlevel 15 goto xundef
if errorlevel  1 echo * An error has occurred! >> xqaz.$$$
echo * Unable to identify the archive format.
goto exit

:xunrar
rem This display will be messed...!!!
rar %cmd% *.* >> xqaz.$$$
goto done

:xunmd
if %cmd%==%tcmd% goto untestable
mdcd r %2 . >> xqaz.$$$
goto done

:xunshrink
if %cmd%==%scmd% goto untestable
if %cmd%==%tcmd% nulib iv %2 >> xqaz.$$$
if %cmd%==%ecmd% nulib xv %2 >> xqaz.$$$
goto done

:xbinhex
if %cmd%==%scmd% goto untestable
if %cmd%==%tcmd% xbin -l %2 >> xqaz.$$$
xbin %2 >> xqaz.$$$
goto done

:xtext
type %2 >> xqaz.$$$
goto done

:xundef
echo * Don't know how to process this format! >> xqaz.$$$
goto done

:xproprietary
echo * Proprietary format. >> xqaz.$$$
goto xundef

:untestable
echo * Testing is not supported by this format. >> xqaz.$$$
goto done

:xwin
echo * The archiver for this format requires Windows. >> xqaz.$$$
goto done

:xlim
limit %cmd% %2 %3 >> xqaz.$$$
goto done

:xark
arc -%cmd% %2 %3 >> xqaz.$$$
goto done

:xarj
arj %cmd% %2 %3 >> xqaz.$$$
goto done

:xdiet
if %cmd%==%tcmd% goto untestable
diet -ra %2
goto done

:xdwc
dwc -%cmd% %2 %3 >> xqaz.$$$
goto done

:xmsc
expand %2
goto done

:xfrz
if %cmd%==%tcmd% goto untestable
freeze -%cmd%v %2 >> xqaz.$$$
goto done

:xgz
gzip -%cmd%v %2 >> xqaz.$$$
goto done

:xha
ha %cmd% %2 %3 >> xqaz.$$$
goto done

:xhap
if %cmd%==%tcmd% goto untestable
pah e %2 %3 
goto done

:xhyp
if %cmd%==%tcmd% goto untestable
hyper -x %2 %3 >> xqaz.$$$
goto done

:xhpack
if %cmd%==%tcmd% goto hpskip
hpack x %2 %3 >> xqaz.$$$
goto done
:hpskip
hpack %cmd% %2 %3 >> xqaz.$$$
goto done

:xlib
if %cmd%==%tcmd% goto untestable
lu %cmd% %2 %3 >> xqaz.$$$
goto done

:xpak
pak %cmd% %2 3 >> xqaz.$$$
goto done

:xsit
unsit %cmd% %2 >> xqaz.$$$
goto done

:xsqz
rem doesn't redirect well
sqz %cmd% %2 %3
goto done

:xuc2
rem * I don't have a copy of UC.EXE handy...
goto xundef

:xusq
if %cmd%==%tcmd% goto untestable
usq %2 >> xqaz.$$$
goto done

:xlharc
lha %cmd% %2 %3 >> xqaz.$$$
goto done   

:xcodec
if %cmd%==%tcmd% goto tcodec
codec -db %2 %3 >> xqaz.$$$
goto done
:tcodec
codec -x %2 %3 >> xqaz.$$$  
goto done

:xtar
if %cmd%==%tcmd% goto untestable
rem doesn't redirect well
tar -xvf %2 %3
goto done

:xzoo
zoo -%cmd% %2 %3 >> xqaz.$$$
goto done

:xzip
pkunzip -%cmd% %2 %3 >> xqaz.$$$
goto done

:graphics
echo * QAZ v2.60a and later versions do not handle graphics files.
goto exit

:usage
echo Usage: xqaz [v,e,t,s] archive [datafile]
echo 
goto exit

:done
if errorlevel 1 echo * An error occurred >> xqaz.$$$
if not %scmd% == %tcmd% goto show

:vscan
scan *.* /a /nomem >> xqaz.$$$
rem insert favorite virus scanners here

:show
more < xqaz.$$$

:exit
set vcmd=
set tcmd=
set ecmd=
set scmd=
if exist xqaz.$$$ erase xqaz.$$$

