/*----------------------------------------
   JUSTIFY.C -- Justify Bitmap Fonts
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include "justify.h"
#include "bmf.h"

#define LCID_FONT   1L

MRESULT EXPENTRY ClientWndProc (HWND, ULONG, MPARAM, MPARAM) ;

int main (void)
     {
     static CHAR  szClientClass [] = "Justify" ;
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU  |
                                 FCF_SIZEBORDER    | FCF_MINMAX   |
                                 FCF_SHELLPOSITION | FCF_TASKLIST |
                                 FCF_MENU ;
     HAB          hab ;
     HMQ          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;

     WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass, NULL,
                                     0L, 0, ID_RESOURCE, &hwndClient) ;

     while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0))
          WinDispatchMsg (hab, &qmsg) ;

     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

VOID Justify (HPS hps, PCHAR pText, PRECTL prcl, SHORT nAlign, SHORT nSpace)
     {
     int      iBreakCount, iSurplus ;
     PCHAR    pStart, pEnd ;
     POINTL   ptlStart, aptlTextBox [TXTBOX_COUNT] ;

     ptlStart.y = prcl->yTop ;

     do                                 // until end of text
          {
          iBreakCount = 0 ;

          while (*pText == ' ')         // Skip over leading blanks
               pText++ ;

          pStart = pText ;

          do                            // until line is known
               {
               while (*pText == ' ')    // Skip over leading blanks
                    pText++ ;

                                        // Find next break point

               while (*pText != '\x0D' && *pText != ' ')
                    pText++ ;

                                        // Determine text width

               GpiQueryTextBox (hps, pText - pStart, pStart,
                                TXTBOX_COUNT, aptlTextBox) ;

                         // Normal case: text less wide than column

               if (aptlTextBox[TXTBOX_CONCAT].x < (prcl->xRight - prcl->xLeft))
                    {
                    iBreakCount++ ;
                    pEnd = pText ;
                    }

                         // Text wider than window with only one word

               else if (iBreakCount == 0)
                    {
                    pEnd = pText ;
                    break ;
                    }

                         // Text wider than window, so fix up and get out
               else
                    {
                    iBreakCount-- ;
                    pText = pEnd ;
                    break ;
                    }
               }
          while (*pText != '\x0D') ;

                         // Get the final text box

          GpiQueryTextBox (hps, pEnd - pStart, pStart,
                           TXTBOX_COUNT, aptlTextBox) ;

                         // Drop down by maximum ascender

          ptlStart.y -= aptlTextBox[TXTBOX_TOPLEFT].y ;

                         // Find surplus space in text line

          iSurplus = prcl->xRight - prcl->xLeft -
                     aptlTextBox[TXTBOX_CONCAT].x ;

                        // Adjust starting position and
                        // space and character spacing

          switch (nAlign)
               {
               case IDM_LEFT:
                    ptlStart.x = prcl->xLeft ;
                    break ;

               case IDM_RIGHT:
                    ptlStart.x = prcl->xLeft + iSurplus ;
                    break ;

               case IDM_CENTER:
                    ptlStart.x = prcl->xLeft + iSurplus / 2 ;
                    break ;

               case IDM_JUST:
                    ptlStart.x = prcl->xLeft ;

                    if (*pText == '\x0D')
                         break ;

                    if (iBreakCount > 0)
                         GpiSetCharBreakExtra (hps,
                              65536 * iSurplus /  iBreakCount) ;

                    else if (pEnd - pStart - 1 > 0)
                         GpiSetCharExtra (hps,
                              65536 * iSurplus / (pEnd - pStart - 1)) ;
                    break ;
               }

                         // Display the string & return to normal

          GpiCharStringAt (hps, &ptlStart, pEnd - pStart, pStart) ;
          GpiSetCharExtra (hps, 0) ;
          GpiSetCharBreakExtra (hps, 0) ;

                         // Drop down by maximum descender

          ptlStart.y += aptlTextBox[TXTBOX_BOTTOMLEFT].y ;

                         // Do additional line-spacing

          switch (nSpace)
               {
               case IDM_HALF:
                    ptlStart.y -= (aptlTextBox[TXTBOX_TOPLEFT].y -
                                   aptlTextBox[TXTBOX_BOTTOMLEFT].y) / 2 ;
                    break ;

               case IDM_DOUBLE:
                    ptlStart.y -= aptlTextBox[TXTBOX_TOPLEFT].y -
                                  aptlTextBox[TXTBOX_BOTTOMLEFT].y ;
                    break ;
               }
          }

     while (*pText != '\x0D' && ptlStart.y > prcl->yBottom) ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static HWND  hwndMenu ;
     static PCHAR pText ;
     static RECTL rcl ;
     static SHORT nAlign = IDM_LEFT, nSpace = IDM_SINGLE ;
     HPS          hps ;
     
     switch (msg)
          {
          case WM_CREATE:
               DosGetResource (0, IDT_TEXT, IDT_TWAIN, (PPVOID) & pText) ;

               hwndMenu = WinWindowFromID (
                              WinQueryWindow (hwnd, QW_PARENT), FID_MENU) ;
               return 0 ;

          case WM_SIZE:
               WinQueryWindowRect (hwnd, &rcl) ;
               return 0 ;

          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDM_RIGHT:
                    case IDM_LEFT:
                    case IDM_CENTER:
                    case IDM_JUST:
                         WinCheckMenuItem (hwndMenu, nAlign, FALSE) ;
                         nAlign = COMMANDMSG(&msg)->cmd ;
                         WinCheckMenuItem (hwndMenu, nAlign, TRUE) ;

                         WinInvalidateRect (hwnd, NULL, FALSE) ;
                         return 0 ;

                    case IDM_SINGLE:
                    case IDM_HALF:
                    case IDM_DOUBLE:
                         WinCheckMenuItem (hwndMenu, nSpace, FALSE) ;
                         nSpace = COMMANDMSG(&msg)->cmd ;
                         WinCheckMenuItem (hwndMenu, nSpace, TRUE) ;

                         WinInvalidateRect (hwnd, NULL, FALSE) ;
                         return 0 ;
                    }
               break ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULLHANDLE, NULL) ;
               GpiErase (hps) ;

               CreateBitmapFont (hps, LCID_FONT, "Tms Rmn", 18, 0, 0) ;
               GpiSetCharSet (hps, LCID_FONT) ;

               Justify (hps, pText, &rcl, nAlign, nSpace) ;

               GpiSetCharSet (hps, LCID_DEFAULT) ;
               GpiDeleteSetId (hps, LCID_FONT) ;

               WinEndPaint (hps) ;
               return 0 ;

          case WM_DESTROY:
               DosFreeResource (pText) ;
               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }
