//
//  About box object for C++ OWL
//
//  Copyright 1993 by Danny Thorpe
//

#include <owl.h>
#include <owldefs.h>
#include <string.h>
#include <alloc.h>

#define  IDSHADE   100
#define  IDBUMP    101
#define  IDHOTKEY  103

class TCreditWindow : public TWindow {
public:
    HBITMAP Bitmap;
    BITMAP BitSize;
    int ScrollUnit;
    int ScrollRate;
    int ScrollPos;
    int FontHeight;
    LPSTR* StringList;
    int StringCount;

    TCreditWindow(PTWindowsObject AParent,
                  LPCSTR ABitmapName,
                  LPSTR AStringList[]);
    virtual ~TCreditWindow();
    virtual LPSTR GetClassName() {return "OWLAboutBitmap";};
    virtual void GetWindowClass(WNDCLASS& WC);
    virtual void SetupWindow();           //First place HWindow is valid 
    virtual void WMDestroy(RTMessage Msg) //Last place HWindow is valid
          = [WM_FIRST + WM_DESTROY];
    virtual void Paint(HDC DC, PAINTSTRUCT& PS);
    virtual void ShowCredits(); 
    virtual void WMTimer(RTMessage Msg)
          = [WM_FIRST + WM_TIMER];
};


_CLASSDEF(TAboutBox)      // this is potentially exportable

class TAboutBox : public TDialog {
public:
    LPCSTR Title, BitmapName;
    LPSTR* StringList;
    TCreditWindow* CreditWindow;
    TAboutBox(PTWindowsObject AParent,
              LPCSTR ATitle,
              LPCSTR ABitmapName,
              LPSTR AStringList[],
              LPSTR AResName = "dlgAbout");
    virtual ~TAboutBox();
    virtual void SetupWindow();
    virtual void InitCreditWindow(LPCSTR ABitmapName, LPSTR AStringList[]);
    virtual void ShowCredits(RTMessage Msg)= [ID_FIRST + IDHOTKEY];
};


