/*
 * ptmid.h: Header file for ptmid.
 *
 * Author: Andrew Scott  (c)opyright 1994
 *
 * Date: 17/11/1993 ver 0.0
 *       8/1/1994   ver 0.1
 */

#define MAXFILELEN 42
#define PTVER "0.1"
#define MAXPTSAMPS 31
#define MAXPTCHAN 8
#define DEFCONFIG "ptmid.cfg"

typedef char *Sz;
typedef char Fn[MAXFILELEN];

typedef struct { /** NI structure represents note info **/
	int inst, pitch, vol;
} NI;
typedef struct EI_ EI; /** EI structure represents event info **/
struct EI_ {
	unsigned long effect;
	int cni; /*** If 'cni' field is zero, effect is qpm, else duration ***/
	NI *pni;
	EI *peiNext;
};
typedef struct Tune_ Tune; /** Tune structure holds list of events **/
struct Tune_ {
	unsigned long count;
	Tune *ptune;
	EI *pei;
};

typedef struct NRL_ NRL; /** NRL structure represents note record list **/
struct NRL_ {
	int inst, vol;
	Tune *ptuneNow;
	NRL *pnrl;
};

typedef struct SI_ SI; /** SI structure represents sample info tree **/
struct SI_ {
	Sz fnSample;
	int pitch, sample;
	unsigned int wLppos, wLplen;
	SI *psiL, *psiR;
};

typedef struct { /** MS structure represents a mix of samples **/
	char szName[22];
	int bDefvol, cMix, *pwMixnote;
	SI **ppsiMix;
} MS;

extern char bDrumch, szId[5];
extern int fNocopy, fQuiet, fExtend, wPatmax, wPtchan, wQuantval;
extern unsigned wQuant;
extern SI *rgpsiDrum[128], **rgppsiIns[129], *psiTree;
extern Sz szTitle;
extern MS rgmsDecided[MAXPTSAMPS];

Tune *PtuneLoadFn(Sz);

void ResolvePtune(Tune *);

void SavePtunePfile(Tune *, FILE *);

int ValidquantSz(Sz);
