unit App28;

{ ---->>>> TApp28 <<<<--------------------------------------

  Last Update: 9/29/93
  Author: Ed Jordan

                     --- WHAT IS IT? ---
   TApp28 is a descendent of TApplication that can switch to a
   28 line text mode (using an EGA 8x14 font) on VGA adaptors.
   Since TApp28 checks for the presence of a VGA adaptor before
   it activates 28-line mode, it should operate normally on other 
   adaptors.

                     --- WHY USE IT? ---
   Use TApp28 to squeeze in a few extra lines of text without 
   resorting to the overly small 8x8, 50 line font.  Also use it
   to give another video "option" to users of your programs.

                  --- HOW DO YOU USE IT? ---
   1. List this unit in the USES clause of your TurboVision program.
   2. Descend your application object from TApp28.
   3. When you want to set the screen to 28-line mode, call

             SetScreenMode(ScreenMode or smFont8x14);

      See the HandleEvent method in the code for the demo program 
      TEST28.PAS for another example of how to use SetScreenMode.

   (smFont8x14 is a constant defined in this unit.  It has no 
   other meaning to TurboVision 2.0.)
  ------------------------------------------------------------ }

interface
uses Objects, App;


{ This constant may be incompatible with future TV versions.}
const smFont8x14 = $0200;  

type
  TApp28 = object(TApplication)
    procedure SetScreenMode (Mode: Word); virtual;
  end;

function VGADetected: Boolean;



implementation
uses Dos, Drivers;


{ The Mouse driver divides each row into 8 vertical steps.}
const MousePoints = 8;  

function VGADetected: Boolean;
var Regs: Registers;
begin
  Regs.AX := $1A00;             { Read display codes function.}
  Intr($10,Regs); 
  VGADetected := Regs.AL = $1A;
end;

procedure TApp28.SetScreenMode;
var
  CrtRows: byte absolute $0040:$0084;   { BIOS variable.}
  Regs: Registers;
  R: TRect;
begin
  { If 28 lines NOT requested, use inherited method only.}
  if Mode and smFont8x14 = 0 then
    TApplication.SetScreenMode(Mode)
  { If 28 lines requested, use inherited, then make adjustments.}
  else begin
    TApplication.SetScreenMode(Mode and not smFont8x14);
    if VGADetected then 
    begin
      ScreenMode := ScreenMode or smFont8x14;
      HideMouse;
      { Load 8x14 font.}
      Regs.AX := $1111;                      { AL=$11 loads 8x14.}
      Regs.BL := 0;                          { Load table 0.}
      Intr($10,Regs);
      { Update screen height variables.}
      ScreenHeight := 28;                    { Update TV variable.}
      CrtRows := 28;                         { Update BIOS variable.}
      { Tell mouse that screen is deeper.}
      if ButtonCount > 0 then                  { If mouse present...}
      begin
        Regs.AX := $0008;                      { Set mouse Y limits.}
        Regs.CX := 0;                          { Minimum Y.}
        Regs.DX := MousePoints*ScreenHeight-1; { Maximum Y.}
        Intr($33,Regs);
      end;
      ShowMouse;
      { Change bounds of application.}
      R.Assign(0,0,ScreenWidth,ScreenHeight);
      ChangeBounds(R);
    end;
  end;
end;

end.